/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui.dialogs;

import foxtrot.Job;
import foxtrot.Worker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameDAO;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.History;
import vars.knowledgebase.HistoryDAO;
import vars.knowledgebase.HistoryFactory;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.knowledgebase.KnowledgebaseFactory;
import vars.knowledgebase.ui.KnowledgebaseFrame;
import vars.knowledgebase.ui.StateLookup;

public class AddConceptNameDialog
extends JDialog {
    private static final long serialVersionUID = -2636179816517133686L;
    private static final Logger log = LoggerFactory.getLogger(AddConceptNameDialog.class);
    private JPanel actionPanel = null;
    private JTextField authorField = null;
    private JLabel authorLabel = null;
    private JButton cancelButton = null;
    private JLabel commonLabel = null;
    private JRadioButton commonRb = null;
    private JButton createButton = null;
    private JPanel jContentPane = null;
    private JTextField nameField = null;
    private JLabel nameLabel = null;
    private JPanel rbPanel = null;
    private JLabel synonymLabel = null;
    private JRadioButton synonymRb = null;
    private JLabel typeLabel = null;
    private JPanel viewPanel = null;
    private Concept concept;
    private final KnowledgebaseDAOFactory knowledgebaseDAOFactory;
    private final KnowledgebaseFactory knowledgebaseFactory;

    public AddConceptNameDialog(KnowledgebaseDAOFactory knowledgebaseDAOFactory, KnowledgebaseFactory knowledgebaseFactory) {
        this(null, knowledgebaseDAOFactory, knowledgebaseFactory);
    }

    public AddConceptNameDialog(Frame owner, KnowledgebaseDAOFactory knowledgebaseDAOFactory, KnowledgebaseFactory knowledgebaseFactory) throws HeadlessException {
        super(owner, "VARS - Add Concept-name");
        this.knowledgebaseDAOFactory = knowledgebaseDAOFactory;
        this.knowledgebaseFactory = knowledgebaseFactory;
        this.initialize();
    }

    private JPanel getActionPanel() {
        if (this.actionPanel == null) {
            this.actionPanel = new JPanel();
            this.actionPanel.setLayout(new BoxLayout(this.getActionPanel(), 0));
            this.actionPanel.add(Box.createHorizontalGlue());
            this.actionPanel.add((Component)this.getCreateButton(), null);
            this.actionPanel.add(Box.createHorizontalStrut(10));
            this.actionPanel.add((Component)this.getCancelButton(), null);
            this.actionPanel.add(Box.createHorizontalGlue());
        }
        return this.actionPanel;
    }

    protected JTextField getAuthorField() {
        if (this.authorField == null) {
            this.authorField = new JTextField();
        }
        return this.authorField;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddConceptNameDialog.this.setVisible(false);
                }
            });
            this.cancelButton.setText("Cancel");
        }
        return this.cancelButton;
    }

    protected JRadioButton getCommonRb() {
        if (this.commonRb == null) {
            this.commonRb = new JRadioButton();
        }
        return this.commonRb;
    }

    public Concept getConcept() {
        return this.concept;
    }

    private JButton getCreateButton() {
        if (this.createButton == null) {
            this.createButton = new JButton();
            this.createButton.setAction((Action)((Object)new AddConceptNameAction(this.knowledgebaseFactory)));
            this.createButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddConceptNameDialog.this.setVisible(false);
                }
            });
            this.createButton.setText("Add");
        }
        return this.createButton;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getViewPanel(), "Center");
            this.jContentPane.add((Component)this.getActionPanel(), "South");
        }
        return this.jContentPane;
    }

    protected JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField();
            this.nameField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.update();
                }

                private void update() {
                    boolean enable = AddConceptNameDialog.this.nameField.getText().matches("\\w+.*");
                    AddConceptNameDialog.this.getCreateButton().setEnabled(enable);
                }
            });
        }
        return this.nameField;
    }

    private JPanel getRbPanel() {
        if (this.rbPanel == null) {
            this.synonymLabel = new JLabel();
            this.synonymLabel.setText("Synonym");
            this.commonLabel = new JLabel();
            this.commonLabel.setText("Common");
            this.rbPanel = new JPanel();
            this.rbPanel.setLayout(new BoxLayout(this.getRbPanel(), 0));
            this.rbPanel.add((Component)this.commonLabel, null);
            this.rbPanel.add((Component)this.getCommonRb(), null);
            this.rbPanel.add((Component)this.synonymLabel, null);
            this.rbPanel.add((Component)this.getSynonymRb(), null);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.getCommonRb());
            buttonGroup.add(this.getSynonymRb());
        }
        return this.rbPanel;
    }

    protected JRadioButton getSynonymRb() {
        if (this.synonymRb == null) {
            this.synonymRb = new JRadioButton();
            this.synonymRb.setSelected(true);
        }
        return this.synonymRb;
    }

    private JPanel getViewPanel() {
        if (this.viewPanel == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 2;
            this.typeLabel = new JLabel();
            this.typeLabel.setText("Type:");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 1;
            this.authorLabel = new JLabel();
            this.authorLabel.setText("Author:");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.nameLabel = new JLabel();
            this.nameLabel.setText("Name:");
            this.viewPanel = new JPanel();
            this.viewPanel.setLayout(new GridBagLayout());
            this.viewPanel.add((Component)this.nameLabel, gridBagConstraints);
            this.viewPanel.add((Component)this.authorLabel, gridBagConstraints1);
            this.viewPanel.add((Component)this.typeLabel, gridBagConstraints2);
            this.viewPanel.add((Component)this.getNameField(), gridBagConstraints3);
            this.viewPanel.add((Component)this.getAuthorField(), gridBagConstraints4);
            this.viewPanel.add((Component)this.getRbPanel(), gridBagConstraints5);
        }
        return this.viewPanel;
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
        this.setLocationRelativeTo(frame);
        this.pack();
    }

    public void setConcept(Concept concept) {
        this.concept = concept;
        this.getCreateButton().setEnabled(concept != null);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.getNameField().setText("");
            this.getAuthorField().setText("");
            this.getSynonymRb().setSelected(true);
        }
    }

    private class AddConceptNameAction
    extends ActionAdapter {
        private final HistoryFactory historyFactory;

        public AddConceptNameAction(KnowledgebaseFactory knowledgebaseFactory) {
            this.historyFactory = new HistoryFactory(knowledgebaseFactory);
        }

        public void doAction() {
            Concept preexistingConcept;
            boolean okToProceed;
            Concept concept;
            String name;
            block8: {
                name = AddConceptNameDialog.this.getNameField().getText();
                concept = AddConceptNameDialog.this.getConcept();
                okToProceed = true;
                preexistingConcept = null;
                ConceptDAO conceptDAO = AddConceptNameDialog.this.knowledgebaseDAOFactory.newConceptDAO();
                try {
                    preexistingConcept = conceptDAO.findByName(name);
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block8;
                    log.error("Failed attempt to look up the concept '" + name + "'", (Throwable)e);
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                    okToProceed = false;
                }
            }
            if (okToProceed && preexistingConcept != null) {
                String preexistingName = preexistingConcept.getPrimaryConceptName().getName();
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)("The name '" + name + "' is already used by '" + preexistingName + "'. If you want to add the name to '" + concept.getPrimaryConceptName().getName() + "' you mustremove it from '" + preexistingName + "' first."));
                okToProceed = false;
            }
            if (okToProceed) {
                ConceptName conceptName = AddConceptNameDialog.this.knowledgebaseFactory.newConceptName();
                conceptName.setName(AddConceptNameDialog.this.getNameField().getText());
                conceptName.setAuthor(AddConceptNameDialog.this.getAuthorField().getText());
                String nameType = ConceptNameTypes.COMMON.toString();
                if (AddConceptNameDialog.this.getSynonymRb().isSelected()) {
                    nameType = ConceptNameTypes.SYNONYM.toString();
                }
                conceptName.setNameType(nameType);
                concept.addConceptName(conceptName);
                UserAccount userAccount = StateLookup.getUserAccount();
                History history = this.historyFactory.add(userAccount, conceptName);
                concept.getConceptMetadata().addHistory(history);
                try {
                    ConceptNameDAO conceptNameDAO = AddConceptNameDialog.this.knowledgebaseDAOFactory.newConceptNameDAO();
                    conceptNameDAO.persist(conceptName);
                    HistoryDAO historyDAO = AddConceptNameDialog.this.knowledgebaseDAOFactory.newHistoryDAO();
                    historyDAO.persist(history);
                }
                catch (Exception e) {
                    concept.removeConceptName(conceptName);
                    concept.getConceptMetadata().removeHistory(history);
                    log.error("Failed to update " + concept, (Throwable)e);
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)"Failed to save changes. Rolling back to previous state");
                }
                final KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
                if (frame != null) {
                    Worker.post((Job)new Job(){

                        public Object run() {
                            frame.refreshTreeAndOpenNode(concept.getPrimaryConceptName().getName());
                            return null;
                        }
                    });
                }
            }
        }
    }
}

