/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui.dialogs;

import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.bushe.swing.event.EventBus;
import org.jdesktop.layout.GroupLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.UserAccount;
import vars.VARSException;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.History;
import vars.knowledgebase.HistoryFactory;
import vars.knowledgebase.KnowledgebaseFactory;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.shared.ui.AllConceptNamesComboBox;
import vars.shared.ui.FancyButton;
import vars.shared.ui.GlobalStateLookup;

public class AddConceptDialog
extends JDialog {
    private static final long serialVersionUID = 6993327643414741677L;
    private static final Logger log = LoggerFactory.getLogger(AddConceptDialog.class);
    private JTextField authorField;
    private JLabel authorLabel;
    private JButton cancelButton;
    private Concept concept;
    private AllConceptNamesComboBox conceptComboBox;
    private final AddConceptDialogController controller;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField nameField;
    private JLabel nameLabel;
    private JTextField nodcField;
    private JButton okButton;
    private JLabel parentLabel;
    private JComboBox rankLevelComboBox;
    private JComboBox rankNameComboBox;
    private JTextArea referenceText;
    private JTextArea titleText;
    final ToolBelt toolBelt;

    @Inject
    public AddConceptDialog(ToolBelt toolBelt) {
        super((Frame)StateLookup.getApplicationFrame(), true);
        if (toolBelt == null) {
            throw new IllegalArgumentException("ToolBelt argument can not be null");
        }
        this.toolBelt = toolBelt;
        this.controller = new AddConceptDialogController(toolBelt);
        this.initComponents();
        this.initModel();
        this.setLocationRelativeTo(StateLookup.getApplicationFrame());
        this.pack();
        toolBelt.getPersistenceCache().addCacheClearedListener(new CacheClearedListener(){

            @Override
            public void afterClear(CacheClearedEvent evt) {
                AddConceptDialog.this.conceptComboBox.updateConceptNames();
            }

            @Override
            public void beforeClear(CacheClearedEvent evt) {
            }
        });
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setConcept(null);
    }

    private void cancelButtonKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.cancelButtonActionPerformed(null);
        }
    }

    public JComboBox getConceptComboBox() {
        return this.conceptComboBox;
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.authorLabel = new JLabel();
        this.authorField = new JTextField();
        this.nameField = new JTextField();
        this.parentLabel = new JLabel();
        this.conceptComboBox = new AllConceptNamesComboBox(this.toolBelt.getQueryPersistenceService());
        this.cancelButton = new FancyButton();
        this.okButton = new FancyButton();
        this.jScrollPane1 = new JScrollPane();
        this.titleText = new JTextArea();
        this.jLabel1 = new JLabel();
        this.nodcField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.referenceText = new JTextArea();
        this.rankNameComboBox = new JComboBox();
        this.rankLevelComboBox = new JComboBox();
        this.setTitle("VARS - Create a New Concept");
        this.nameLabel.setText("Name:");
        this.authorLabel.setText("Parent:");
        this.authorField.setToolTipText("(OPTIONAL) The author is the person who first described this species in the scientific literature");
        this.nameField.setToolTipText("The primary name to be used for this concept.");
        this.parentLabel.setText("Author:");
        this.getConceptComboBox().setModel(this.getConceptComboBox().getModel());
        this.getConceptComboBox().setSelectedItem("object");
        this.getConceptComboBox().setToolTipText("The parent concept. This concept will be a child of this parent.");
        this.cancelButton.setText("Cancel");
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/knowledgebase/delete2.png")));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddConceptDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.cancelButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AddConceptDialog.this.cancelButtonKeyReleased(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/knowledgebase/check2.png")));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddConceptDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.okButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                AddConceptDialog.this.okButtonKeyReleased(evt);
            }
        });
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.titleText.setColumns(20);
        this.titleText.setWrapStyleWord(true);
        this.titleText.setLineWrap(true);
        this.titleText.setEditable(false);
        this.titleText.setRows(5);
        this.titleText.setText("Create/edit a concept. You must provide a name and select the parent concept. All other fields are optional.");
        this.titleText.setFocusable(false);
        this.jScrollPane1.setViewportView(this.titleText);
        this.jLabel1.setText("Nodc Code:");
        this.nodcField.setToolTipText("(OPTIONAL) The nodc code is also called the Taxonomic Serial Number. More information can be found at http://www.itis.usda.gov");
        this.jLabel2.setText("Rank Name:");
        this.jLabel3.setText("Rank Level:");
        this.jLabel4.setText("Reference:");
        this.referenceText.setColumns(20);
        this.referenceText.setRows(5);
        this.referenceText.setToolTipText("(OBSOLETE) Add a property using 'dsg-reference' template instead");
        this.referenceText.setEnabled(false);
        this.jScrollPane2.setViewportView(this.referenceText);
        this.rankNameComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "kingdom", "phylum", "class", "order", "family", "genus", "species"}));
        this.rankNameComboBox.setToolTipText("(OPTIONAL) The taxonomic rank");
        this.rankLevelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "infra", "sub", "super"}));
        this.rankLevelComboBox.setToolTipText("(OPTIONAL) This modifies the taxonomic rank");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.okButton).addPreferredGap(0).add((Component)this.cancelButton)).add(2, (Component)this.jScrollPane1, -1, 360, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2).add((Component)this.jLabel3).add((Component)this.jLabel4).add((Component)this.authorLabel).add((Component)this.nameLabel).add((Component)this.parentLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.nameField, -1, 275, Short.MAX_VALUE).add(1, (Component)this.nodcField, -1, 275, Short.MAX_VALUE).add(1, (Component)this.rankNameComboBox, 0, 275, Short.MAX_VALUE).add(1, (Component)this.rankLevelComboBox, 0, 275, Short.MAX_VALUE).add((Component)this.jScrollPane2, -1, 275, Short.MAX_VALUE).add((Component)this.authorField, -1, 275, Short.MAX_VALUE).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.getConceptComboBox(), 0, 275, Short.MAX_VALUE).addPreferredGap(0))))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, -1, -2).add(13, 13, 13).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.nameLabel).add((Component)this.nameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.authorLabel).add((Component)this.getConceptComboBox(), -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.parentLabel).add((Component)this.authorField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.nodcField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.rankNameComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.rankLevelComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel4).add((Component)this.jScrollPane2, -1, 114, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancelButton).add((Component)this.okButton)).addContainerGap()));
        this.pack();
    }

    private void initModel() {
        StateLookup.selectedConceptProperty().addListener((obs, oldVal, selectedConcept) -> {
            String conceptName = "object";
            if (selectedConcept != null) {
                conceptName = selectedConcept.getPrimaryConceptName().getName();
            }
            this.getConceptComboBox().getModel().setSelectedItem(conceptName);
        });
        Concept selectedConcept2 = StateLookup.getSelectedConcept();
        String conceptName = "object";
        if (selectedConcept2 != null) {
            conceptName = selectedConcept2.getPrimaryConceptName().getName();
        }
        this.getConceptComboBox().getModel().setSelectedItem(conceptName);
    }

    private boolean isValidString(String s) {
        return s != null && s.length() > 0 && !s.matches("\\A\\s+");
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        try {
            if (this.concept == null) {
                this.concept = this.controller.createConcept();
            } else {
                this.controller.updateConcept(this.concept);
            }
        }
        catch (Exception ex) {
            log.error("User operation failed for " + this.concept, (Throwable)ex);
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)ex);
        }
        this.setConcept(null);
    }

    private void okButtonKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.okButtonActionPerformed(null);
        }
    }

    public void setConcept(Concept concept) {
        this.concept = concept;
        if (concept == null) {
            this.nameField.setEnabled(true);
            this.nameField.setText("");
            this.authorField.setText("");
            this.nodcField.setText("");
            this.rankLevelComboBox.setSelectedIndex(0);
            this.rankNameComboBox.setSelectedIndex(0);
            this.referenceText.setText("");
            this.setTitle("VARS - Create a New Concept");
        } else {
            this.nameField.setEnabled(false);
            this.nameField.setText(concept.getPrimaryConceptName().getName());
            this.authorField.setText(concept.getPrimaryConceptName().getAuthor());
            this.nodcField.setText(concept.getNodcCode());
            this.rankLevelComboBox.setSelectedItem(concept.getRankLevel());
            this.rankNameComboBox.setSelectedItem(concept.getRankName());
            this.referenceText.setText(concept.getReference());
            this.getConceptComboBox().setSelectedItem(concept.getParentConcept().getPrimaryConceptName().getName());
            this.setTitle("VARS - Edit an Existing Concept");
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.nameField.requestFocus();
        }
        super.setVisible(b);
    }

    private class AddConceptDialogController {
        private final ToolBelt toolBelt;

        public AddConceptDialogController(ToolBelt toolBelt) {
            this.toolBelt = toolBelt;
        }

        public Concept createConcept() {
            Concept concept = null;
            ConceptDAO dao = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO();
            dao.startTransaction();
            Concept parentConcept = dao.findByName((String)AddConceptDialog.this.getConceptComboBox().getSelectedItem());
            if (parentConcept == null) {
                throw new VARSException("No parent Concept was specified. You MUST Specify a parent Concept");
            }
            UserAccount userAccount = GlobalStateLookup.getUserAccount();
            String primaryName = AddConceptDialog.this.nameField.getText();
            History history = null;
            if (userAccount != null && primaryName != null) {
                Concept existingConcept = dao.findByName(primaryName);
                if (existingConcept != null && !existingConcept.getPrimaryConceptName().getName().equals(primaryName)) {
                    existingConcept = null;
                }
                if (existingConcept == null) {
                    KnowledgebaseFactory knowledgebaseFactory = this.toolBelt.getKnowledgebaseFactory();
                    concept = knowledgebaseFactory.newConcept();
                    ConceptName conceptName = knowledgebaseFactory.newConceptName();
                    conceptName.setName(primaryName);
                    conceptName.setNameType(ConceptNameTypes.PRIMARY.toString());
                    concept.addConceptName(conceptName);
                    concept.setOriginator(userAccount.getUserName());
                    String nodcCode = AddConceptDialog.this.isValidString(AddConceptDialog.this.nodcField.getText()) ? AddConceptDialog.this.nodcField.getText() : null;
                    concept.setNodcCode(nodcCode);
                    String rankName = AddConceptDialog.this.isValidString((String)AddConceptDialog.this.rankNameComboBox.getSelectedItem()) ? (String)AddConceptDialog.this.rankNameComboBox.getSelectedItem() : null;
                    concept.setRankName(rankName);
                    String rankLevel = AddConceptDialog.this.isValidString((String)AddConceptDialog.this.rankLevelComboBox.getSelectedItem()) ? (String)AddConceptDialog.this.rankLevelComboBox.getSelectedItem() : null;
                    concept.setRankLevel(rankLevel);
                    String reference = AddConceptDialog.this.isValidString(AddConceptDialog.this.referenceText.getText()) ? AddConceptDialog.this.referenceText.getText() : null;
                    concept.setReference(reference);
                    String author = AddConceptDialog.this.authorField.getText();
                    if (AddConceptDialog.this.isValidString(author)) {
                        conceptName.setAuthor(author);
                    } else {
                        conceptName.setAuthor(null);
                    }
                    parentConcept.addChildConcept(concept);
                    dao.persist(concept);
                    history = this.toolBelt.getHistoryFactory().add(userAccount, concept);
                    parentConcept.getConceptMetadata().addHistory(history);
                    dao.persist(history);
                } else {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("The name '" + primaryName + "' already exists in the database."));
                }
            }
            dao.endTransaction();
            dao.close();
            if (history != null) {
                EventBus.publish((String)"vars.knowledgebase.ui.Lookup-ApproveHistory", history);
            }
            return concept;
        }

        void updateConcept(Concept concept) {
            String reference;
            String rankLevel;
            String rankName;
            String nodcCode;
            UserAccount userAccount = StateLookup.getUserAccount();
            HistoryFactory historyFactory = this.toolBelt.getHistoryFactory();
            ArrayList<History> histories = new ArrayList<History>();
            String parentName = (String)AddConceptDialog.this.getConceptComboBox().getSelectedItem();
            ConceptDAO conceptDAO = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO();
            conceptDAO.startTransaction();
            concept = conceptDAO.find(concept);
            Concept oldParentConcept = concept.getParentConcept();
            Concept newParentConcept = conceptDAO.findByName(parentName);
            boolean hasDescendent = concept.hasDescendent(parentName);
            if (hasDescendent) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("The parent that you specified, '" + parentName + "', is already a child of '" + concept.getPrimaryConceptName().getName() + "'. This is not allowed. Your request to move the concept is being ignored."));
            } else if (!newParentConcept.equals(oldParentConcept) && !newParentConcept.equals(concept)) {
                if (oldParentConcept != null) {
                    oldParentConcept.removeChildConcept(concept);
                }
                newParentConcept.addChildConcept(concept);
                History history1 = historyFactory.replaceParentConcept(userAccount, oldParentConcept, newParentConcept);
                concept.getConceptMetadata().addHistory(history1);
                conceptDAO.persist(history1);
                histories.add(history1);
            }
            String oldNodcCode = concept.getNodcCode();
            String string = nodcCode = AddConceptDialog.this.isValidString(AddConceptDialog.this.nodcField.getText()) ? AddConceptDialog.this.nodcField.getText() : null;
            if (nodcCode != null && !nodcCode.equals(oldNodcCode) || nodcCode == null && oldNodcCode != null) {
                History history2 = historyFactory.replaceNodcCode(userAccount, oldNodcCode, nodcCode);
                concept.getConceptMetadata().addHistory(history2);
                conceptDAO.persist(history2);
                concept.setNodcCode(nodcCode);
                histories.add(history2);
            }
            String oldRankName = concept.getRankName();
            String string2 = rankName = AddConceptDialog.this.isValidString((String)AddConceptDialog.this.rankNameComboBox.getSelectedItem()) ? (String)AddConceptDialog.this.rankNameComboBox.getSelectedItem() : null;
            if (rankName != null && !rankName.equals(oldRankName) || rankName == null && oldRankName != null) {
                History history3 = historyFactory.replaceRankName(userAccount, oldRankName, rankName);
                concept.getConceptMetadata().addHistory(history3);
                concept.setRankName(rankName);
                conceptDAO.persist(history3);
                histories.add(history3);
            }
            String oldRankLevel = concept.getRankLevel();
            String string3 = rankLevel = AddConceptDialog.this.isValidString((String)AddConceptDialog.this.rankLevelComboBox.getSelectedItem()) ? (String)AddConceptDialog.this.rankLevelComboBox.getSelectedItem() : null;
            if (rankLevel != null && !rankLevel.equals(oldRankLevel) || rankLevel == null && oldRankLevel != null) {
                History history4 = historyFactory.replaceRankLevel(userAccount, oldRankLevel, rankLevel);
                concept.getConceptMetadata().addHistory(history4);
                concept.setRankLevel(rankLevel);
                conceptDAO.persist(history4);
                histories.add(history4);
            }
            String oldReference = concept.getReference();
            String string4 = reference = AddConceptDialog.this.isValidString(AddConceptDialog.this.referenceText.getText()) ? AddConceptDialog.this.referenceText.getText() : null;
            if (reference != null && !reference.equals(oldReference) || reference == null && oldReference != null) {
                History history5 = historyFactory.replaceReference(userAccount, oldReference, reference);
                concept.getConceptMetadata().addHistory(history5);
                concept.setReference(reference);
                conceptDAO.persist(history5);
                histories.add(history5);
            }
            String author = AddConceptDialog.this.authorField.getText();
            ConceptName primaryName = concept.getPrimaryConceptName();
            if (AddConceptDialog.this.isValidString(author)) {
                primaryName.setAuthor(author);
            } else {
                primaryName.setAuthor(null);
            }
            conceptDAO.endTransaction();
            conceptDAO.close();
            EventBus.publish((String)"vars.knowledgebase.ui.Lookup-ApproveHistories", histories);
        }
    }
}

