/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.inject.Inject;
import foxtrot.Job;
import foxtrot.Worker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.mbari.swing.LabeledSpinningDialWaitIndicator;
import vars.DAO;
import vars.ILink;
import vars.LinkBean;
import vars.LinkUtilities;
import vars.UserAccount;
import vars.annotation.Observation;
import vars.annotation.ObservationDAO;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptMetadata;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.History;
import vars.knowledgebase.LinkRealization;
import vars.knowledgebase.LinkTemplate;
import vars.knowledgebase.Media;
import vars.knowledgebase.MediaDAO;
import vars.knowledgebase.ui.KnowledgebaseFrame;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.knowledgebase.ui.actions.AbstractHistoryTask;

public class RejectHistoryTask
extends AbstractHistoryTask {
    private final Map<String, Map<String, GenericRejectTask>> actionMap = new HashMap<String, Map<String, GenericRejectTask>>();
    private final GenericRejectTask DEFAULT_TASK;
    private final ToolBelt toolBelt;

    @Inject
    public RejectHistoryTask(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.DEFAULT_TASK = new GenericRejectTask();
        HashMap<String, GenericRejectTask> addMap = new HashMap<String, GenericRejectTask>();
        this.actionMap.put("ADD", addMap);
        addMap.put("Concept", this.DEFAULT_TASK);
        addMap.put("Concept.child", new AddConceptTask());
        addMap.put("ConceptName", new AddConceptNameTask());
        addMap.put("LinkRealization", new AddLinkRealizationTask());
        addMap.put("LinkTemplate", new AddLinkTemplateTask());
        addMap.put("Media", new AddMediaTask());
        addMap.put("SectionInfo", this.DEFAULT_TASK);
        HashMap<String, GenericRejectTask> deleteMap = new HashMap<String, GenericRejectTask>();
        this.actionMap.put("DELETE", deleteMap);
        deleteMap.put("Concept.child", this.DEFAULT_TASK);
        deleteMap.put("ConceptName", this.DEFAULT_TASK);
        deleteMap.put("LinkRealization", this.DEFAULT_TASK);
        deleteMap.put("LinkTemplate", this.DEFAULT_TASK);
        deleteMap.put("Media", this.DEFAULT_TASK);
        deleteMap.put("SectionInfo", this.DEFAULT_TASK);
        HashMap<String, GenericRejectTask> replaceMap = new HashMap<String, GenericRejectTask>();
        this.actionMap.put("REPLACE", replaceMap);
        replaceMap.put("Concept.parent", new ReplaceParentConceptTask());
        replaceMap.put("NodcCode", new ReplaceNodcCodeTask());
        replaceMap.put("RankName", new ReplaceRankNameTask());
        replaceMap.put("RankLevel", new ReplaceRankLevelTask());
        replaceMap.put("Reference", new ReplaceReferenceTask());
        replaceMap.put("ConceptName", new ReplaceConceptNameTask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTask(UserAccount userAccount, History history) {
        DAO dao = this.toolBelt.getKnowledgebaseDAOFactory().newDAO();
        try {
            dao.startTransaction();
            try {
                history = dao.merge(history);
            }
            catch (Exception e) {
                history = dao.find(history);
            }
            this.reject(userAccount, history, dao);
        }
        catch (Exception e) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
        }
        finally {
            dao.endTransaction();
            dao.close();
        }
    }

    private LabeledSpinningDialWaitIndicator newWaitIndicator() {
        return (LabeledSpinningDialWaitIndicator)Worker.post((Job)new Job(){

            public Object run() {
                KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
                return new LabeledSpinningDialWaitIndicator((JFrame)frame);
            }
        });
    }

    public void reject(UserAccount userAccount, History history, DAO dao) {
        if (history != null && !history.isProcessed()) {
            Map<String, GenericRejectTask> rejectActions;
            GenericRejectTask processer;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Rejecting " + history);
            }
            if ((processer = (rejectActions = this.actionMap.get(history.getAction())).get(history.getField())) == null) {
                processer = this.DEFAULT_TASK;
            }
            processer.reject(userAccount, history, dao);
        }
    }

    private void updateWaitIndicator(final LabeledSpinningDialWaitIndicator waitIndicator, final String msg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                waitIndicator.setLabel(msg);
            }
        });
    }

    private class ReplaceReferenceTask
    extends GenericRejectTask {
        private ReplaceReferenceTask() {
        }

        @Override
        public void reject(UserAccount userAccount, History history, DAO dao) {
            if (ReplaceReferenceTask.canDo(userAccount, history)) {
                Concept concept = history.getConceptMetadata().getConcept();
                String currentValue = concept.getReference();
                String newValue = history.getNewValue();
                if (currentValue != null && currentValue.equals(newValue) || newValue != null && newValue.equals(currentValue)) {
                    concept.setReference(history.getOldValue());
                    super.reject(userAccount, history, dao);
                } else {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"Unable to reject this history. The Reference has been modified since this history was created.");
                }
            }
        }
    }

    private class ReplaceRankNameTask
    extends GenericRejectTask {
        private ReplaceRankNameTask() {
        }

        @Override
        public void reject(UserAccount userAccount, History history, DAO dao) {
            if (ReplaceRankNameTask.canDo(userAccount, history)) {
                Concept concept = history.getConceptMetadata().getConcept();
                String currentValue = concept.getRankName();
                String newValue = history.getNewValue();
                if (currentValue != null && currentValue.equals(newValue) || newValue != null && newValue.equals(currentValue)) {
                    concept.setRankName(history.getOldValue());
                    super.reject(userAccount, history, dao);
                } else {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"Unable to reject this history. The Rank Name has been modified since this history was created.");
                }
            }
        }
    }

    private class ReplaceRankLevelTask
    extends GenericRejectTask {
        private ReplaceRankLevelTask() {
        }

        @Override
        public void reject(UserAccount userAccount, History history, DAO dao) {
            if (ReplaceRankLevelTask.canDo(userAccount, history)) {
                Concept concept = history.getConceptMetadata().getConcept();
                String currentValue = concept.getRankLevel();
                String newValue = history.getNewValue();
                if (currentValue != null && currentValue.equals(newValue) || newValue != null && newValue.equals(currentValue)) {
                    concept.setRankLevel(history.getOldValue());
                    super.reject(userAccount, history, dao);
                } else {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"Unable to reject this history. The Rank Level has been modified since this history was created.");
                }
            }
        }
    }

    private class ReplaceParentConceptTask
    extends GenericRejectTask {
        private ReplaceParentConceptTask() {
        }

        @Override
        public void reject(UserAccount userAccount, History history, DAO dao) {
            if (ReplaceParentConceptTask.canDo(userAccount, history)) {
                ConceptDAO conceptDAO = RejectHistoryTask.this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO(dao.getEntityManager());
                final Concept concept = history.getConceptMetadata().getConcept();
                Concept currentParent = concept.getParentConcept();
                Concept newParent = null;
                Concept oldParent = null;
                conceptDAO.startTransaction();
                try {
                    history = conceptDAO.merge(history);
                    newParent = conceptDAO.findByName(history.getNewValue());
                    oldParent = conceptDAO.findByName(history.getOldValue());
                }
                catch (Exception e) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                }
                conceptDAO.endTransaction();
                if (currentParent.equals(newParent)) {
                    if (oldParent != null) {
                        conceptDAO.startTransaction();
                        oldParent = conceptDAO.merge(oldParent);
                        Collection<Concept> descendents = conceptDAO.findDescendents(oldParent);
                        conceptDAO.endTransaction();
                        Collection matches = Collections2.filter(descendents, (Predicate)new Predicate<Concept>(){

                            public boolean apply(Concept input) {
                                return input.getPrimaryConceptName().getName().equals(concept.getPrimaryConceptName().getName());
                            }
                        });
                        if (matches.size() > 0) {
                            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)("'" + oldParent.getPrimaryConceptName().getName() + "' already has a child named '" + concept.getPrimaryConceptName().getName() + "'. Unable to process your request."));
                            return;
                        }
                        currentParent.removeChildConcept(concept);
                        oldParent.addChildConcept(concept);
                        super.reject(userAccount, history, dao);
                    } else {
                        EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)("Unable to find the original parent. Unable to move '" + concept.getPrimaryConceptName().getName() + "' back to it's previous state."));
                    }
                } else {
                    String message = null;
                    message = newParent != null ? "The concept, '" + concept.getPrimaryConceptName().getName() + "' was a child of '" + newParent.getPrimaryConceptName().getName() + "' when this history was created. However, it's now a child of '" + currentParent.getPrimaryConceptName().getName() + "'. Unable to move it back to it's previous state." : "The concept, '" + history.getNewValue() + "' was not found in the knowledgebase. It may have been deleted or renamed. Unable to move '" + concept.getPrimaryConceptName().getName() + "' back to it's previous state.";
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)message);
                }
            }
        }
    }

    private class ReplaceNodcCodeTask
    extends GenericRejectTask {
        private ReplaceNodcCodeTask() {
        }

        @Override
        public void reject(UserAccount userAccount, History history, DAO dao) {
            if (ReplaceNodcCodeTask.canDo(userAccount, history)) {
                Concept concept = history.getConceptMetadata().getConcept();
                String currentValue = concept.getNodcCode();
                String newValue = history.getNewValue();
                if (currentValue != null && currentValue.equals(newValue) || newValue != null && newValue.equals(currentValue)) {
                    concept.setNodcCode(history.getOldValue());
                    super.reject(userAccount, history, dao);
                } else {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"Unable to reject this history. The NODC Code has been modified since this history was created.");
                }
            }
        }
    }

    private class ReplaceConceptNameTask
    extends GenericRejectTask {
        private ReplaceConceptNameTask() {
        }

        @Override
        public void reject(UserAccount userAccount, History history, DAO dao) {
            if (ReplaceConceptNameTask.canDo(userAccount, history)) {
                final Concept concept = history.getConceptMetadata().getConcept();
                ConceptName conceptName = concept.getConceptName(history.getNewValue());
                if (conceptName == null) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("Unable to find a concept named '" + history.getNewValue() + "'associated with '" + concept.getPrimaryConceptName().getName() + "'. Unable to reject this history."));
                } else {
                    ConceptDAO conceptDAO = RejectHistoryTask.this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO(dao.getEntityManager());
                    Concept duplicate = conceptDAO.findByName(history.getOldValue());
                    if (duplicate == null) {
                        conceptName.setName(history.getOldValue());
                        Thread thread = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    RejectHistoryTask.this.toolBelt.getKnowledgebasePersistenceService().updateConceptNameUsedByLinkTemplates(concept);
                                    RejectHistoryTask.this.toolBelt.getAnnotationPersistenceService().updateConceptNameUsedByAnnotations(concept);
                                }
                                catch (Exception e) {
                                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                                }
                            }
                        }, "Update thread for annotations named " + history.getOldValue());
                        thread.setDaemon(false);
                        thread.start();
                        super.reject(userAccount, history, dao);
                    } else {
                        this.dropHistory(history, "Unable to reject this history. The name '" + history.getOldValue() + "' exists in the knowledgebase.", dao);
                    }
                }
            }
        }
    }

    private class GenericRejectTask
    extends AbstractHistoryTask {
        private GenericRejectTask() {
        }

        @Override
        public void doTask(UserAccount userAccount, History history) {
            throw new UnsupportedOperationException("Don't call doTask(), call reject() instead.");
        }

        public void reject(UserAccount userAccount, History history, DAO dao) {
            if (GenericRejectTask.canDo(userAccount, history)) {
                history.setProcessedDate(new Date());
                history.setApproved(Boolean.FALSE);
                history.setProcessorName(userAccount.getUserName());
            }
        }
    }

    private class AddMediaTask
    extends GenericRejectTask {
        private AddMediaTask() {
        }

        @Override
        public void reject(UserAccount userAccount, History history, DAO dao) {
            if (AddMediaTask.canDo(userAccount, history)) {
                MediaDAO mediaDAO = RejectHistoryTask.this.toolBelt.getKnowledgebaseDAOFactory().newMediaDAO();
                mediaDAO.startTransaction();
                history = mediaDAO.find(history);
                ConceptMetadata conceptMetadata = history.getConceptMetadata();
                HashSet<Media> mediaSet = new HashSet<Media>(conceptMetadata.getMedias());
                final History aHistory = history;
                Collection matches = Collections2.filter(mediaSet, (Predicate)new Predicate<Media>(){

                    public boolean apply(Media input) {
                        return input.getUrl().equals(aHistory.getNewValue());
                    }
                });
                for (Media media : matches) {
                    conceptMetadata.removeMedia(media);
                    mediaDAO.remove(media);
                }
                mediaDAO.endTransaction();
                mediaDAO.close();
                super.reject(userAccount, history, dao);
            }
        }
    }

    private class AddLinkTemplateTask
    extends GenericRejectTask {
        private AddLinkTemplateTask() {
        }

        @Override
        public void reject(UserAccount userAccount, History history, DAO dao) {
            if (!AddLinkTemplateTask.canDo(userAccount, history)) {
                return;
            }
            LinkBean linkBean = new LinkBean(history.getNewValue());
            LinkTemplate exampleTemplate = RejectHistoryTask.this.toolBelt.getKnowledgebaseFactory().newLinkTemplate();
            exampleTemplate.setLinkName(linkBean.getLinkName());
            exampleTemplate.setToConcept(linkBean.getToConcept());
            exampleTemplate.setLinkValue(linkBean.getLinkValue());
            ConceptMetadata conceptMetadata = history.getConceptMetadata();
            ArrayList<ILink> linkTemplates = new ArrayList<ILink>(conceptMetadata.getLinkTemplates());
            Collection<ILink> matchingLinks = LinkUtilities.findMatchingLinksIn(linkTemplates, exampleTemplate);
            LinkTemplate linkTemplate = (LinkTemplate)(matchingLinks.size() > 0 ? matchingLinks.iterator().next() : null);
            if (linkTemplate != null) {
                KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
                int option = JOptionPane.showConfirmDialog(frame, "Are you sure you want to delete '" + history.getNewValue() + "' ? Be aware that this will not effect existing annotations that use it.", "VARS - Delete LinkTemplate", 0, 2);
                if (option != 0) {
                    return;
                }
                conceptMetadata.removeLinkTemplate(linkTemplate);
                dao.remove(linkTemplate);
            }
            super.reject(userAccount, history, dao);
        }
    }

    private class AddLinkRealizationTask
    extends GenericRejectTask {
        private AddLinkRealizationTask() {
        }

        @Override
        public void reject(UserAccount userAccount, History history, DAO dao) {
            if (!AddLinkRealizationTask.canDo(userAccount, history)) {
                return;
            }
            LinkBean linkBean = new LinkBean(history.getNewValue());
            LinkRealization exampleRealization = RejectHistoryTask.this.toolBelt.getKnowledgebaseFactory().newLinkRealization();
            exampleRealization.setLinkName(linkBean.getLinkName());
            exampleRealization.setToConcept(linkBean.getToConcept());
            exampleRealization.setLinkValue(linkBean.getLinkValue());
            ConceptMetadata conceptMetadata = history.getConceptMetadata();
            ArrayList<ILink> linkRealizations = new ArrayList<ILink>(conceptMetadata.getLinkRealizations());
            Collection<ILink> matchingLinks = LinkUtilities.findMatchingLinksIn(linkRealizations, exampleRealization);
            LinkRealization linkRealization = (LinkRealization)(matchingLinks.size() > 0 ? matchingLinks.iterator().next() : null);
            if (linkRealization != null) {
                KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
                int option = JOptionPane.showConfirmDialog(frame, "Are you sure you want to delete '" + history.getNewValue() + "' ? Be aware that this will not effect existing annotations that use it.", "VARS - Delete LinkTemplate", 0, 2);
                if (option != 0) {
                    return;
                }
                conceptMetadata.removeLinkRealization(linkRealization);
                dao.remove(linkRealization);
            }
            super.reject(userAccount, history, dao);
        }
    }

    private class AddConceptTask
    extends GenericRejectTask {
        private AddConceptTask() {
        }

        @Override
        public void reject(UserAccount userAccount, History history, DAO dao) {
            if (!AddConceptTask.canDo(userAccount, history)) {
                return;
            }
            String rejectedName = history.getNewValue();
            ConceptDAO conceptDAO = RejectHistoryTask.this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO(dao.getEntityManager());
            Concept parentConcept = history.getConceptMetadata().getConcept();
            Concept rejectedConcept = conceptDAO.findByName(rejectedName);
            if (rejectedConcept == null) {
                this.dropHistory(history, "Unable to find a concept with the name '" + rejectedName + "' in the knowledgebase. I'll drop the history reference", dao);
                return;
            }
            if (!parentConcept.getChildConcepts().contains(rejectedConcept)) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("The concept with the name '" + rejectedName + "' is no longer a child of '" + parentConcept.getPrimaryConceptName().getName() + "'. Moving the history to the correct concept."));
                Concept newParentConcept = rejectedConcept.getParentConcept();
                parentConcept.getConceptMetadata().removeHistory(history);
                newParentConcept.getConceptMetadata().addHistory(history);
                return;
            }
            Collection<Concept> conceptsToBeDeleted = conceptDAO.findDescendents(rejectedConcept);
            KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
            int option = JOptionPane.showConfirmDialog(frame, "You are about to delete " + conceptsToBeDeleted.size() + " concept(s) from the \nknowledgebase. Are you sure you want to continue?", "VARS - Delete Concepts", 0, 2);
            if (option != 0) {
                return;
            }
            ObservationDAO observationDAO = RejectHistoryTask.this.toolBelt.getAnnotationDAOFactory().newObservationDAO();
            observationDAO.startTransaction();
            List<Observation> observations = observationDAO.findAllByConcept(rejectedConcept, true, conceptDAO);
            String newName = parentConcept.getPrimaryConceptName().getName();
            String msg = observations.size() + " Observations were found using '" + rejectedName + "' or one of it's \nchildren. Do you want to update the names to '" + newName + "' or \nignore them and leave them as is?";
            Object[] options = new Object[]{"Update", "Ignore", "Cancel"};
            option = JOptionPane.showOptionDialog(frame, msg, "VARS - Removing '" + rejectedName + "'", 1, 3, null, options, options[2]);
            switch (option) {
                case 0: {
                    for (Observation observation : observations) {
                        observation.setConceptName(newName);
                    }
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
            observationDAO.endTransaction();
            observationDAO.close();
            conceptDAO.endTransaction();
            conceptDAO.cascadeRemove(rejectedConcept);
            dao.startTransaction();
            super.reject(userAccount, history, dao);
        }
    }

    private class AddConceptNameTask
    extends GenericRejectTask {
        private AddConceptNameTask() {
        }

        @Override
        public void reject(UserAccount userAccount, History history, DAO dao) {
            if (!AddConceptNameTask.canDo(userAccount, history)) {
                return;
            }
            ConceptDAO conceptDAO = RejectHistoryTask.this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO(dao.getEntityManager());
            String name = history.getNewValue();
            Concept thatConcept = conceptDAO.findByName(name);
            conceptDAO.close();
            if (thatConcept == null) {
                this.dropHistory(history, "The concept-name, '" + name + "' no longer exists in the knowledgebase. I'll remove this history from the database", dao);
                return;
            }
            final Concept thisConcept = history.getConceptMetadata().getConcept();
            if (thisConcept.equals(thatConcept)) {
                if (thisConcept.getPrimaryConceptName().getName().equals(name)) {
                    this.dropHistory(history, "Sorry, can't remove the primary concept name. We'll drop the history instead", dao);
                } else {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                RejectHistoryTask.this.toolBelt.getKnowledgebasePersistenceService().updateConceptNameUsedByLinkTemplates(thisConcept);
                                RejectHistoryTask.this.toolBelt.getAnnotationPersistenceService().updateConceptNameUsedByAnnotations(thisConcept);
                            }
                            catch (Exception e) {
                                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                            }
                        }
                    }, "Update thread for annotations named " + thisConcept.getPrimaryConceptName().getName());
                    thread.setDaemon(false);
                    thread.start();
                    ConceptName conceptName = thisConcept.getConceptName(name);
                    thisConcept.removeConceptName(conceptName);
                    super.reject(userAccount, history, dao);
                }
            } else {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"The history appears to be attached to the wrong concept. Moving it to the correct one.");
                thisConcept.getConceptMetadata().removeHistory(history);
                thatConcept.getConceptMetadata().addHistory(history);
            }
        }
    }
}

