/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui.actions;

import java.awt.Frame;
import java.util.Collection;
import javax.swing.JOptionPane;
import org.mbari.awt.event.ActionAdapter;
import vars.MiscDAOFactory;
import vars.MiscFactory;
import vars.UserAccount;
import vars.UserAccountDAO;
import vars.UserAccountRoles;
import vars.VARSPersistenceException;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.KnowledgebaseFactory;
import vars.knowledgebase.ui.KnowledgebaseFrame;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.shared.ui.dialogs.CreateUserAccountDialog;

public class PopulateDatabaseAction
extends ActionAdapter {
    private final KnowledgebaseFactory knowledgebaseFactory;
    private final MiscFactory miscFactory;
    private final ToolBelt toolBelt;

    public PopulateDatabaseAction(ToolBelt toolBelt) {
        this.knowledgebaseFactory = toolBelt.getKnowledgebaseFactory();
        this.miscFactory = toolBelt.getMiscFactory();
        this.toolBelt = toolBelt;
    }

    public void doAction() {
        boolean ok = false;
        try {
            ok = this.checkRootConcept();
            ok = this.checkAdmin();
        }
        catch (Exception ex) {
            throw new VARSPersistenceException("Failed to fully initialize knowledgebase", ex);
        }
        if (!ok) {
            throw new VARSPersistenceException("Failed to fully initialize the knowledgbase");
        }
    }

    private boolean checkRootConcept() {
        KnowledgebaseFrame frame;
        int ok;
        boolean gotRoot;
        ConceptDAO conceptDAO = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO();
        conceptDAO.startTransaction();
        Concept root = conceptDAO.findRoot();
        boolean bl = gotRoot = root != null;
        if (!gotRoot && (ok = JOptionPane.showConfirmDialog(frame = StateLookup.getApplicationFrame(), "Unable to find the root of the knowledgebase. Do you want to create one?", "VARS - No Root Found", 0, 2)) == 0) {
            ConceptName conceptName = this.knowledgebaseFactory.newConceptName();
            conceptName.setNameType(ConceptNameTypes.PRIMARY.toString());
            conceptName.setName("object");
            conceptName.setAuthor("VARS");
            Concept concept = this.knowledgebaseFactory.newConcept();
            concept.addConceptName(conceptName);
            concept.setOriginator("VARS");
            conceptDAO.persist(concept);
            gotRoot = true;
        }
        conceptDAO.endTransaction();
        conceptDAO.close();
        return gotRoot;
    }

    private boolean checkAdmin() {
        UserAccount admin;
        KnowledgebaseFrame frame;
        int ok;
        boolean gotAdmins;
        UserAccountDAO userAccountDAO = this.toolBelt.getMiscDAOFactory().newUserAccountDAO();
        userAccountDAO.startTransaction();
        Collection<UserAccount> admins = userAccountDAO.findAllByRole(UserAccountRoles.ADMINISTRATOR.toString());
        userAccountDAO.endTransaction();
        boolean bl = gotAdmins = admins.size() != 0;
        if (!gotAdmins && (ok = JOptionPane.showConfirmDialog(frame = StateLookup.getApplicationFrame(), "Unable to find any Administrator accounts. Do you want to create one?", "VARS - No Administrator Found", 0, 2)) == 0 && (admin = CreateUserAccountDialog.showDialog((Frame)frame, (boolean)true, (String)"VARS - Create Administrator Account", (MiscDAOFactory)this.toolBelt.getMiscDAOFactory(), (MiscFactory)this.miscFactory)) != null) {
            userAccountDAO.startTransaction();
            admin.setRole(UserAccountRoles.ADMINISTRATOR.toString());
            userAccountDAO.merge(admin);
            userAccountDAO.endTransaction();
            gotAdmins = true;
        }
        userAccountDAO.close();
        return gotAdmins;
    }
}

