/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.bushe.swing.event.EventBus;
import vars.DAO;
import vars.ILink;
import vars.LinkBean;
import vars.LinkUtilities;
import vars.UserAccount;
import vars.annotation.Observation;
import vars.annotation.ObservationDAO;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptMetadata;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameDAO;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.History;
import vars.knowledgebase.LinkRealization;
import vars.knowledgebase.LinkTemplate;
import vars.knowledgebase.Media;
import vars.knowledgebase.ui.KnowledgebaseFrame;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.knowledgebase.ui.actions.AbstractHistoryTask;
import vars.knowledgebase.ui.actions.IApproveHistoryTask;

public class ApproveHistoryTask
extends AbstractHistoryTask {
    private final Map<String, Map<String, GenericApproveTask>> actionMap = new HashMap<String, Map<String, GenericApproveTask>>();
    private final GenericApproveTask DEFAULT_TASK;
    private final ToolBelt toolBelt;

    @Inject
    public ApproveHistoryTask(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.DEFAULT_TASK = new GenericApproveTask();
        HashMap<String, GenericApproveTask> addMap = new HashMap<String, GenericApproveTask>();
        this.actionMap.put("ADD", addMap);
        addMap.put("Concept.child", this.DEFAULT_TASK);
        addMap.put("ConceptName", this.DEFAULT_TASK);
        addMap.put("LinkRealization", this.DEFAULT_TASK);
        addMap.put("LinkTemplate", this.DEFAULT_TASK);
        addMap.put("Media", this.DEFAULT_TASK);
        HashMap<String, GenericApproveTask> deleteMap = new HashMap<String, GenericApproveTask>();
        this.actionMap.put("DELETE", deleteMap);
        deleteMap.put("Concept.child", new ADeleteChildConceptTask());
        deleteMap.put("ConceptName", new ADeleteConceptNameAction());
        deleteMap.put("LinkRealization", new ADeleteLinkRealizationTask());
        deleteMap.put("LinkTemplate", new ADeleteLinkTemplateTask());
        deleteMap.put("Media", new ADeleteMediaTask());
        HashMap<String, GenericApproveTask> replaceMap = new HashMap<String, GenericApproveTask>();
        this.actionMap.put("REPLACE", replaceMap);
        replaceMap.put("Concept.parent", this.DEFAULT_TASK);
    }

    public void approve(UserAccount userAccount, History history, DAO dao) {
        if (history != null && !history.isProcessed()) {
            Map<String, GenericApproveTask> approveActions;
            GenericApproveTask processer;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Approving " + history);
            }
            if ((processer = (approveActions = this.actionMap.get(history.getAction())).get(history.getField())) == null) {
                processer = this.DEFAULT_TASK;
            }
            processer.approve(userAccount, history, dao);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doTask(UserAccount userAccount, History history) {
        DAO dao = this.toolBelt.getKnowledgebaseDAOFactory().newDAO();
        try {
            dao.startTransaction();
            try {
                history = dao.merge(history);
            }
            catch (Exception e) {
                history = dao.find(history);
            }
            this.approve(userAccount, history, dao);
        }
        catch (Exception e) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
        }
        finally {
            dao.endTransaction();
            dao.close();
        }
    }

    public void doTask(UserAccount userAccount, Collection<? extends History> histories) {
        DAO dao = this.toolBelt.getKnowledgebaseDAOFactory().newDAO();
        for (History history : histories) {
            if (history.isProcessed()) continue;
            try {
                dao.startTransaction();
                History history2 = dao.find(history);
                this.approve(userAccount, history2, dao);
            }
            catch (Exception e) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
            }
        }
        dao.endTransaction();
        dao.close();
    }

    private class GenericApproveTask
    extends AbstractHistoryTask
    implements IApproveHistoryTask {
        private GenericApproveTask() {
        }

        @Override
        public void approve(UserAccount userAccount, History history, DAO dao) {
            if (GenericApproveTask.canDo(userAccount, history)) {
                history.setProcessedDate(new Date());
                history.setProcessorName(userAccount.getUserName());
                history.setApproved(Boolean.TRUE);
            } else {
                String msg = "Unable to approve the History [" + history + "]";
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)msg);
            }
        }

        @Override
        public void doTask(UserAccount userAccount, History history) {
            throw new UnsupportedOperationException("Don't call doTask(), call approve() instead!");
        }
    }

    private class ADeleteMediaTask
    extends GenericApproveTask {
        private ADeleteMediaTask() {
        }

        @Override
        public void approve(UserAccount userAccount, History history, DAO dao) {
            if (ADeleteMediaTask.canDo(userAccount, history)) {
                final String imageReference = history.getOldValue();
                KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
                int option = JOptionPane.showConfirmDialog(frame, "Are you sure you want to delete '" + imageReference + "' ? ", "VARS - Delete Media", 0, 2);
                if (option != 0) {
                    return;
                }
                ConceptMetadata conceptMetadata = history.getConceptMetadata();
                ArrayList<Media> medias = new ArrayList<Media>(conceptMetadata.getMedias());
                Collection matchingMedia = Collections2.filter(medias, (Predicate)new Predicate<Media>(){

                    public boolean apply(Media input) {
                        return input.getUrl().equals(imageReference);
                    }
                });
                Media media = null;
                if (matchingMedia.size() > 0) {
                    media = (Media)matchingMedia.iterator().next();
                    conceptMetadata.removeMedia(media);
                    dao.remove(media);
                    super.approve(userAccount, history, dao);
                } else {
                    this.dropHistory(history, "Unable to locate '" + imageReference + "'. It may have \nbeen moved. I'll remove the History reference.", dao);
                }
            }
        }
    }

    private class ADeleteLinkTemplateTask
    extends GenericApproveTask {
        private ADeleteLinkTemplateTask() {
        }

        @Override
        public void approve(UserAccount userAccount, History history, DAO dao) {
            if (ADeleteLinkTemplateTask.canDo(userAccount, history)) {
                KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
                int option = JOptionPane.showConfirmDialog(frame, "Are you sure you want to delete '" + history.getOldValue() + "' ? Be aware that this will not effect existing annotations that use it.", "VARS - Delete LinkTemplate", 0, 2);
                if (option != 0) {
                    return;
                }
                LinkBean link = new LinkBean(history.getOldValue());
                LinkTemplate exampleTemplate = ApproveHistoryTask.this.toolBelt.getKnowledgebaseFactory().newLinkTemplate();
                exampleTemplate.setLinkName(link.getLinkName());
                exampleTemplate.setToConcept(link.getToConcept());
                exampleTemplate.setLinkValue(link.getLinkValue());
                ConceptMetadata conceptMetadata = history.getConceptMetadata();
                ArrayList<ILink> linkTemplates = new ArrayList<ILink>(conceptMetadata.getLinkTemplates());
                Collection<ILink> matchingLinkTemplates = LinkUtilities.findMatchingLinksIn(linkTemplates, exampleTemplate);
                LinkTemplate linkTemplate = null;
                if (matchingLinkTemplates.size() > 0) {
                    linkTemplate = (LinkTemplate)matchingLinkTemplates.iterator().next();
                    conceptMetadata.removeLinkTemplate(linkTemplate);
                    dao.remove(linkTemplate);
                    super.approve(userAccount, history, dao);
                } else {
                    this.dropHistory(history, "Unable to locate '" + history.getOldValue() + "'. It may have \nbeen moved. I'll remove the History reference.", dao);
                }
            }
        }
    }

    private class ADeleteLinkRealizationTask
    extends GenericApproveTask {
        private ADeleteLinkRealizationTask() {
        }

        @Override
        public void approve(UserAccount userAccount, History history, DAO dao) {
            if (ADeleteLinkRealizationTask.canDo(userAccount, history)) {
                KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
                int option = JOptionPane.showConfirmDialog(frame, "Are you sure you want to delete '" + history.getOldValue() + "' ? Be aware that this will not effect existing annotations that use it.", "VARS - Delete LinkRealization", 0, 2);
                if (option != 0) {
                    return;
                }
                LinkBean link = new LinkBean(history.getOldValue());
                LinkRealization exampleRealization = ApproveHistoryTask.this.toolBelt.getKnowledgebaseFactory().newLinkRealization();
                exampleRealization.setLinkName(link.getLinkName());
                exampleRealization.setToConcept(link.getToConcept());
                exampleRealization.setLinkValue(link.getLinkValue());
                ConceptMetadata conceptMetadata = history.getConceptMetadata();
                ArrayList<ILink> linkRealizations = new ArrayList<ILink>(conceptMetadata.getLinkRealizations());
                Collection<ILink> matchingLinkRealizations = LinkUtilities.findMatchingLinksIn(linkRealizations, exampleRealization);
                LinkRealization linkRealization = null;
                if (matchingLinkRealizations.size() > 0) {
                    linkRealization = (LinkRealization)matchingLinkRealizations.iterator().next();
                    conceptMetadata.removeLinkRealization(linkRealization);
                    dao.remove(linkRealization);
                    super.approve(userAccount, history, dao);
                } else {
                    this.dropHistory(history, "Unable to locate '" + history.getOldValue() + "'. It may have \nbeen moved. I'll remove the History reference.", dao);
                }
            }
        }
    }

    private class ADeleteConceptNameAction
    extends GenericApproveTask {
        private ADeleteConceptNameAction() {
        }

        @Override
        public void approve(UserAccount userAccount, History history, DAO dao) {
            KnowledgebaseFrame frame;
            int option;
            String conceptNameToDelete = history.getOldValue();
            if (ADeleteConceptNameAction.canDo(userAccount, history) && (option = JOptionPane.showConfirmDialog(frame = StateLookup.getApplicationFrame(), "Are you sure you want to delete '" + conceptNameToDelete + "' ? Be aware that this will change existing annotations that use it.", "VARS - Delete ConceptName", 0, 2)) != 0) {
                return;
            }
            final Concept concept = history.getConceptMetadata().getConcept();
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ApproveHistoryTask.this.toolBelt.getKnowledgebasePersistenceService().updateConceptNameUsedByLinkTemplates(concept);
                        ApproveHistoryTask.this.toolBelt.getAnnotationPersistenceService().updateConceptNameUsedByAnnotations(concept);
                    }
                    catch (Exception e) {
                        EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                    }
                }
            }, "Update thread for annotations named " + conceptNameToDelete);
            thread.setDaemon(false);
            thread.start();
            ConceptNameDAO conceptNameDAO = ApproveHistoryTask.this.toolBelt.getKnowledgebaseDAOFactory().newConceptNameDAO(dao.getEntityManager());
            ConceptName conceptName = conceptNameDAO.findByName(conceptNameToDelete);
            if (conceptName != null) {
                if (conceptName.getNameType().equalsIgnoreCase(ConceptNameTypes.PRIMARY.getName())) {
                    ConceptName otherName = conceptName.getConcept().getConceptName(conceptNameToDelete);
                    if (conceptNameDAO.equalInDatastore(conceptName, otherName)) {
                        EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"You are attempting to delete a primary concept-name. This is NOT allowed.");
                        return;
                    }
                    conceptName = otherName;
                }
                conceptName.getConcept().removeConceptName(conceptName);
                dao.remove(conceptName);
                super.approve(userAccount, history, conceptNameDAO);
            } else {
                this.dropHistory(history, "Unable to locate '" + conceptNameToDelete + "'. I'll remove the History reference.", dao);
            }
            conceptNameDAO.close();
        }
    }

    private class ADeleteChildConceptTask
    extends GenericApproveTask {
        private ADeleteChildConceptTask() {
        }

        @Override
        public void approve(UserAccount userAccount, History history, DAO dao) {
            String nameToDelete = history.getOldValue();
            Concept parentConcept = history.getConceptMetadata().getConcept();
            ArrayList<Concept> children = new ArrayList<Concept>(parentConcept.getChildConcepts());
            Concept concept = null;
            for (Concept child : children) {
                ConceptName conceptName = child.getConceptName(nameToDelete);
                if (conceptName == null) continue;
                concept = child;
                break;
            }
            if (concept == null) {
                this.dropHistory(history, "No child Concept containg the name '" + history.getOldValue() + "' was found. I'll remove the obsolete history information", dao);
                return;
            }
            ConceptDAO conceptDAO = ApproveHistoryTask.this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO(dao.getEntityManager());
            concept = conceptDAO.find(concept);
            Collection<Concept> conceptsToBeDeleted = conceptDAO.findDescendents(concept);
            KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
            int option = JOptionPane.showConfirmDialog(frame, "You are about to delete " + conceptsToBeDeleted.size() + " concept(s) from the \nknowledgebase. Are you sure you want to continue?", "VARS - Delete Concepts", 0, 2);
            if (option != 0) {
                return;
            }
            ObservationDAO observationDAO = ApproveHistoryTask.this.toolBelt.getAnnotationDAOFactory().newObservationDAO();
            observationDAO.startTransaction();
            List<Observation> observations = observationDAO.findAllByConcept(concept, true, conceptDAO);
            if (observations.size() > 0) {
                String newName = parentConcept.getPrimaryConceptName().getName();
                String msg = observations.size() + " Observations were found using '" + nameToDelete + "' or one of it's \nchildren. Do you want to update the names to '" + newName + "' or \nignore them and leave them as is?";
                Object[] options = new Object[]{"Update", "Ignore", "Cancel"};
                option = JOptionPane.showOptionDialog(frame, msg, "VARS - Removing '" + nameToDelete + "'", 1, 3, null, options, options[2]);
                switch (option) {
                    case 0: {
                        for (Observation observation : observations) {
                            observation.setConceptName(newName);
                        }
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            observationDAO.endTransaction();
            super.approve(userAccount, history, dao);
            conceptDAO.endTransaction();
            conceptDAO.cascadeRemove(concept);
            conceptDAO.close();
        }
    }
}

