/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import com.google.common.base.Preconditions;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.awt.Component;
import java.awt.Frame;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.swing.JTree;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventTopicSubscriber;
import org.mbari.swing.ProgressDialog;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ui.App;
import vars.knowledgebase.ui.KnowledgebaseFrame;
import vars.shared.InjectorModule;
import vars.shared.ui.GlobalStateLookup;

public class StateLookup
extends GlobalStateLookup {
    public static final String TOPIC_SELECTED_CONCEPT = "vars.knowledgebase.ui.Lookup-SelectedConcept";
    public static final String TOPIC_APPROVE_HISTORY = "vars.knowledgebase.ui.Lookup-ApproveHistory";
    public static final String TOPIC_APPROVE_HISTORIES = "vars.knowledgebase.ui.Lookup-ApproveHistories";
    public static final String TOPIC_UPDATE_OBSERVATIONS = "vars.knowledgebase.ui.Lookup-UpateObservations";
    public static final String TOPIC_REFRESH_KNOWLEGEBASE = "vars.knowledgebase.ui.Lookup-RefreshKnowledgebase";
    public static final Injector GUICE_INJECTOR = Guice.createInjector((Module[])new Module[]{new InjectorModule("vars-jpa-annotation", "vars-jpa-knowledgebase", "vars-jpa-misc")});
    private static final ObjectProperty<KnowledgebaseFrame> applicationFrame = new SimpleObjectProperty();
    private static final ObjectProperty<Concept> selectedConcept = new SimpleObjectProperty();
    private static final ObjectProperty<App> application = new SimpleObjectProperty();
    private static final EventTopicSubscriber<Concept> conceptSubscriber = (s, c) -> selectedConcept.set(c);
    private static JTree conceptTree;
    private static ProgressDialog progressDialog;

    public static ProgressDialog getProgressDialog() {
        if (progressDialog == null) {
            Frame frame = (Frame)applicationFrame.get();
            progressDialog = new ProgressDialog(frame);
            progressDialog.setLocationRelativeTo((Component)frame);
        }
        return progressDialog;
    }

    public static KnowledgebaseFrame getApplicationFrame() {
        return (KnowledgebaseFrame)applicationFrame.get();
    }

    public static ObjectProperty<KnowledgebaseFrame> applicationFrameProperty() {
        return applicationFrame;
    }

    public static void setApplicationFrame(KnowledgebaseFrame applicationFrame) {
        StateLookup.applicationFrame.set((Object)applicationFrame);
    }

    public static Concept getSelectedConcept() {
        return (Concept)selectedConcept.get();
    }

    public static ObjectProperty<Concept> selectedConceptProperty() {
        return selectedConcept;
    }

    public static void setSelectedConcept(Concept selectedConcept) {
        StateLookup.selectedConcept.set((Object)selectedConcept);
    }

    public static JTree getConceptTree() {
        return conceptTree;
    }

    public static void setConceptTree(JTree conceptTree) {
        Preconditions.checkArgument((conceptTree != null ? 1 : 0) != 0);
        StateLookup.conceptTree = conceptTree;
    }

    public static App getApplication() {
        return (App)application.get();
    }

    public static ObjectProperty<App> applicationProperty() {
        return application;
    }

    public static void setApplication(App application) {
        StateLookup.application.set((Object)application);
    }

    static {
        EventBus.subscribe((String)TOPIC_SELECTED_CONCEPT, conceptSubscriber);
        EventBus.subscribe((String)TOPIC_APPROVE_HISTORY, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
        EventBus.subscribe((String)TOPIC_APPROVE_HISTORIES, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
        EventBus.subscribe((String)TOPIC_SELECTED_CONCEPT, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
        EventBus.subscribe((String)TOPIC_UPDATE_OBSERVATIONS, (EventTopicSubscriber)LOGGING_SUBSCRIBER);
    }
}

