/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.swing.WaitIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.DAO;
import vars.UserAccount;
import vars.annotation.AnnotationPersistenceService;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptMetadata;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.History;
import vars.knowledgebase.HistoryFactory;
import vars.knowledgebase.KnowledgebaseFactory;
import vars.knowledgebase.KnowledgebasePersistenceService;
import vars.knowledgebase.ui.KnowledgebaseFrame;
import vars.knowledgebase.ui.NamesEditorPanel;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.knowledgebase.ui.dialogs.AddConceptNameDialog2;

class NamesEditorPanelController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ToolBelt toolBelt;
    private final NamesEditorPanel namesEditorPanel;
    private NewAction newAction;
    private final HistoryFactory historyFactory;

    NamesEditorPanelController(NamesEditorPanel namesEditorPanel) {
        this.namesEditorPanel = namesEditorPanel;
        this.toolBelt = namesEditorPanel.getToolBelt();
        this.historyFactory = this.toolBelt.getHistoryFactory();
    }

    void newConceptName() {
        if (this.newAction == null) {
            this.newAction = new NewAction();
        }
        this.newAction.doAction();
    }

    void deleteConceptName(ConceptName conceptName) {
        int value = JOptionPane.showConfirmDialog(this.namesEditorPanel, "Do you want to mark '" + conceptName.getName() + "' for deletion?", "VARS - Confirm", 0, -1);
        UserAccount userAccount = StateLookup.getUserAccount();
        if (value == 0) {
            WaitIndicator waitIndicator = new WaitIndicator((JComponent)this.namesEditorPanel);
            History history = this.historyFactory.delete(userAccount, conceptName);
            DAO dao = this.toolBelt.getKnowledgebaseDAOFactory().newDAO();
            dao.startTransaction();
            conceptName = dao.merge(conceptName);
            conceptName.getConcept().getConceptMetadata().addHistory(history);
            dao.persist(history);
            dao.endTransaction();
            dao.close();
            waitIndicator.dispose();
            EventBus.publish((String)"vars.knowledgebase.ui.Lookup-ApproveHistory", (Object)history);
        }
    }

    public boolean updateConceptName(Concept concept, String newName, String author, String nameType, String oldName, UserAccount userAccount) {
        boolean okToProceed = true;
        ConceptDAO conceptDAO = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO();
        KnowledgebasePersistenceService kbPersistenceService = this.toolBelt.getKnowledgebasePersistenceService();
        AnnotationPersistenceService annoPersistenceService = this.toolBelt.getAnnotationPersistenceService();
        KnowledgebaseFactory knowledgebaseFactory = this.toolBelt.getKnowledgebaseFactory();
        Concept matchingConcept = null;
        if (okToProceed) {
            this.log.debug("Verifying that '" + newName + "' does not already exist in the knowledgebase");
            try {
                matchingConcept = conceptDAO.findByName(newName);
            }
            catch (Exception e1) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("A search for '" + newName + "' in the database failed", (Throwable)e1);
                }
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e1);
                okToProceed = false;
            }
        }
        if (okToProceed) {
            if (matchingConcept != null && !conceptDAO.equalInDatastore(matchingConcept, concept)) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("A concept with the name '" + newName + "' already exists."));
                okToProceed = false;
            } else {
                this.log.debug("'" + newName + "' does not yet exist in the knowledgebase");
            }
        }
        if (okToProceed) {
            this.log.debug("Updating the conceptName");
            ConceptMetadata conceptMetadata = concept.getConceptMetadata();
            this.log.debug("Inspecting " + conceptMetadata + "\n" + conceptMetadata.getHistories().toString() + "\n");
            ConceptName newConceptName = knowledgebaseFactory.newConceptName();
            newConceptName.setName(newName);
            newConceptName.setAuthor(author);
            newConceptName.setNameType(nameType);
            DAO dao = this.toolBelt.getKnowledgebaseDAOFactory().newDAO();
            dao.startTransaction();
            concept = dao.merge(concept);
            ConceptName oldConceptName = concept.getConceptName(oldName);
            History history = this.historyFactory.replaceConceptName(userAccount, oldConceptName, newConceptName);
            concept.getConceptMetadata().addHistory(history);
            dao.persist(history);
            if (nameType.equalsIgnoreCase(ConceptNameTypes.PRIMARY.toString())) {
                ConceptName copyCn = knowledgebaseFactory.newConceptName();
                copyCn.setName(oldConceptName.getName());
                copyCn.setAuthor(oldConceptName.getAuthor());
                copyCn.setNameType(ConceptNameTypes.SYNONYM.toString());
                oldConceptName.setName(newName);
                concept.addConceptName(copyCn);
                dao.persist(copyCn);
            } else {
                oldConceptName.setName(newName);
            }
            oldConceptName.setAuthor(author);
            oldConceptName.setNameType(nameType);
            dao.endTransaction();
            dao.close();
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Changing all Observations that use '" + oldName + "' to use '" + newName + "'");
                }
                kbPersistenceService.updateConceptNameUsedByLinkTemplates(concept);
                annoPersistenceService.updateConceptNameUsedByAnnotations(concept);
            }
            catch (Exception e) {
                String msg = "Failed to change primary names of annotations from '" + oldName + "' to '" + newName + "'.";
                this.log.error(msg);
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
            }
            EventBus.publish((String)"vars.knowledgebase.ui.Lookup-ApproveHistory", (Object)history);
        }
        conceptDAO.close();
        return okToProceed;
    }

    private class NewAction
    extends ActionAdapter {
        private AddConceptNameDialog2 dialog;

        private NewAction() {
        }

        public void doAction() {
            this.getDialog().setVisible(true);
        }

        private AddConceptNameDialog2 getDialog() {
            if (this.dialog == null) {
                KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
                this.dialog = new AddConceptNameDialog2((Frame)frame, true, NamesEditorPanelController.this.toolBelt);
                this.dialog.setConcept(StateLookup.getSelectedConcept());
                StateLookup.selectedConceptProperty().addListener((obs, oldVal, newVal) -> this.dialog.setConcept((Concept)newVal));
            }
            return this.dialog;
        }
    }
}

