/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.mbari.swing.ListListModel;
import org.mbari.text.IgnoreCaseToStringComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.ui.EditorButtonPanel;
import vars.knowledgebase.ui.EditorPanel;
import vars.knowledgebase.ui.NamesEditorPanelController;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.shared.ui.ILockableEditor;

public class NamesEditorPanel
extends EditorPanel
implements ILockableEditor {
    private static final long serialVersionUID = -3451562418328420320L;
    private static final Logger log = LoggerFactory.getLogger(NamesEditorPanel.class);
    private JTextField authorField = null;
    private JLabel authorLabel = null;
    private EditorButtonPanel buttonPanel = null;
    private JLabel commonLabel = null;
    private JRadioButton commonRb = null;
    private JLabel formerLabel = null;
    private JRadioButton formerRb = null;
    private JTextField nameField = null;
    private JLabel nameLabel = null;
    private JList namesList = null;
    private JPanel namesPanel = null;
    private JLabel primaryLabel = null;
    private JRadioButton primaryRb = null;
    private JPanel rbPanel = null;
    private JScrollPane scrollPane = null;
    private JLabel synonymLabel = null;
    private JRadioButton synonymRb = null;
    private JLabel typeLabel = null;
    private JPanel viewPanel = null;
    private Comparator stringComparator = new IgnoreCaseToStringComparator();
    private final NamesEditorPanelController controller = new NamesEditorPanelController(this);
    private ItemListener rbItemListener;

    @Inject
    public NamesEditorPanel(ToolBelt toolBelt) {
        super(toolBelt);
        this.initialize();
        this.setLocked(this.isLocked());
    }

    JTextField getAuthorField() {
        if (this.authorField == null) {
            this.authorField = new JTextField();
        }
        return this.authorField;
    }

    private EditorButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new EditorButtonPanel();
            JButton deleteButton = this.buttonPanel.getDeleteButton();
            deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String selectedName = (String)NamesEditorPanel.this.getNamesList().getSelectedValue();
                    Concept concept = NamesEditorPanel.this.getConcept();
                    String primaryName = concept.getPrimaryConceptName().getName();
                    ConceptName conceptName = concept.getConceptName(selectedName);
                    NamesEditorPanel.this.controller.deleteConceptName(conceptName);
                }
            });
            deleteButton.setEnabled(false);
            JButton updateButton = this.buttonPanel.getUpdateButton();
            updateButton.setEnabled(false);
            updateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String selectedName = (String)NamesEditorPanel.this.getNamesList().getSelectedValue();
                    Concept concept = NamesEditorPanel.this.getConcept();
                    ConceptName oldConceptName = concept.getConceptName(selectedName);
                    boolean okToProceed = true;
                    String name = NamesEditorPanel.this.getNameField().getText();
                    int value = JOptionPane.showConfirmDialog(NamesEditorPanel.this, "Do want to change '" + selectedName + "' to '" + name + "'?", "VARS - Confirm", 0, -1);
                    String author = NamesEditorPanel.this.getAuthorField().getText();
                    String nameType = ConceptNameTypes.SYNONYM.toString();
                    if (NamesEditorPanel.this.getPrimaryRb().isSelected()) {
                        nameType = ConceptNameTypes.PRIMARY.toString();
                    } else if (NamesEditorPanel.this.getCommonRb().isSelected()) {
                        nameType = ConceptNameTypes.COMMON.toString();
                    } else if (NamesEditorPanel.this.getFormerRb().isSelected()) {
                        nameType = ConceptNameTypes.FORMER.toString();
                    }
                    okToProceed = value == 0 && !name.equals(selectedName) && name.equals("") && selectedName != null && oldConceptName != null;
                    UserAccount userAccount = StateLookup.getUserAccount();
                    if (okToProceed && nameType.equalsIgnoreCase(ConceptNameTypes.PRIMARY.toString())) {
                        value = JOptionPane.showConfirmDialog(NamesEditorPanel.this, "Are you really sure that you want\nto change the primary name?", "VARS - Confirm", 0, 2);
                        okToProceed = value == 0;
                    }
                    NamesEditorPanel.this.controller.updateConceptName(concept, name, author, nameType, selectedName, userAccount);
                }
            });
            JButton newButton = this.buttonPanel.getNewButton();
            newButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NamesEditorPanel.this.controller.newConceptName();
                }
            });
        }
        return this.buttonPanel;
    }

    private JRadioButton getCommonRb() {
        if (this.commonRb == null) {
            this.commonRb = new JRadioButton();
            this.commonRb.addItemListener(this.getRbItemListener());
        }
        return this.commonRb;
    }

    private JRadioButton getFormerRb() {
        if (this.formerRb == null) {
            this.formerRb = new JRadioButton();
            this.formerRb.addItemListener(this.getRbItemListener());
        }
        return this.formerRb;
    }

    private JButton getDeleteButton() {
        return this.getButtonPanel().getDeleteButton();
    }

    JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField();
        }
        return this.nameField;
    }

    JList getNamesList() {
        if (this.namesList == null) {
            this.namesList = new JList();
            this.namesList.setPreferredSize(new Dimension(0, 120));
            this.namesList.setSelectionMode(0);
            this.namesList.setModel(new ListListModel(new ArrayList()));
            this.namesList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    String selectedName = (String)NamesEditorPanel.this.getNamesList().getSelectedValue();
                    if (log.isDebugEnabled()) {
                        log.debug("Selected '" + selectedName + "' in the name editor panel");
                    }
                    NamesEditorPanel.this.setSelectedConceptName(selectedName);
                }
            });
        }
        return this.namesList;
    }

    private JPanel getNamesPanel() {
        if (this.namesPanel == null) {
            this.namesPanel = new JPanel();
            this.namesPanel.setLayout(new BorderLayout());
            this.namesPanel.setBorder(BorderFactory.createTitledBorder(null, "Names", 0, 0, null, null));
            this.namesPanel.add((Component)this.getViewPanel(), "South");
            this.namesPanel.add((Component)this.getScrollPane(), "Center");
        }
        return this.namesPanel;
    }

    private JButton getNewButton() {
        return this.getButtonPanel().getNewButton();
    }

    private JRadioButton getPrimaryRb() {
        if (this.primaryRb == null) {
            this.primaryRb = new JRadioButton();
            this.primaryRb.addItemListener(this.getRbItemListener());
        }
        return this.primaryRb;
    }

    private ItemListener getRbItemListener() {
        if (this.rbItemListener == null) {
            this.rbItemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (!NamesEditorPanel.this.isLocked()) {
                        JRadioButton rb = NamesEditorPanel.this.getPrimaryRb();
                        boolean enable = !rb.isSelected();
                        boolean enableDelete = enable && NamesEditorPanel.this.getNamesList().getSelectedIndex() > -1;
                        NamesEditorPanel.this.getDeleteButton().setEnabled(enableDelete);
                        boolean enableUpdate = NamesEditorPanel.this.getNamesList().getSelectedIndex() > -1;
                        NamesEditorPanel.this.getUpdateButton().setEnabled(enableUpdate);
                        NamesEditorPanel.this.getCommonRb().setEnabled(enable);
                        NamesEditorPanel.this.getSynonymRb().setEnabled(enable);
                        NamesEditorPanel.this.getFormerRb().setEnabled(enable);
                        rb.setEnabled(!enable);
                    }
                }
            };
        }
        return this.rbItemListener;
    }

    private JPanel getRbPanel() {
        if (this.rbPanel == null) {
            this.primaryLabel = new JLabel();
            this.primaryLabel.setText("Primary");
            this.synonymLabel = new JLabel();
            this.synonymLabel.setText("Synonym");
            this.commonLabel = new JLabel();
            this.commonLabel.setText("Common");
            this.formerLabel = new JLabel("Former");
            this.rbPanel = new JPanel();
            this.rbPanel.setLayout(new BoxLayout(this.getRbPanel(), 0));
            this.rbPanel.add((Component)this.primaryLabel, null);
            this.rbPanel.add((Component)this.getPrimaryRb(), null);
            this.rbPanel.add(Box.createHorizontalStrut(10));
            this.rbPanel.add((Component)this.commonLabel, null);
            this.rbPanel.add((Component)this.getCommonRb(), null);
            this.rbPanel.add(Box.createHorizontalStrut(10));
            this.rbPanel.add((Component)this.synonymLabel, null);
            this.rbPanel.add((Component)this.getSynonymRb(), null);
            this.rbPanel.add(Box.createHorizontalStrut(10));
            this.rbPanel.add((Component)this.formerLabel, null);
            this.rbPanel.add((Component)this.getFormerRb(), null);
            this.rbPanel.add(Box.createHorizontalStrut(10));
            this.rbPanel.add(Box.createHorizontalGlue());
        }
        return this.rbPanel;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getNamesList());
        }
        return this.scrollPane;
    }

    private JRadioButton getSynonymRb() {
        if (this.synonymRb == null) {
            this.synonymRb = new JRadioButton();
            this.synonymRb.addItemListener(this.getRbItemListener());
        }
        return this.synonymRb;
    }

    private JButton getUpdateButton() {
        return this.getButtonPanel().getUpdateButton();
    }

    private JPanel getViewPanel() {
        if (this.viewPanel == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(4, 0, 0, 20);
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.insets = new Insets(4, 10, 0, 20);
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.insets = new Insets(4, 0, 0, 20);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(4, 0, 0, 20);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(4, 10, 0, 20);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(4, 10, 0, 20);
            gridBagConstraints.gridy = 0;
            this.typeLabel = new JLabel();
            this.typeLabel.setText("Type: ");
            this.authorLabel = new JLabel();
            this.authorLabel.setText("Author: ");
            this.nameLabel = new JLabel();
            this.nameLabel.setText("Name: ");
            this.viewPanel = new JPanel();
            this.viewPanel.setLayout(new GridBagLayout());
            this.viewPanel.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, null, null));
            this.viewPanel.add((Component)this.nameLabel, gridBagConstraints);
            this.viewPanel.add((Component)this.authorLabel, gridBagConstraints1);
            this.viewPanel.add((Component)this.getNameField(), gridBagConstraints2);
            this.viewPanel.add((Component)this.getAuthorField(), gridBagConstraints3);
            this.viewPanel.add((Component)this.typeLabel, gridBagConstraints4);
            this.viewPanel.add((Component)this.getRbPanel(), gridBagConstraints5);
        }
        return this.viewPanel;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getNamesPanel(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.getPrimaryRb());
        buttonGroup.add(this.getCommonRb());
        buttonGroup.add(this.getSynonymRb());
        buttonGroup.add(this.getFormerRb());
    }

    @Override
    public void setConcept(Concept concept) {
        super.setConcept(concept);
        ArrayList<ConceptName> conceptNames = new ArrayList<ConceptName>();
        if (concept != null) {
            conceptNames.addAll(concept.getConceptNames());
        }
        ArrayList<String> names = new ArrayList<String>(conceptNames.size());
        for (ConceptName conceptName : conceptNames) {
            names.add(conceptName.getName());
        }
        Collections.sort(names, this.stringComparator);
        ListListModel listModel = (ListListModel)this.getNamesList().getModel();
        listModel.clear();
        listModel.addAll(names);
        if (concept != null) {
            this.getNamesList().setSelectedValue(concept.getPrimaryConceptName().getName(), true);
        }
    }

    @Override
    public void setLocked(boolean locked) {
        super.setLocked(locked);
        this.getNameField().setEnabled(!locked);
        this.getAuthorField().setEnabled(!locked);
        this.getNewButton().setEnabled(!locked);
        this.getUpdateButton().setEnabled(!locked);
        this.getDeleteButton().setEnabled(!locked);
        this.getPrimaryRb().setEnabled(!locked);
        this.getCommonRb().setEnabled(!locked);
        this.getSynonymRb().setEnabled(!locked);
        this.getFormerRb().setEnabled(!locked);
        this.getRbItemListener().itemStateChanged(null);
    }

    private void setSelectedConceptName(String name) {
        boolean enableButtons;
        String author = "";
        String type = null;
        boolean bl = enableButtons = name != null && !this.isLocked();
        if (name == null) {
            name = "";
            type = ConceptNameTypes.SYNONYM.toString();
        } else {
            ConceptName conceptName = this.getConcept().getConceptName(name);
            author = conceptName.getAuthor();
            type = conceptName.getNameType();
        }
        boolean isPrimaryName = type.equalsIgnoreCase(ConceptNameTypes.PRIMARY.toString());
        this.getNameField().setText(name);
        this.getAuthorField().setText(author);
        if (isPrimaryName) {
            this.getPrimaryRb().setSelected(true);
        } else if (type.equalsIgnoreCase(ConceptNameTypes.COMMON.toString())) {
            this.getCommonRb().setSelected(true);
        } else if (type.equalsIgnoreCase(ConceptNameTypes.FORMER.toString())) {
            this.getFormerRb().setSelected(true);
        } else {
            this.getSynonymRb().setSelected(true);
        }
        this.getAuthorField().setEditable(!isPrimaryName);
        this.getUpdateButton().setEnabled(enableButtons);
        this.getDeleteButton().setEnabled(enableButtons && !isPrimaryName);
    }
}

