/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import vars.knowledgebase.Media;
import vars.shared.ui.ILockableEditor;

public class MediaViewPanel
extends JPanel
implements ILockableEditor {
    private static final long serialVersionUID = 1L;
    private JTextArea captionArea = null;
    private JLabel captionLabel = null;
    private JScrollPane captionScrollPane = null;
    private JTextArea creditArea = null;
    private JLabel creditLabel = null;
    private JScrollPane creditScrollPane = null;
    private JCheckBox primaryCheckBox = null;
    private JComboBox typeComboBox = null;
    private JLabel typeLabel = null;
    private JTextField urlField = null;
    private JScrollPane urlScrollPane;
    private JLabel urlLabel = null;
    private boolean locked;
    private Media media;

    public MediaViewPanel() {
        this.initialize();
    }

    public JTextArea getCaptionArea() {
        if (this.captionArea == null) {
            this.captionArea = new JTextArea();
            this.captionArea.setPreferredSize(new Dimension(60, 60));
        }
        return this.captionArea;
    }

    private JScrollPane getCaptionScrollPane() {
        if (this.captionScrollPane == null) {
            this.captionScrollPane = new JScrollPane();
            this.captionScrollPane.setViewportView(this.getCaptionArea());
        }
        return this.captionScrollPane;
    }

    public JTextArea getCreditArea() {
        if (this.creditArea == null) {
            this.creditArea = new JTextArea();
            this.creditArea.setPreferredSize(new Dimension(60, 60));
        }
        return this.creditArea;
    }

    private JScrollPane getCreditScrollPane() {
        if (this.creditScrollPane == null) {
            this.creditScrollPane = new JScrollPane();
            this.creditScrollPane.setViewportView(this.getCreditArea());
        }
        return this.creditScrollPane;
    }

    public Media getMedia() {
        return this.media;
    }

    public JCheckBox getPrimaryCheckBox() {
        if (this.primaryCheckBox == null) {
            this.primaryCheckBox = new JCheckBox();
            this.primaryCheckBox.setText("Primary");
        }
        return this.primaryCheckBox;
    }

    public JComboBox getTypeComboBox() {
        if (this.typeComboBox == null) {
            this.typeComboBox = new JComboBox();
            String[] types = Media.TYPES;
            for (int i = 0; i < types.length; ++i) {
                this.typeComboBox.addItem(types[i]);
            }
            this.typeComboBox.setSelectedItem("Image");
        }
        return this.typeComboBox;
    }

    public JScrollPane getUrlScrollPane() {
        if (this.urlScrollPane == null) {
            this.urlScrollPane = new JScrollPane(this.getUrlField(), 21, 32);
        }
        return this.urlScrollPane;
    }

    public JTextField getUrlField() {
        if (this.urlField == null) {
            this.urlField = new JTextField();
        }
        return this.urlField;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.anchor = 17;
        gridBagConstraints8.insets = new Insets(0, 4, 4, 0);
        gridBagConstraints8.gridy = 4;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.gridy = 3;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.weighty = 1.0;
        gridBagConstraints7.insets = new Insets(4, 4, 4, 20);
        gridBagConstraints7.gridx = 1;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.gridy = 2;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.insets = new Insets(4, 4, 4, 20);
        gridBagConstraints6.gridx = 1;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.insets = new Insets(0, 4, 0, 20);
        gridBagConstraints5.gridx = 1;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.insets = new Insets(4, 4, 4, 20);
        gridBagConstraints4.gridx = 1;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.insets = new Insets(0, 20, 0, 0);
        gridBagConstraints3.gridy = 3;
        this.creditLabel = new JLabel();
        this.creditLabel.setText("Credit:");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.insets = new Insets(0, 20, 0, 0);
        gridBagConstraints2.gridy = 2;
        this.captionLabel = new JLabel();
        this.captionLabel.setText("Caption:");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.insets = new Insets(0, 20, 0, 0);
        gridBagConstraints1.gridy = 1;
        this.typeLabel = new JLabel();
        this.typeLabel.setText("Media Type:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        gridBagConstraints.gridy = 0;
        this.urlLabel = new JLabel();
        this.urlLabel.setText("URL:");
        this.setSize(314, 203);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.urlLabel, gridBagConstraints);
        this.add((Component)this.typeLabel, gridBagConstraints1);
        this.add((Component)this.captionLabel, gridBagConstraints2);
        this.add((Component)this.creditLabel, gridBagConstraints3);
        this.add((Component)this.getUrlScrollPane(), gridBagConstraints4);
        this.add((Component)this.getTypeComboBox(), gridBagConstraints5);
        this.add((Component)this.getCaptionScrollPane(), gridBagConstraints6);
        this.add((Component)this.getCreditScrollPane(), gridBagConstraints7);
        this.add((Component)this.getPrimaryCheckBox(), gridBagConstraints8);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.getUrlField().setEditable(!locked);
        this.getTypeComboBox().setEnabled(!locked);
        this.getCreditArea().setEditable(!locked);
        this.getCaptionArea().setEditable(!locked);
        this.getPrimaryCheckBox().setEnabled(!locked);
        this.locked = locked;
    }

    public void setMedia(Media media) {
        this.media = media;
        if (media != null) {
            this.getUrlField().setText(media.getUrl());
            this.getCaptionArea().setText(media.getCaption());
            this.getCreditArea().setText(media.getCredit());
            this.getTypeComboBox().setSelectedItem(media.getType());
            this.getPrimaryCheckBox().setSelected(media.isPrimary());
        } else {
            this.getUrlField().setText("");
            this.getCaptionArea().setText("");
            this.getCreditArea().setText("");
            this.getTypeComboBox().setSelectedItem("Image");
            this.getPrimaryCheckBox().setSelected(false);
        }
    }
}

