/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.swing.JImageUrlFrame;
import org.mbari.swing.ListListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.DAO;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.knowledgebase.History;
import vars.knowledgebase.Media;
import vars.knowledgebase.MediaTypes;
import vars.knowledgebase.ui.EditorButtonPanel;
import vars.knowledgebase.ui.EditorPanel;
import vars.knowledgebase.ui.KnowledgebaseFrame;
import vars.knowledgebase.ui.MediaViewPanel;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.knowledgebase.ui.dialogs.AddMediaDialog;
import vars.shared.ui.ILockableEditor;

public class MediaEditorPanel
extends EditorPanel
implements ILockableEditor {
    private static final long serialVersionUID = 3980331775038029506L;
    private static final Logger log = LoggerFactory.getLogger(MediaEditorPanel.class);
    private EditorButtonPanel buttonPanel = null;
    private JList mediaList = null;
    private JPanel mediaPanel = null;
    private MediaViewPanel mediaViewPanel = null;
    private JScrollPane scrollPanel = null;

    public MediaEditorPanel(ToolBelt toolBelt) {
        super(toolBelt);
        this.initialize();
        this.setLocked(this.isLocked());
    }

    private EditorButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new EditorButtonPanel();
            this.buttonPanel.getNewButton().addActionListener((ActionListener)((Object)new NewAction()));
            this.buttonPanel.getUpdateButton().addActionListener((ActionListener)((Object)new UpdateAction()));
            this.buttonPanel.getDeleteButton().addActionListener((ActionListener)((Object)new DeleteAction()));
        }
        return this.buttonPanel;
    }

    private JList getMediaList() {
        if (this.mediaList == null) {
            this.mediaList = new JList();
            this.mediaList.setModel(new ListListModel(new Vector()));
            this.mediaList.setSelectionMode(0);
            this.mediaList.addListSelectionListener(e -> {
                Media media = (Media)this.mediaList.getSelectedValue();
                this.getMediaViewPanel().setMedia(media);
                boolean enable = !this.isLocked() && media != null;
                this.getButtonPanel().getDeleteButton().setEnabled(enable);
                this.getButtonPanel().getUpdateButton().setEnabled(enable);
            });
            this.mediaList.setCellRenderer(new MediaListCellRenderer());
            this.mediaList.addMouseListener(new MouseAdapter(){
                private JImageUrlFrame imageFrame;

                @Override
                public void mouseClicked(MouseEvent e) {
                    Media media;
                    if (e.getButton() == 1 && e.getClickCount() == 2 && (media = (Media)MediaEditorPanel.this.mediaList.getSelectedValue()) != null) {
                        if ("Video".equals(media.getType())) {
                            try {
                                log.warn("Displaying movies is not currently implemented");
                            }
                            catch (Exception e1) {
                                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)("Unable to display the video at '" + media.getUrl() + "'"));
                            }
                        } else {
                            try {
                                URL url = new URL(media.getUrl());
                                JImageUrlFrame jif = this.getImageFrame();
                                jif.setImageUrl(url);
                                jif.setTitle("KNOWLEDGEBASE: " + media.getConceptMetadata().getConcept().getPrimaryConceptName().getName());
                                jif.setVisible(true);
                                jif.repaint();
                            }
                            catch (MalformedURLException e1) {
                                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)("'" + media.getUrl() + "' is not a valid URL"));
                            }
                        }
                    }
                }

                private JImageUrlFrame getImageFrame() {
                    if (this.imageFrame == null) {
                        this.imageFrame = new JImageUrlFrame();
                        KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
                        this.imageFrame.setLocationRelativeTo((Component)frame);
                    }
                    return this.imageFrame;
                }
            });
        }
        return this.mediaList;
    }

    private JPanel getMediaPanel() {
        if (this.mediaPanel == null) {
            BorderLayout borderLayout = new BorderLayout();
            this.mediaPanel = new JPanel();
            this.mediaPanel.setLayout(borderLayout);
            this.mediaPanel.setBorder(BorderFactory.createTitledBorder(null, "Media", 0, 0, null, null));
            this.mediaPanel.add((Component)this.getMediaViewPanel(), "South");
            this.mediaPanel.add((Component)this.getScrollPanel(), "Center");
        }
        return this.mediaPanel;
    }

    private MediaViewPanel getMediaViewPanel() {
        if (this.mediaViewPanel == null) {
            this.mediaViewPanel = new MediaViewPanel();
            this.mediaViewPanel.setBorder(BorderFactory.createEtchedBorder(1));
        }
        return this.mediaViewPanel;
    }

    private JScrollPane getScrollPanel() {
        if (this.scrollPanel == null) {
            this.scrollPanel = new JScrollPane();
            this.scrollPanel.setViewportView(this.getMediaList());
        }
        return this.scrollPanel;
    }

    private void initialize() {
        if (log.isDebugEnabled()) {
            log.debug("Initializing " + this.getClass().getName());
        }
        this.setLayout(new BorderLayout());
        this.setSize(300, 300);
        this.add((Component)this.getButtonPanel(), "South");
        this.add((Component)this.getMediaPanel(), "Center");
    }

    @Override
    public void setConcept(Concept concept) {
        ListListModel model = (ListListModel)this.getMediaList().getModel();
        model.clear();
        if (concept != null) {
            model.addAll(concept.getConceptMetadata().getMedias());
        }
        super.setConcept(concept);
    }

    @Override
    public void setLocked(boolean locked) {
        this.getMediaViewPanel().setLocked(locked);
        this.getButtonPanel().getNewButton().setEnabled(!locked);
        this.getButtonPanel().getDeleteButton().setEnabled(!locked);
        this.getButtonPanel().getUpdateButton().setEnabled(!locked);
        super.setLocked(locked);
    }

    private class UpdateAction
    extends ActionAdapter {
        private UpdateAction() {
        }

        public void doAction() {
            Concept concept;
            DAO dao = MediaEditorPanel.this.getToolBelt().getKnowledgebaseDAOFactory().newDAO();
            dao.startTransaction();
            Media media = dao.find((Media)MediaEditorPanel.this.getMediaList().getSelectedValue());
            MediaViewPanel panel = MediaEditorPanel.this.getMediaViewPanel();
            media.setCaption(panel.getCaptionArea().getText());
            media.setCredit(panel.getCreditArea().getText());
            media.setType((String)panel.getTypeComboBox().getSelectedItem());
            media.setPrimary(panel.getPrimaryCheckBox().isSelected());
            URL url = null;
            try {
                url = new URL(panel.getUrlField().getText());
                InputStream in = url.openStream();
                int b = in.read();
                if (b == -1) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("Unable to read from " + url.toExternalForm()));
                } else {
                    media.setUrl(url.toExternalForm());
                }
            }
            catch (Exception e1) {
                String s = "Failed to open URL, " + panel.getUrlField().getText() + ". The URL will not be updated.";
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)s);
            }
            Media oldPrimaryMedia = null;
            if (media.isPrimary().booleanValue() && (oldPrimaryMedia = (concept = media.getConceptMetadata().getConcept()).getConceptMetadata().getPrimaryMedia(MediaTypes.getType(media.getType()))) != null && !oldPrimaryMedia.equals(media)) {
                log.info("You are adding a primary media of '" + media.getUrl() + "' to " + concept.getPrimaryConceptName().getName() + ". This concept contained a primary media of '" + oldPrimaryMedia.getUrl() + "' which is now set to a secondary media");
                oldPrimaryMedia.setPrimary(false);
            }
            dao.endTransaction();
            dao.close();
            MediaEditorPanel.this.getMediaList().paintImmediately(MediaEditorPanel.this.getMediaList().getBounds());
            EventBus.publish((String)"vars.knowledgebase.ui.Lookup-RefreshKnowledgebase", (Object)media.getConceptMetadata().getConcept().getPrimaryConceptName().getName());
        }
    }

    private class NewAction
    extends ActionAdapter {
        private AddMediaDialog dialog;

        private NewAction() {
        }

        public void doAction() {
            this.getDialog().setConcept(MediaEditorPanel.this.getConcept());
            this.getDialog().setVisible(true);
        }

        private AddMediaDialog getDialog() {
            if (this.dialog == null) {
                KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
                this.dialog = new AddMediaDialog((Frame)frame, MediaEditorPanel.this.getToolBelt());
                this.dialog.setLocationRelativeTo(frame);
            }
            return this.dialog;
        }
    }

    private class MediaListCellRenderer
    extends DefaultListCellRenderer {
        private MediaListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Media media = (Media)value;
            String text = media == null ? "" : media.getUrl();
            c.setText(text);
            return c;
        }
    }

    private class DeleteAction
    extends ActionAdapter {
        private DeleteAction() {
        }

        public void doAction() {
            Media media = (Media)MediaEditorPanel.this.getMediaList().getSelectedValue();
            UserAccount userAccount = StateLookup.getUserAccount();
            History history = MediaEditorPanel.this.getToolBelt().getHistoryFactory().delete(userAccount, media);
            DAO dao = MediaEditorPanel.this.getToolBelt().getKnowledgebaseDAOFactory().newDAO();
            dao.startTransaction();
            Concept concept = dao.find(media.getConceptMetadata().getConcept());
            concept.getConceptMetadata().addHistory(history);
            dao.persist(history);
            dao.endTransaction();
            dao.close();
            EventBus.publish((String)"vars.knowledgebase.ui.Lookup-ApproveHistory", (Object)history);
        }
    }
}

