/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import foxtrot.Job;
import foxtrot.Worker;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.swing.SpinningDialWaitIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.DAO;
import vars.ILink;
import vars.LinkBean;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptMetadata;
import vars.knowledgebase.History;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.knowledgebase.LinkTemplate;
import vars.knowledgebase.LinkTemplateDAO;
import vars.knowledgebase.ui.EditorButtonPanel;
import vars.knowledgebase.ui.EditorPanel;
import vars.knowledgebase.ui.KnowledgebaseFrame;
import vars.knowledgebase.ui.LinkEditorPanel;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.knowledgebase.ui.dialogs.AddLinkTemplateDialog;

public class LinkTemplateEditorPanel
extends EditorPanel {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ActionAdapter deleteAction;
    private EditorButtonPanel editorButtonPanel;
    private LinkEditorPanel linkEditorPanel;
    private ActionAdapter newAction;
    private ActionAdapter updateAction;

    public LinkTemplateEditorPanel(ToolBelt toolBelt) {
        super(toolBelt);
        this.initialize();
        this.setLocked(this.isLocked());
    }

    private ActionAdapter getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteAction();
        }
        return this.deleteAction;
    }

    private EditorButtonPanel getEditorButtonPanel() {
        if (this.editorButtonPanel == null) {
            this.editorButtonPanel = new EditorButtonPanel();
            this.editorButtonPanel.getDeleteButton().addActionListener((ActionListener)this.getDeleteAction());
            this.editorButtonPanel.getNewButton().addActionListener((ActionListener)this.getNewAction());
            this.editorButtonPanel.getUpdateButton().addActionListener((ActionListener)this.getUpdateAction());
        }
        return this.editorButtonPanel;
    }

    private LinkEditorPanel getLinkEditorPanel() {
        if (this.linkEditorPanel == null) {
            this.linkEditorPanel = new LinkEditorPanel(this.getToolBelt());
            this.linkEditorPanel.setBorder(BorderFactory.createTitledBorder("Allowed Associations"));
        }
        return this.linkEditorPanel;
    }

    private ActionAdapter getNewAction() {
        if (this.newAction == null) {
            this.newAction = new NewAction();
        }
        return this.newAction;
    }

    private ActionAdapter getUpdateAction() {
        if (this.updateAction == null) {
            this.updateAction = new UpdateAction();
        }
        return this.updateAction;
    }

    private void initialize() {
        this.add((Component)this.getLinkEditorPanel(), "Center");
        this.add((Component)this.getEditorButtonPanel(), "South");
    }

    @Override
    public void setConcept(Concept concept) {
        super.setConcept(concept);
        this.linkEditorPanel.setConcept(concept);
    }

    @Override
    public void setLocked(boolean locked) {
        super.setLocked(locked);
        this.getEditorButtonPanel().getNewButton().setEnabled(!locked);
        this.getEditorButtonPanel().getUpdateButton().setEnabled(!locked);
        this.getEditorButtonPanel().getDeleteButton().setEnabled(!locked);
        this.getLinkEditorPanel().setLocked(locked);
    }

    private class UpdateAction
    extends ActionAdapter {
        private UpdateAction() {
        }

        void updateLink(LinkTemplate linkTemplate, ILink newLink) {
            KnowledgebaseDAOFactory factory = LinkTemplateEditorPanel.this.getToolBelt().getKnowledgebaseDAOFactory();
            LinkTemplateDAO linkTemplateDAO = factory.newLinkTemplateDAO();
            linkTemplateDAO.startTransaction();
            linkTemplate = linkTemplateDAO.find(linkTemplate);
            if (!linkTemplate.getFromConcept().equals(newLink.getFromConcept())) {
                ConceptDAO conceptDAO = factory.newConceptDAO(linkTemplateDAO.getEntityManager());
                Concept newFromConcept = conceptDAO.findByName(newLink.getFromConcept());
                ConceptMetadata conceptMetadata = linkTemplate.getConceptMetadata();
                conceptMetadata.removeLinkTemplate(linkTemplate);
                newFromConcept.getConceptMetadata().addLinkTemplate(linkTemplate);
            }
            ArrayList<LinkTemplate> links = new ArrayList<LinkTemplate>();
            links.addAll(linkTemplateDAO.findAllByLinkName(linkTemplate.getLinkName()));
            for (LinkTemplate link : links) {
                if (linkTemplateDAO.equalInDatastore(link, linkTemplate) || !link.getLinkValue().equalsIgnoreCase(newLink.getLinkValue())) continue;
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("A LinkTemplate with a LinkName of '" + linkTemplate.getLinkName() + "' and a LinkValue of '" + newLink.getLinkValue() + "' already exist. Unable to change the LinkTemplate."));
                LinkTemplateEditorPanel.this.getLinkEditorPanel().setLink(linkTemplate);
                return;
            }
            linkTemplate.setLinkName(newLink.getLinkName());
            linkTemplate.setLinkValue(newLink.getLinkValue());
            linkTemplate.setToConcept(newLink.getToConcept());
            linkTemplateDAO.endTransaction();
            linkTemplateDAO.close();
        }

        boolean needsUpdate(ILink oldLink, ILink newLink) {
            return !newLink.getToConcept().equals(oldLink.getToConcept()) || !newLink.getFromConcept().equals(oldLink.getFromConcept()) || !newLink.getLinkName().equals(oldLink.getLinkName()) || !newLink.getLinkValue().equals(oldLink.getLinkValue());
        }

        public void doAction() {
            UserAccount userAccount = StateLookup.getUserAccount();
            if (userAccount != null && !userAccount.isReadOnly()) {
                LinkEditorPanel panel = LinkTemplateEditorPanel.this.getLinkEditorPanel();
                ILink link = panel.getLink();
                if (link == null) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"No LinkTemplate has been selected");
                } else if (!(link instanceof LinkTemplate)) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("You are not allowed to delete '" + link.stringValue() + "'"));
                } else {
                    final LinkTemplate linkTemplate = (LinkTemplate)link;
                    final LinkBean newLink = new LinkBean(panel.getLinkName(), panel.getToConcept(), panel.getLinkValue(), panel.getFromConcept());
                    SpinningDialWaitIndicator waitIndicator = new SpinningDialWaitIndicator((JComponent)LinkTemplateEditorPanel.this);
                    Worker.post((Job)new Job(){

                        public Object run() {
                            if (UpdateAction.this.needsUpdate(linkTemplate, newLink)) {
                                try {
                                    UpdateAction.this.updateLink(linkTemplate, newLink);
                                }
                                catch (Exception e) {
                                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                                }
                            }
                            EventBus.publish((String)"vars.knowledgebase.ui.Lookup-RefreshKnowledgebase", (Object)newLink.getFromConcept());
                            return null;
                        }
                    });
                    waitIndicator.dispose();
                }
            }
        }
    }

    private class NewAction
    extends ActionAdapter {
        AddLinkTemplateDialog dialog;

        private NewAction() {
        }

        public void doAction() {
            this.getDialog().setConcept(LinkTemplateEditorPanel.this.getConcept());
            this.getDialog().setVisible(true);
        }

        private AddLinkTemplateDialog getDialog() {
            if (this.dialog == null) {
                KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
                this.dialog = new AddLinkTemplateDialog((Frame)frame, LinkTemplateEditorPanel.this.getToolBelt());
            }
            return this.dialog;
        }
    }

    private class DeleteAction
    extends ActionAdapter {
        private DeleteAction() {
        }

        public void doAction() {
            UserAccount userAccount = StateLookup.getUserAccount();
            if (userAccount != null && !userAccount.isReadOnly()) {
                LinkEditorPanel panel = LinkTemplateEditorPanel.this.getLinkEditorPanel();
                ILink link = panel.getLink();
                if (link == null) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"No LinkTemplate has been selected");
                } else if (!(link instanceof LinkTemplate)) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("You are not allowed to delete '" + link.stringValue() + "'"));
                } else {
                    LinkTemplate linkTemplate = (LinkTemplate)link;
                    String name = linkTemplate.getConceptMetadata().getConcept().getPrimaryConceptName().getName();
                    try {
                        DAO dao = LinkTemplateEditorPanel.this.getToolBelt().getKnowledgebaseDAOFactory().newDAO();
                        dao.startTransaction();
                        linkTemplate = dao.find(linkTemplate);
                        ConceptMetadata conceptMetadata = linkTemplate.getConceptMetadata();
                        History history = LinkTemplateEditorPanel.this.getToolBelt().getHistoryFactory().delete(userAccount, linkTemplate);
                        conceptMetadata.addHistory(history);
                        dao.persist(history);
                        dao.endTransaction();
                        dao.close();
                        EventBus.publish((String)"vars.knowledgebase.ui.Lookup-ApproveHistory", (Object)history);
                    }
                    catch (Exception e) {
                        LinkTemplateEditorPanel.this.log.error("Failed to delete " + linkTemplate + " in database", (Throwable)e);
                        EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                        EventBus.publish((String)"vars.knowledgebase.ui.Lookup-RefreshKnowledgebase", (Object)name);
                    }
                }
            }
        }
    }
}

