/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import foxtrot.Job;
import foxtrot.Worker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bushe.swing.event.EventBus;
import org.mbari.awt.event.ActionAdapter;
import org.mbari.swing.ListListModel;
import org.mbari.swing.SpinningDialWaitIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.DAO;
import vars.ILink;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptMetadata;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.History;
import vars.knowledgebase.LinkRealization;
import vars.knowledgebase.LinkTemplate;
import vars.knowledgebase.LinkTemplateDAO;
import vars.knowledgebase.SimpleConceptBean;
import vars.knowledgebase.SimpleConceptNameBean;
import vars.knowledgebase.ui.EditorButtonPanel;
import vars.knowledgebase.ui.EditorPanel;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.knowledgebase.ui.dialogs.AddLinkRealizationDialog;
import vars.shared.ui.HierachicalConceptNameComboBox;
import vars.shared.ui.LinkListCellRenderer;

public class LinkRealizationEditorPanel
extends EditorPanel {
    private static final Logger log = LoggerFactory.getLogger(LinkRealizationEditorPanel.class);
    private static final Concept SELF_CONCEPT = new SimpleConceptBean(new SimpleConceptNameBean("self", ConceptNameTypes.PRIMARY.toString()));
    private static final Concept NIL_CONCEPT = new SimpleConceptBean(new SimpleConceptNameBean("nil", ConceptNameTypes.PRIMARY.toString()));
    private EditorButtonPanel editorButtonPanel = null;
    private JPanel linkEditorPanel = null;
    private JTextField linkField = null;
    private JLabel linkLabel = null;
    private JList linkList = null;
    private JScrollPane linkValueScrollPane = null;
    private JTextArea linkValueTextArea = null;
    private ListListModel listModel = null;
    private JSplitPane propertiesPanel = null;
    private JScrollPane scrollPane = null;
    private HierachicalConceptNameComboBox toConceptComboBox = null;
    private JLabel toConceptLabel = null;
    private JLabel valueLabel = null;
    private DeleteAction deleteAction;
    private NewAction newAction;
    private UpdateAction updateAction;

    public LinkRealizationEditorPanel(ToolBelt toolBelt) {
        super(toolBelt);
        this.initialize();
        this.setLocked(this.isLocked());
    }

    DeleteAction getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteAction();
        }
        return this.deleteAction;
    }

    private EditorButtonPanel getEditorButtonPanel() {
        if (this.editorButtonPanel == null) {
            this.editorButtonPanel = new EditorButtonPanel();
            this.editorButtonPanel.getDeleteButton().addActionListener((ActionListener)((Object)this.getDeleteAction()));
            this.editorButtonPanel.getNewButton().addActionListener((ActionListener)((Object)this.getNewAction()));
            this.editorButtonPanel.getUpdateButton().addActionListener((ActionListener)((Object)this.getUpdateAction()));
        }
        return this.editorButtonPanel;
    }

    private JPanel getLinkEditorPanel() {
        if (this.linkEditorPanel == null) {
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.gridx = 1;
            gridBagConstraints11.gridy = 2;
            gridBagConstraints11.gridheight = 1;
            gridBagConstraints11.insets = new Insets(0, 0, 5, 20);
            gridBagConstraints11.weightx = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 20, 5, 5);
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.gridy = 2;
            this.valueLabel = new JLabel();
            this.valueLabel.setText("Value:");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.insets = new Insets(0, 20, 5, 5);
            gridBagConstraints1.gridy = 1;
            this.toConceptLabel = new JLabel();
            this.toConceptLabel.setText("To Concept:");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 20, 5, 5);
            gridBagConstraints.gridy = 0;
            this.linkLabel = new JLabel();
            this.linkLabel.setText("Link:");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.gridy = 1;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(0, 0, 5, 20);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(5, 0, 5, 20);
            gridBagConstraints6.gridx = 1;
            this.linkEditorPanel = new JPanel();
            this.linkEditorPanel.setLayout(new GridBagLayout());
            this.linkEditorPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.linkEditorPanel.add((Component)this.getLinkField(), gridBagConstraints6);
            this.linkEditorPanel.add((Component)this.getToConceptComboBox(), gridBagConstraints7);
            this.linkEditorPanel.add((Component)this.linkLabel, gridBagConstraints);
            this.linkEditorPanel.add((Component)this.toConceptLabel, gridBagConstraints1);
            this.linkEditorPanel.add((Component)this.valueLabel, gridBagConstraints2);
            this.linkEditorPanel.add((Component)this.getLinkValueScrollPane(), gridBagConstraints11);
        }
        return this.linkEditorPanel;
    }

    private JTextField getLinkField() {
        if (this.linkField == null) {
            this.linkField = new JTextField();
        }
        return this.linkField;
    }

    private JList getLinkList() {
        if (this.linkList == null) {
            this.linkList = new JList();
            this.linkList.setSelectionMode(0);
            this.linkList.setModel(this.getListModel());
            this.linkList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    LinkRealization link = (LinkRealization)LinkRealizationEditorPanel.this.linkList.getSelectedValue();
                    LinkRealizationEditorPanel.this.updateUIWithSelectedLink(link);
                }
            });
            this.linkList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    LinkRealization link = (LinkRealization)LinkRealizationEditorPanel.this.linkList.getSelectedValue();
                    boolean enable = !LinkRealizationEditorPanel.this.isLocked() && link != null;
                    LinkRealizationEditorPanel.this.getEditorButtonPanel().getDeleteButton().setEnabled(enable);
                    LinkRealizationEditorPanel.this.getEditorButtonPanel().getUpdateButton().setEnabled(enable);
                }
            });
            this.linkList.setCellRenderer(new LinkListCellRenderer());
        }
        return this.linkList;
    }

    private JScrollPane getLinkValueScrollPane() {
        if (this.linkValueScrollPane == null) {
            this.linkValueScrollPane = new JScrollPane(this.getLinkValueTextArea(), 22, 32);
        }
        return this.linkValueScrollPane;
    }

    private JTextArea getLinkValueTextArea() {
        if (this.linkValueTextArea == null) {
            this.linkValueTextArea = new JTextArea();
            this.linkValueTextArea.setPreferredSize(new Dimension(300, 48));
            this.linkValueTextArea.setLineWrap(true);
        }
        return this.linkValueTextArea;
    }

    private ListListModel getListModel() {
        if (this.listModel == null) {
            Vector list = new Vector();
            this.listModel = new ListListModel(list);
        }
        return this.listModel;
    }

    NewAction getNewAction() {
        if (this.newAction == null) {
            this.newAction = new NewAction();
        }
        return this.newAction;
    }

    private JSplitPane getPropertiesPanel() {
        if (this.propertiesPanel == null) {
            this.propertiesPanel = new JSplitPane(0, this.getScrollPane(), this.getLinkEditorPanel());
            this.propertiesPanel.setDividerLocation(0.25);
            this.propertiesPanel.setBorder(BorderFactory.createTitledBorder(null, "Descriptions", 0, 0, null, null));
        }
        return this.propertiesPanel;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setBorder(BorderFactory.createEtchedBorder(1));
            this.scrollPane.setViewportView(this.getLinkList());
        }
        return this.scrollPane;
    }

    private HierachicalConceptNameComboBox getToConceptComboBox() {
        if (this.toConceptComboBox == null) {
            this.toConceptComboBox = new HierachicalConceptNameComboBox(this.getToolBelt().getAnnotationPersistenceService());
        }
        return this.toConceptComboBox;
    }

    UpdateAction getUpdateAction() {
        if (this.updateAction == null) {
            this.updateAction = new UpdateAction();
        }
        return this.updateAction;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPropertiesPanel(), "Center");
        this.setMinimumSize(new Dimension(100, 100));
        this.add((Component)this.getEditorButtonPanel(), "South");
    }

    @Override
    public void setConcept(Concept concept) {
        this.getLinkList().clearSelection();
        super.setConcept(concept);
        this.listModel.clear();
        if (concept != null) {
            ListListModel localListModel = this.getListModel();
            localListModel.addAll(concept.getConceptMetadata().getLinkRealizations());
        }
    }

    @Override
    public void setLocked(boolean locked) {
        super.setLocked(locked);
        this.getEditorButtonPanel().getNewButton().setEnabled(!locked);
        boolean enable = !locked && this.getLinkList().getSelectedValue() != null;
        this.getEditorButtonPanel().getUpdateButton().setEnabled(enable);
        this.getEditorButtonPanel().getDeleteButton().setEnabled(enable);
        this.getLinkField().setEnabled(enable);
        this.getToConceptComboBox().setEnabled(enable);
        this.getLinkValueTextArea().setEnabled(enable);
    }

    private void updateUIWithSelectedLink(final LinkRealization link) {
        if (log.isDebugEnabled()) {
            log.debug("Updating with " + link);
        }
        boolean enable = !this.isLocked() && link != null;
        this.getLinkField().setEnabled(enable);
        this.getLinkValueTextArea().setEnabled(enable);
        this.getToConceptComboBox().setEnabled(enable);
        if (link == null) {
            this.getLinkField().setText("");
            this.getLinkValueTextArea().setText("");
            this.getToConceptComboBox().removeAllItems();
            return;
        }
        this.getLinkField().setText(link.getLinkName());
        this.getLinkValueTextArea().setText(link.getLinkValue());
        LinkTemplateDAO linkTemplateDAO = this.getToolBelt().getKnowledgebaseDAOFactory().newLinkTemplateDAO();
        linkTemplateDAO.startTransaction();
        LinkRealization linkRealization = linkTemplateDAO.find(link);
        Concept toConcept = linkRealization.getConceptMetadata().getConcept();
        Collection<LinkTemplate> matchingLinkTemplates = linkTemplateDAO.findAllByLinkName(link.getLinkName(), toConcept);
        linkTemplateDAO.endTransaction();
        linkTemplateDAO.close();
        String toConceptAsString = null;
        if (matchingLinkTemplates.isEmpty()) {
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)("Unable to find a LinkTemplate that matches '" + link + "'"));
            toConceptAsString = link.getToConcept();
        } else {
            ILink matchingLink = matchingLinkTemplates.iterator().next();
            toConceptAsString = matchingLink.getToConcept();
        }
        SpinningDialWaitIndicator waitIndicator = new SpinningDialWaitIndicator((JComponent)this);
        final String fToConceptAsString = toConceptAsString;
        Worker.post((Job)new Job(){

            public Object run() {
                Concept concept = null;
                Concept selectedConcept = null;
                final HierachicalConceptNameComboBox cb = LinkRealizationEditorPanel.this.getToConceptComboBox();
                cb.removeAllItems();
                if (fToConceptAsString.equalsIgnoreCase("self")) {
                    concept = SELF_CONCEPT;
                    selectedConcept = SELF_CONCEPT;
                    cb.addItem(SELF_CONCEPT.getPrimaryConceptName());
                } else if (fToConceptAsString.equalsIgnoreCase("nil")) {
                    concept = NIL_CONCEPT;
                    selectedConcept = NIL_CONCEPT;
                    cb.addItem(NIL_CONCEPT.getPrimaryConceptName());
                } else {
                    try {
                        ConceptDAO conceptDAO = LinkRealizationEditorPanel.this.getToolBelt().getKnowledgebaseDAOFactory().newConceptDAO();
                        conceptDAO.startTransaction();
                        concept = conceptDAO.findByName(fToConceptAsString);
                        selectedConcept = conceptDAO.findByName(link.getToConcept());
                        conceptDAO.endTransaction();
                        conceptDAO.close();
                        cb.setConcept(concept);
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                        EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"A database error occurred. Try refreshing the knowledgebase");
                        concept = NIL_CONCEPT;
                        selectedConcept = NIL_CONCEPT;
                        cb.addItem(NIL_CONCEPT.getPrimaryConceptName());
                    }
                }
                final Concept fSelectedConcept = selectedConcept;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        cb.setSelectedItem((Object)fSelectedConcept.getPrimaryConceptName().getName());
                        cb.repaint();
                    }
                });
                return null;
            }
        });
        waitIndicator.dispose();
        log.debug("Update with {} is complete", (Object)link);
    }

    private class UpdateAction
    extends ActionAdapter {
        private UpdateAction() {
        }

        public void doAction() {
            UserAccount userAccount = StateLookup.getUserAccount();
            if (userAccount != null && !userAccount.isReadOnly()) {
                JList linkList = LinkRealizationEditorPanel.this.getLinkList();
                LinkRealization linkRealization = (LinkRealization)linkList.getSelectedValue();
                String name = (String)LinkRealizationEditorPanel.this.getToConceptComboBox().getSelectedItem();
                if (!"nil".equalsIgnoreCase(name) && !"self".equalsIgnoreCase(name)) {
                    Concept concept = null;
                    try {
                        ConceptDAO conceptDAO = LinkRealizationEditorPanel.this.getToolBelt().getKnowledgebaseDAOFactory().newConceptDAO();
                        concept = conceptDAO.findByName(name);
                        conceptDAO.close();
                        if (concept != null) {
                            name = concept.getPrimaryConceptName().toString();
                        }
                    }
                    catch (Exception e) {
                        log.error("Unable to find Concept '" + name + "' in the database");
                    }
                }
                LinkRealization oldValue = LinkRealizationEditorPanel.this.getToolBelt().getKnowledgebaseFactory().newLinkRealization();
                oldValue.setLinkName(linkRealization.getLinkName());
                oldValue.setToConcept(linkRealization.getToConcept());
                oldValue.setLinkValue(linkRealization.getLinkValue());
                DAO dao = LinkRealizationEditorPanel.this.getToolBelt().getKnowledgebaseDAOFactory().newDAO();
                dao.startTransaction();
                linkRealization = dao.find(linkRealization);
                linkRealization.setLinkName(LinkRealizationEditorPanel.this.getLinkField().getText());
                linkRealization.setToConcept(name);
                linkRealization.setLinkValue(LinkRealizationEditorPanel.this.getLinkValueTextArea().getText());
                History history = LinkRealizationEditorPanel.this.getToolBelt().getHistoryFactory().replaceLinkRealization(userAccount, oldValue, linkRealization);
                linkRealization.getConceptMetadata().addHistory(history);
                dao.persist(history);
                dao.endTransaction();
                dao.close();
                EventBus.publish((String)"vars.knowledgebase.ui.Lookup-ApproveHistory", (Object)history);
            }
        }
    }

    private class NewAction
    extends ActionAdapter {
        private final AddLinkRealizationDialog dialog;

        private NewAction() {
            this.dialog = new AddLinkRealizationDialog((Frame)StateLookup.getApplicationFrame(), LinkRealizationEditorPanel.this.getToolBelt());
        }

        public void doAction() {
            this.dialog.setConcept(LinkRealizationEditorPanel.this.getConcept());
            this.dialog.setVisible(true);
        }
    }

    private class DeleteAction
    extends ActionAdapter {
        private DeleteAction() {
        }

        public void doAction() {
            JList linkList;
            LinkRealization linkRealization;
            UserAccount userAccount = StateLookup.getUserAccount();
            if (userAccount != null && !userAccount.isReadOnly() && (linkRealization = (LinkRealization)(linkList = LinkRealizationEditorPanel.this.getLinkList()).getSelectedValue()) != null) {
                History history = LinkRealizationEditorPanel.this.getToolBelt().getHistoryFactory().delete(userAccount, linkRealization);
                DAO dao = LinkRealizationEditorPanel.this.getToolBelt().getKnowledgebaseDAOFactory().newDAO();
                dao.startTransaction();
                linkRealization = dao.find(linkRealization);
                ConceptMetadata conceptDelegate = linkRealization.getConceptMetadata();
                conceptDelegate.addHistory(history);
                dao.persist(history);
                dao.endTransaction();
                dao.close();
                EventBus.publish((String)"vars.knowledgebase.ui.Lookup-ApproveHistory", (Object)history);
            }
        }
    }
}

