/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import foxtrot.Job;
import foxtrot.Worker;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.mbari.swing.SearchableComboBoxModel;
import org.mbari.text.ObjectToStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ILink;
import vars.LinkBean;
import vars.LinkComparator;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.KnowledgebaseFactory;
import vars.knowledgebase.LinkTemplate;
import vars.knowledgebase.LinkTemplateDAO;
import vars.knowledgebase.SimpleConceptBean;
import vars.knowledgebase.SimpleConceptNameBean;
import vars.knowledgebase.ui.ToolBelt;
import vars.shared.ui.AllConceptNamesComboBox;
import vars.shared.ui.FullLinkListCellRender;
import vars.shared.ui.ILockableEditor;

public class LinkEditorPanel
extends JPanel
implements ILockableEditor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Concept selfConcept = new SimpleConceptBean(new SimpleConceptNameBean("self", ConceptNameTypes.PRIMARY.toString()));
    private final ILink nilLinkTemplate = new LinkBean("nil", "nil", "nil");
    private final Concept nilConcept = new SimpleConceptBean(new SimpleConceptNameBean("nil", ConceptNameTypes.PRIMARY.toString()));
    private String title = "";
    private Concept concept;
    private JComboBox fromConceptComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JSeparator jSeparator1;
    private ILink link;
    private JComboBox linkComboBox;
    private JTextField linkNameField;
    private JTextField linkValueField;
    private boolean locked;
    private JTextField searchField;
    private JComboBox toConceptComboBox;
    private final ToolBelt toolBelt;

    public LinkEditorPanel(ToolBelt toolBelt) {
        this.toolBelt = toolBelt;
        this.initialize();
    }

    public Concept getConcept() {
        return this.concept;
    }

    public String getFromConcept() {
        return (String)this.fromConceptComboBox.getSelectedItem();
    }

    public JComboBox getFromConceptComboBox() {
        return this.fromConceptComboBox;
    }

    public ILink getLink() {
        return this.link;
    }

    public JComboBox getLinkComboBox() {
        if (this.linkComboBox == null) {
            this.linkComboBox = new JComboBox();
            this.linkComboBox.setModel(new SearchableComboBoxModel((Comparator)new LinkComparator(), new ObjectToStringConverter(){

                public String convert(Object object) {
                    return object.toString().toLowerCase();
                }
            }));
            this.linkComboBox.setRenderer(new FullLinkListCellRender());
            this.linkComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        LinkEditorPanel.this.setLink((ILink)e.getItem());
                    }
                }
            });
        }
        return this.linkComboBox;
    }

    public String getLinkName() {
        return this.linkNameField.getText();
    }

    public JTextField getLinkNameField() {
        return this.linkNameField;
    }

    public String getLinkValue() {
        return this.linkValueField.getText();
    }

    public JTextField getLinkValueField() {
        return this.linkValueField;
    }

    public JTextField getSearchField() {
        if (this.searchField == null) {
            this.searchField = new JTextField();
            this.searchField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent fe) {
                    LinkEditorPanel.this.searchField.setSelectionStart(0);
                    LinkEditorPanel.this.searchField.setSelectionEnd(LinkEditorPanel.this.searchField.getText().length());
                }
            });
            this.searchField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchableComboBoxModel linksModel;
                    JComboBox linkCb = LinkEditorPanel.this.getLinkComboBox();
                    int startIndex = linkCb.getSelectedIndex() + 1;
                    startIndex = startIndex >= (linksModel = (SearchableComboBoxModel)linkCb.getModel()).getSize() ? 0 : startIndex;
                    String searchTerm = LinkEditorPanel.this.searchField.getText().toLowerCase();
                    int index = linksModel.searchForItemContaining(searchTerm, startIndex);
                    if (index > -1) {
                        linkCb.setSelectedIndex(index);
                        linkCb.hidePopup();
                    } else if (startIndex > 0 && (index = linksModel.searchForItemContaining(searchTerm)) > -1) {
                        linkCb.setSelectedIndex(index);
                        linkCb.hidePopup();
                    }
                }
            });
        }
        return this.searchField;
    }

    public String getTitle() {
        return this.title;
    }

    public String getToConcept() {
        return (String)this.toConceptComboBox.getSelectedItem();
    }

    public JComboBox getToConceptComboBox() {
        return this.toConceptComboBox;
    }

    private void initialize() {
        this.jLabel4 = new JLabel();
        this.jLabel1 = new JLabel();
        this.linkNameField = new JTextField();
        this.jLabel2 = new JLabel();
        this.toConceptComboBox = new AllConceptNamesComboBox(this.toolBelt.getQueryPersistenceService());
        this.jLabel3 = new JLabel();
        this.linkValueField = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.jLabel5 = new JLabel();
        this.fromConceptComboBox = new AllConceptNamesComboBox(this.toolBelt.getQueryPersistenceService());
        this.jLabel4.setText("Search:");
        this.jLabel1.setText("Link:");
        this.jLabel2.setText("To:");
        this.toConceptComboBox.setModel(this.toConceptComboBox.getModel());
        this.jLabel3.setText("Value:");
        this.jLabel5.setText("From:");
        this.fromConceptComboBox.setModel(this.fromConceptComboBox.getModel());
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((Component)this.getSearchField(), -1, 305, Short.MAX_VALUE)).add((Component)this.getLinkComboBox(), 0, 360, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel5).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.linkValueField, -1, 312, Short.MAX_VALUE).add((Component)this.linkNameField, -1, 312, Short.MAX_VALUE).add(1, (Component)this.fromConceptComboBox, 0, 312, Short.MAX_VALUE).add((Component)this.toConceptComboBox, 0, 312, Short.MAX_VALUE))).add((Component)this.jSeparator1, -1, 360, Short.MAX_VALUE).add((Component)this.jLabel1).add((Component)this.jLabel2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel4).add((Component)this.getSearchField(), -2, -1, -2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.getLinkComboBox(), -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.fromConceptComboBox, -2, -1, -2)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabel1)).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.linkNameField, -2, -1, -2))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.toConceptComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.linkValueField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setConcept(Concept concept) {
        this.log.info("Retrieveing LinkTemplates from " + concept);
        if (concept == null) {
            try {
                concept = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO().findRoot();
            }
            catch (Exception e) {
                this.log.error("Failed to lookup root concept", (Throwable)e);
            }
        }
        final Concept fConcept = concept;
        List linkTemplates = (List)Worker.post((Job)new Job(){

            public Object run() {
                LinkTemplateDAO linkTemplateDAO = LinkEditorPanel.this.toolBelt.getKnowledgebaseDAOFactory().newLinkTemplateDAO();
                linkTemplateDAO.startTransaction();
                Concept daoConcept = linkTemplateDAO.find(fConcept);
                Vector<LinkTemplate> links = new Vector<LinkTemplate>(linkTemplateDAO.findAllApplicableToConcept(daoConcept));
                linkTemplateDAO.endTransaction();
                linkTemplateDAO.close();
                return links;
            }
        });
        linkTemplates.add(this.nilLinkTemplate);
        SearchableComboBoxModel model = (SearchableComboBoxModel)this.getLinkComboBox().getModel();
        model.clear();
        model.addAll((Collection)linkTemplates);
        model.setSelectedItem((Object)this.nilLinkTemplate);
        Concept oldConcept = this.concept;
        this.concept = concept;
        this.firePropertyChange("concept", oldConcept, concept);
    }

    public void setLink(ILink link) {
        ILink oldLink = this.link;
        this.link = link;
        if (link == null) {
            link = this.nilLinkTemplate;
        }
        AllConceptNamesComboBox fromCb = (AllConceptNamesComboBox)this.fromConceptComboBox;
        try {
            fromCb.setSelectedItem((Object)link.getFromConcept());
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Defaulting to object");
            }
            fromCb.setSelectedItem((Object)"object");
        }
        this.linkValueField.setText(link.getLinkValue());
        this.linkNameField.setText(link.getLinkName());
        Concept toConcept = null;
        if (link.getToConcept().toLowerCase().trim().equals("self")) {
            toConcept = this.selfConcept;
        } else if (link.getToConcept().equalsIgnoreCase("nil")) {
            toConcept = this.nilConcept;
        } else {
            try {
                ConceptDAO conceptDAO = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO();
                conceptDAO.startTransaction();
                toConcept = conceptDAO.findByName(link.getToConcept());
                if (toConcept == null) {
                    toConcept = conceptDAO.findRoot();
                }
                conceptDAO.endTransaction();
                conceptDAO.close();
            }
            catch (Exception e) {
                this.log.error("Failed to lookup " + link.getToConcept(), (Throwable)e);
                KnowledgebaseFactory knowledgebaseFactory = this.toolBelt.getKnowledgebaseFactory();
                toConcept = knowledgebaseFactory.newConcept();
                ConceptName conceptName = knowledgebaseFactory.newConceptName();
                conceptName.setName("nil");
                conceptName.setNameType(ConceptNameTypes.PRIMARY.toString());
                toConcept.addConceptName(conceptName);
            }
        }
        AllConceptNamesComboBox toCb = (AllConceptNamesComboBox)this.toConceptComboBox;
        toCb.setSelectedItem((Object)toConcept.getPrimaryConceptName().getName());
        toCb.addItem(this.nilConcept.getPrimaryConceptName());
        toCb.addItem(this.selfConcept.getPrimaryConceptName());
        if (!this.locked) {
            boolean allowEditing = !this.nilLinkTemplate.equals(link);
            this.fromConceptComboBox.setEnabled(allowEditing);
            this.linkNameField.setEnabled(allowEditing);
            this.linkValueField.setEnabled(allowEditing);
            this.toConceptComboBox.setEnabled(allowEditing);
        }
        this.firePropertyChange("link", oldLink, link);
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.fromConceptComboBox.setEnabled(!locked);
        this.linkNameField.setEnabled(!locked);
        this.linkValueField.setEnabled(!locked);
        this.toConceptComboBox.setEnabled(!locked);
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

