/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import javax.swing.JComponent;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventTopicSubscriber;
import org.mbari.swing.LabeledSpinningDialWaitIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.PersistenceCache;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ui.KnowledgebaseFrame;
import vars.knowledgebase.ui.ToolBelt;
import vars.shared.ui.tree.ConceptTreePanel;

class KnowledgebaseFrameController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EventTopicSubscriber<String> refreshTreeSubscriber = new RefreshTreeAndOpenNodeSubscriber();
    private final KnowledgebaseFrame knowledgebaseFrame;
    private final ToolBelt toolBelt;
    private final PersistenceCache persistenceCache;

    public KnowledgebaseFrameController(KnowledgebaseFrame knowledgebaseFrame, ToolBelt toolBelt) {
        this.knowledgebaseFrame = knowledgebaseFrame;
        this.toolBelt = toolBelt;
        this.persistenceCache = toolBelt.getPersistenceCache();
        EventBus.subscribe((String)"vars.knowledgebase.ui.Lookup-RefreshKnowledgebase", this.refreshTreeSubscriber);
    }

    public void refreshTreeAndOpenNode(String name) {
        LabeledSpinningDialWaitIndicator waitIndicator = new LabeledSpinningDialWaitIndicator((JComponent)this.knowledgebaseFrame.getTreePanel(), "Refreshing");
        try {
            this.persistenceCache.clear();
        }
        catch (Exception e) {
            this.log.error("Failed to clear cache", (Throwable)e);
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicFatalError", (Object)"Failed to clear knowledgebase cache. Please close this application");
        }
        ConceptTreePanel treePanel = this.knowledgebaseFrame.getTreePanel();
        ConceptDAO conceptDAO = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO();
        conceptDAO.startTransaction();
        Concept concept = null;
        concept = name == null ? conceptDAO.findRoot() : conceptDAO.findByName(name);
        if (concept == null) {
            concept = conceptDAO.findRoot();
        }
        conceptDAO.endTransaction();
        conceptDAO.close();
        treePanel.refreshAndOpenNode(concept);
        waitIndicator.dispose();
    }

    private class RefreshTreeAndOpenNodeSubscriber
    implements EventTopicSubscriber<String> {
        private RefreshTreeAndOpenNodeSubscriber() {
        }

        public void onEvent(String topic, String data) {
            KnowledgebaseFrameController.this.refreshTreeAndOpenNode(data);
        }
    }
}

