/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.EventBus;
import org.jdesktop.swingx.JXTree;
import org.mbari.awt.event.ActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ui.ConceptPanel;
import vars.knowledgebase.ui.EditConceptTreePopupMenu;
import vars.knowledgebase.ui.EditorPanel;
import vars.knowledgebase.ui.HistoryEditorPanel;
import vars.knowledgebase.ui.KnowledgebaseFrameController;
import vars.knowledgebase.ui.LinkRealizationEditorPanel;
import vars.knowledgebase.ui.LinkTemplateEditorPanel;
import vars.knowledgebase.ui.MediaEditorPanel;
import vars.knowledgebase.ui.NamesEditorPanel;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.shared.ui.ILockableEditor;
import vars.shared.ui.dialogs.AdministorUserAccountDialog;
import vars.shared.ui.dialogs.LoginAction;
import vars.shared.ui.tree.ConceptTreeCellRenderer;
import vars.shared.ui.tree.ConceptTreeModel;
import vars.shared.ui.tree.ConceptTreeNode;
import vars.shared.ui.tree.ConceptTreePanel;

public class KnowledgebaseFrame
extends JFrame {
    private static final long serialVersionUID = -6933314608809904289L;
    private static final Logger log = LoggerFactory.getLogger(KnowledgebaseFrame.class);
    private ConceptPanel conceptPanel = null;
    private HistoryEditorPanel historyEditorPanel = null;
    private LinkRealizationEditorPanel linkRealizationEditorPanel = null;
    private LinkTemplateEditorPanel linkTemplateEditorPanel = null;
    private JMenuBar myMenuBar = null;
    private NamesEditorPanel namesEditorPanel = null;
    private JPanel rightPanel = null;
    private JSplitPane splitPane = null;
    private JTabbedPane tabbedPane = null;
    private ConceptTreePanel treePanel = null;
    private final LockAction lockAction = new LockAction();
    private final KnowledgebaseFrameController controller;
    private LoginAction loginAction;
    private MediaEditorPanel mediaEditorPanel;
    private final ToolBelt toolBelt;
    private TreeSelectionListener treeSelectionListener;

    @Inject
    public KnowledgebaseFrame(ToolBelt toolBelt) {
        if (toolBelt == null) {
            throw new IllegalArgumentException("ToolBelt argument can not be null");
        }
        this.toolBelt = toolBelt;
        this.controller = new KnowledgebaseFrameController(this, toolBelt);
        this.initialize();
        this.initUserAccount();
        toolBelt.getPersistenceCache().addCacheClearedListener(new ACacheClearedListener());
    }

    private ConceptPanel getConceptPanel() {
        if (this.conceptPanel == null) {
            this.conceptPanel = new ConceptPanel();
            StateLookup.selectedConceptProperty().addListener((obs, oldVal, newVal) -> this.conceptPanel.setConcept((Concept)newVal));
            JButton lockButton = this.conceptPanel.getLockButton();
            lockButton.addActionListener((ActionListener)this.getLoginAction());
            StateLookup.userAccountProperty().addListener((obs, oldVal, newVal) -> this.conceptPanel.setUserAccount((UserAccount)newVal));
        }
        return this.conceptPanel;
    }

    private HistoryEditorPanel getHistoryEditorPanel() {
        if (this.historyEditorPanel == null) {
            this.historyEditorPanel = new HistoryEditorPanel(this.toolBelt);
            this.setupEditorPanel(this.historyEditorPanel);
            StateLookup.userAccountProperty().addListener((obs, oldVal, newVal) -> this.historyEditorPanel.setUserAccount((UserAccount)newVal));
        }
        return this.historyEditorPanel;
    }

    private LinkRealizationEditorPanel getLinkRealizationEditorPanel() {
        if (this.linkRealizationEditorPanel == null) {
            this.linkRealizationEditorPanel = new LinkRealizationEditorPanel(this.toolBelt);
            this.setupEditorPanel(this.linkRealizationEditorPanel);
        }
        return this.linkRealizationEditorPanel;
    }

    private LinkTemplateEditorPanel getLinkTemplateEditorPanel() {
        if (this.linkTemplateEditorPanel == null) {
            this.linkTemplateEditorPanel = new LinkTemplateEditorPanel(this.toolBelt);
            this.setupEditorPanel(this.linkTemplateEditorPanel);
        }
        return this.linkTemplateEditorPanel;
    }

    private LoginAction getLoginAction() {
        if (this.loginAction == null) {
            this.loginAction = new LoginAction(this.toolBelt.getMiscDAOFactory(), this.toolBelt.getMiscFactory()){

                public void doAction() {
                    if (KnowledgebaseFrame.this.lockAction.isLocked()) {
                        super.doAction();
                    } else {
                        KnowledgebaseFrame.this.lockAction.setLocked(true);
                        EventBus.publish((String)"vars.shared.ui.GlobalLookup-UserAccount", null);
                    }
                }
            };
        }
        return this.loginAction;
    }

    private MediaEditorPanel getMediaEditorPanel() {
        if (this.mediaEditorPanel == null) {
            this.mediaEditorPanel = new MediaEditorPanel(this.toolBelt);
            this.setupEditorPanel(this.mediaEditorPanel);
        }
        return this.mediaEditorPanel;
    }

    private JMenuBar getMyMenuBar() {
        if (this.myMenuBar == null) {
            this.myMenuBar = new JMenuBar();
            JMenu menuEdit = new JMenu("Edit");
            menuEdit.setMnemonic('E');
            this.myMenuBar.add(menuEdit);
            JMenuItem editUser = new JMenuItem((Action)((Object)new EditUserAccountAction()));
            menuEdit.add(editUser);
            editUser.setMnemonic('U');
            editUser.setText("Edit User Accounts");
            editUser.setEnabled(false);
            JMenuItem editConcept = new JMenuItem((Action)new ActionAdapter(){
                private static final long serialVersionUID = 1L;

                public void doAction() {
                    EditConceptTreePopupMenu popupMenu = (EditConceptTreePopupMenu)((Object)KnowledgebaseFrame.this.getTreePanel().getPopupMenu());
                    popupMenu.triggerEditAction();
                }
            });
            menuEdit.add(editConcept);
            editConcept.setMnemonic('C');
            editConcept.setText("Edit Selected Concept");
            editConcept.setEnabled(false);
            StateLookup.userAccountProperty().addListener((obs, oldVal, newVal) -> {
                editUser.setEnabled(newVal != null && newVal.isAdministrator());
                editConcept.setEnabled(newVal != null && !newVal.isReadOnly());
            });
        }
        return this.myMenuBar;
    }

    private NamesEditorPanel getNamesEditorPanel() {
        if (this.namesEditorPanel == null) {
            this.namesEditorPanel = new NamesEditorPanel(this.toolBelt);
            this.setupEditorPanel(this.namesEditorPanel);
        }
        return this.namesEditorPanel;
    }

    public JPanel getRightPanel() {
        if (this.rightPanel == null) {
            this.rightPanel = new JPanel();
            this.rightPanel.setLayout(new BorderLayout());
            this.rightPanel.add((Component)this.getConceptPanel(), "North");
            this.rightPanel.add((Component)this.getTabbedPane(), "Center");
        }
        return this.rightPanel;
    }

    private JSplitPane getSplitPane() {
        if (this.splitPane == null) {
            this.splitPane = new JSplitPane();
            this.splitPane.setLeftComponent((Component)this.getTreePanel());
            this.splitPane.setRightComponent(this.getRightPanel());
        }
        return this.splitPane;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab("Names", null, this.getNamesEditorPanel(), null);
            this.tabbedPane.addTab("Templates", null, this.getLinkTemplateEditorPanel(), null);
            this.tabbedPane.addTab("Properties", null, this.getLinkRealizationEditorPanel(), null);
            this.tabbedPane.addTab("Media", null, this.getMediaEditorPanel(), null);
            this.tabbedPane.addTab("History", null, this.getHistoryEditorPanel(), null);
        }
        return this.tabbedPane;
    }

    protected ConceptTreePanel getTreePanel() {
        if (this.treePanel == null) {
            this.treePanel = new ConceptTreePanel(this.toolBelt.getKnowledgebaseDAOFactory());
            ConceptTreeModel treeModel = new ConceptTreeModel(this.toolBelt.getKnowledgebaseDAOFactory());
            final JXTree tree = new JXTree((TreeModel)treeModel);
            tree.setCellRenderer((TreeCellRenderer)new ConceptTreeCellRenderer());
            tree.addTreeSelectionListener(this.getTreeSelectionListener());
            this.treePanel.setJTree((JTree)tree);
            EditConceptTreePopupMenu popupMenu = new EditConceptTreePopupMenu((JTree)tree, this.toolBelt);
            this.lockAction.addEditor(popupMenu);
            popupMenu.addSeparator();
            JMenuItem menuIteum = new JMenuItem("Refresh", 114);
            menuIteum.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = tree.getSelectionRows()[0];
                    TreePath path = tree.getPathForRow(row);
                    ConceptTreeNode node = (ConceptTreeNode)path.getLastPathComponent();
                    String name = ((Concept)node.getUserObject()).getPrimaryConceptName().getName();
                    KnowledgebaseFrame.this.refreshTreeAndOpenNode(name);
                }
            });
            popupMenu.add(menuIteum);
            this.treePanel.setPopupMenu((JPopupMenu)((Object)popupMenu));
            StateLookup.setConceptTree((JTree)tree);
        }
        return this.treePanel;
    }

    private TreeSelectionListener getTreeSelectionListener() {
        if (this.treeSelectionListener == null) {
            this.treeSelectionListener = new ATreeSelectionListener();
        }
        return this.treeSelectionListener;
    }

    private void initUserAccount() {
        StateLookup.userAccountProperty().addListener((obs, oldVal, userAccount) -> {
            boolean locked;
            boolean bl = locked = userAccount == null || userAccount.isReadOnly();
            if (log.isDebugEnabled()) {
                log.debug("Using UserAccount '" + userAccount + "'; setting locked to " + locked);
            }
            this.lockAction.setLocked(locked);
        });
    }

    void initialize() {
        this.setSize(new Dimension(459, 367));
        this.setJMenuBar(this.getMyMenuBar());
        this.setDefaultCloseOperation(3);
        this.setContentPane(this.getSplitPane());
        ResourceBundle bundle = ResourceBundle.getBundle("knowledgebase-app", Locale.US);
        String title = bundle.getString("frame.title");
        this.setTitle(title);
    }

    public void refreshTreeAndOpenNode(String name) {
        this.controller.refreshTreeAndOpenNode(name);
    }

    private void setupEditorPanel(EditorPanel editorPanel) {
        StateLookup.selectedConceptProperty().addListener((obs, oldVal, newVal) -> editorPanel.setConcept((Concept)newVal));
        this.lockAction.addEditor(editorPanel);
    }

    private class LockAction {
        private boolean locked = true;
        private final Set editors = new HashSet();

        private LockAction() {
        }

        void addEditor(ILockableEditor lockableEditor) {
            lockableEditor.setLocked(this.isLocked());
            this.editors.add(lockableEditor);
        }

        boolean isLocked() {
            return this.locked;
        }

        void removeEditor(ILockableEditor lockableEditor) {
            this.editors.remove(lockableEditor);
        }

        void setLocked(boolean locked) {
            if (this.locked != locked) {
                this.locked = locked;
                for (ILockableEditor editor : this.editors) {
                    editor.setLocked(locked);
                }
            }
        }
    }

    private class EditUserAccountAction
    extends ActionAdapter {
        private static final long serialVersionUID = 1L;
        private final AdministorUserAccountDialog dialog;

        private EditUserAccountAction() {
            this.dialog = new AdministorUserAccountDialog((Frame)KnowledgebaseFrame.this, "VARS - Edit a user account", true, KnowledgebaseFrame.this.toolBelt.getMiscDAOFactory());
        }

        public void doAction() {
            this.dialog.setUserAccount(StateLookup.getUserAccount());
            this.dialog.setVisible(true);
        }
    }

    private class ATreeSelectionListener
    implements TreeSelectionListener {
        private ATreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node;
            Object userObject;
            TreePath selectionPath = e.getNewLeadSelectionPath();
            Concept concept = null;
            if (selectionPath != null && (userObject = (node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()).getUserObject()) instanceof Concept) {
                concept = (Concept)userObject;
            }
            if (log.isDebugEnabled()) {
                log.debug("Selected " + concept + " in the knowledgebase tree");
            }
            StateLookup.setSelectedConcept(concept);
        }
    }

    private class ACacheClearedListener
    implements CacheClearedListener {
        private ACacheClearedListener() {
        }

        @Override
        public void afterClear(CacheClearedEvent evt) {
        }

        @Override
        public void beforeClear(CacheClearedEvent evt) {
            StateLookup.setSelectedConcept(null);
        }
    }
}

