/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.bushe.swing.event.EventBus;
import org.mbari.swing.ListListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.knowledgebase.History;
import vars.knowledgebase.ui.EditorPanel;
import vars.knowledgebase.ui.HistoryViewPanel;
import vars.knowledgebase.ui.ToolBelt;
import vars.knowledgebase.ui.actions.ApproveHistoryTask;
import vars.knowledgebase.ui.actions.RejectHistoryTask;
import vars.shared.ui.ILockableEditor;
import vars.shared.ui.OkCancelButtonPanel;

public class HistoryEditorPanel
extends EditorPanel
implements ILockableEditor {
    private static final Logger log = LoggerFactory.getLogger(HistoryEditorPanel.class);
    private OkCancelButtonPanel buttonPanel = null;
    private JList historyList = null;
    private JPanel listPanel = null;
    private Set<History> histories = new TreeSet<History>(new HistoryComparator());
    private JScrollPane scrollPane = null;
    private HistoryViewPanel viewPanel = null;
    private final ApproveHistoryTask approveHistoryTask;
    private final RejectHistoryTask rejectHistoryTask;
    private UserAccount userAccount;

    public HistoryEditorPanel(ToolBelt toolBelt) {
        super(toolBelt);
        this.initialize();
        this.setLocked(this.isLocked());
        this.approveHistoryTask = toolBelt.getApproveHistoryTask();
        this.rejectHistoryTask = toolBelt.getRejectHistoryTask();
    }

    private JButton getAcceptButton() {
        return this.getButtonPanel().getOkayButton();
    }

    private OkCancelButtonPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            OkCancelButtonPanel p = new OkCancelButtonPanel();
            JButton okButton = p.getOkayButton();
            okButton.setText("Accept");
            okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserAccount userAccount = HistoryEditorPanel.this.getUserAccount();
                    History history = (History)HistoryEditorPanel.this.getHistoryList().getSelectedValue();
                    String name = history.getConceptMetadata().getConcept().getPrimaryConceptName().getName();
                    HistoryEditorPanel.this.approveHistoryTask.doTask(userAccount, history);
                    try {
                        String newName;
                        name = newName = history.getConceptMetadata().getConcept().getPrimaryConceptName().getName();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    EventBus.publish((String)"vars.knowledgebase.ui.Lookup-RefreshKnowledgebase", (Object)name);
                }
            });
            JButton cancelButton = p.getCancelButton();
            cancelButton.setText("Reject");
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserAccount userAccount = HistoryEditorPanel.this.getUserAccount();
                    History history = (History)HistoryEditorPanel.this.getHistoryList().getSelectedValue();
                    String name = history.getConceptMetadata().getConcept().getPrimaryConceptName().getName();
                    HistoryEditorPanel.this.rejectHistoryTask.doTask(userAccount, history);
                    try {
                        String newName;
                        name = newName = history.getConceptMetadata().getConcept().getPrimaryConceptName().getName();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    EventBus.publish((String)"vars.knowledgebase.ui.Lookup-RefreshKnowledgebase", (Object)name);
                }
            });
            this.buttonPanel = p;
        }
        return this.buttonPanel;
    }

    private JList getHistoryList() {
        if (this.historyList == null) {
            this.historyList = new JList();
            this.historyList.setModel(new ListListModel(new ArrayList()));
            this.historyList.setSelectionMode(0);
            this.historyList.setCellRenderer(new HistoryListCellRenderer());
            this.historyList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    History history = (History)HistoryEditorPanel.this.historyList.getSelectedValue();
                    HistoryEditorPanel.this.getViewPanel().setHistory(history);
                    if (!HistoryEditorPanel.this.isLocked() && HistoryEditorPanel.this.getUserAccount().isAdministrator()) {
                        OkCancelButtonPanel panel = HistoryEditorPanel.this.getButtonPanel();
                        panel.getOkayButton().setEnabled(history != null && !history.isProcessed());
                        panel.getCancelButton().setEnabled(history != null && !history.isProcessed());
                    }
                }
            });
        }
        return this.historyList;
    }

    private JPanel getListPanel() {
        if (this.listPanel == null) {
            this.listPanel = new JPanel();
            this.listPanel.setLayout(new BorderLayout());
            this.listPanel.setBorder(BorderFactory.createTitledBorder(null, "Entries", 0, 0, null, null));
            this.listPanel.add((Component)this.getScrollPane(), "Center");
            this.listPanel.add((Component)this.getViewPanel(), "South");
        }
        return this.listPanel;
    }

    private JButton getRejectButton() {
        return this.getButtonPanel().getCancelButton();
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setViewportView(this.getHistoryList());
        }
        return this.scrollPane;
    }

    public UserAccount getUserAccount() {
        return this.userAccount;
    }

    private HistoryViewPanel getViewPanel() {
        if (this.viewPanel == null) {
            this.viewPanel = new HistoryViewPanel();
            this.viewPanel.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, null, null));
        }
        return this.viewPanel;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(300, 200);
        this.setPreferredSize(new Dimension(450, 116));
        this.add((Component)this.getListPanel(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    @Override
    public void setConcept(Concept concept) {
        super.setConcept(concept);
        this.histories.clear();
        Collection<History> historySet = this.getConcept().getConceptMetadata().getHistories();
        this.histories.addAll(historySet);
        ListListModel listModel = (ListListModel)this.getHistoryList().getModel();
        listModel.clear();
        listModel.addAll(this.histories);
    }

    @Override
    public void setLocked(boolean locked) {
        super.setLocked(locked);
        this.getButtonPanel().getOkayButton().setEnabled(!locked);
        this.getButtonPanel().getCancelButton().setEnabled(!locked);
        this.setUserAccount(this.userAccount);
    }

    public void setUserAccount(UserAccount userAccount) {
        this.userAccount = userAccount;
        boolean enable = false;
        if (userAccount != null && userAccount.isAdministrator() && !this.isLocked()) {
            enable = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Using user account '" + userAccount + "'. Enable = " + enable);
        }
        this.getAcceptButton().setEnabled(enable);
        this.getRejectButton().setEnabled(enable);
    }

    private static final class HistoryListCellRenderer
    extends DefaultListCellRenderer {
        private static final Color BACKGROUND = (Color)UIManager.get("List.background");
        private static final Color FOREGROUND = (Color)UIManager.get("List.foreground");
        private static final Color SELECTION_BACKGROUND = (Color)UIManager.get("List.selectionBackground");
        private static final Color SELECTION_FOREGROUND = (Color)UIManager.get("List.selectionForeground");
        private static final Color REJECTED_COLOR = Color.GRAY;
        private static final Color PENDING_COLOR = Color.RED;
        private static final Color APPROVED_COLOR = Color.BLACK;

        HistoryListCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(isSelected ? SELECTION_BACKGROUND : BACKGROUND);
            this.setForeground(isSelected ? SELECTION_FOREGROUND : FOREGROUND);
            History history = (History)value;
            this.setText(history.stringValue());
            if (!history.isProcessed()) {
                this.setForeground(PENDING_COLOR);
            } else if (history.isApproved().booleanValue()) {
                this.setForeground(APPROVED_COLOR);
            } else {
                this.setForeground(REJECTED_COLOR);
            }
            return this;
        }

        @Override
        public String getToolTipText() {
            return "Black -- approved; Gray -- rejected; Red -- pending approval";
        }
    }

    private class HistoryComparator
    implements Comparator {
        HistoryComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            Date t1;
            History h0 = (History)arg0;
            History h1 = (History)arg1;
            Date t0 = h0.getCreationDate() == null ? new Date(0L) : h0.getCreationDate();
            int c = t0.compareTo(t1 = h1.getCreationDate() == null ? new Date(0L) : h1.getCreationDate());
            if (c == 0) {
                c = h0.toString().compareTo(h1.toString());
            }
            return c;
        }
    }
}

