/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.bushe.swing.event.EventBus;
import org.mbari.swing.WaitIndicator;
import vars.DAO;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.knowledgebase.History;
import vars.knowledgebase.HistoryFactory;
import vars.knowledgebase.ui.KnowledgebaseFrame;
import vars.knowledgebase.ui.Lookup;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.knowledgebase.ui.dialogs.AddConceptDialog;
import vars.shared.ui.ILockableEditor;
import vars.shared.ui.tree.ConceptTreeModel;
import vars.shared.ui.tree.ConceptTreeNode;
import vars.shared.ui.tree.ConceptTreePopupMenu;

public class EditConceptTreePopupMenu
extends ConceptTreePopupMenu
implements ILockableEditor {
    private final JMenuItem addConceptMenuItem;
    private JDialog dialog;
    private boolean locked;
    private final JMenuItem moveConceptItem;
    private final JMenuItem removeConceptMenuItem;
    private final ToolBelt toolBelt;
    private final JTree tree;

    public EditConceptTreePopupMenu(JTree tree, ToolBelt toolBelt) {
        super(tree, toolBelt.getKnowledgebaseDAOFactory());
        if (toolBelt == null) {
            throw new IllegalArgumentException("ToolBelt argument can not be null");
        }
        this.tree = tree;
        this.toolBelt = toolBelt;
        this.addConceptMenuItem = new JMenuItem("Add Concept", 65);
        this.removeConceptMenuItem = new JMenuItem("Remove Concept", 82);
        this.moveConceptItem = new JMenuItem("Edit Concept", 77);
        this.addConceptMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditConceptTreePopupMenu.this.triggerAddAction();
            }
        });
        this.removeConceptMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    EditConceptTreePopupMenu.this.triggerRemoveAction();
                }
                catch (Exception e) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                    EventBus.publish((String)"vars.knowledgebase.ui.Lookup-RefreshKnowledgebase", null);
                }
            }
        });
        this.moveConceptItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    EditConceptTreePopupMenu.this.triggerEditAction();
                }
                catch (Exception e) {
                    EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
                    EventBus.publish((String)"vars.knowledgebase.ui.Lookup-RefreshKnowledgebase", null);
                }
            }
        });
        this.addSeparator();
        this.add(this.addConceptMenuItem);
        this.add(this.removeConceptMenuItem);
        this.add(this.moveConceptItem);
    }

    public JDialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new AddConceptDialog(this.toolBelt);
        }
        return this.dialog;
    }

    public JMenuItem getEditConceptMenuItem() {
        return this.moveConceptItem;
    }

    public JMenuItem getRemoveConceptMenuItem() {
        return this.removeConceptMenuItem;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.addConceptMenuItem.setEnabled(!locked);
        this.removeConceptMenuItem.setEnabled(!locked);
        this.moveConceptItem.setEnabled(!locked);
    }

    public void triggerAddAction() {
        if (!this.isLocked()) {
            ((AddConceptDialog)this.getDialog()).setConcept(null);
            this.getDialog().setVisible(true);
        }
    }

    public void triggerEditAction() {
        if (!this.isLocked()) {
            int row = this.tree.getSelectionRows()[0];
            TreePath path = this.tree.getPathForRow(row);
            ConceptTreeNode node = (ConceptTreeNode)path.getLastPathComponent();
            ((AddConceptDialog)this.getDialog()).setConcept((Concept)node.getUserObject());
            this.getDialog().setVisible(true);
        }
    }

    public void triggerRemoveAction() {
        if (!this.isLocked()) {
            ConceptTreeModel model = (ConceptTreeModel)this.tree.getModel();
            int row = this.tree.getSelectionRows()[0];
            TreePath path = this.tree.getPathForRow(row);
            ConceptTreeNode node = (ConceptTreeNode)path.getLastPathComponent();
            node.setLoaded(false);
            model.reload((TreeNode)node);
            Concept concept = (Concept)node.getUserObject();
            if (concept != null) {
                KnowledgebaseFrame frame = StateLookup.getApplicationFrame();
                int value = JOptionPane.showConfirmDialog(frame, "Do you want to mark '" + concept.getPrimaryConceptName().getName() + "' for deletion?", "VARS - Confirm", 0, -1);
                UserAccount userAccount = (UserAccount)Lookup.getUserAccountDispatcher().getValueObject();
                if (value == 0) {
                    WaitIndicator waitIndicator = new WaitIndicator((JFrame)frame);
                    HistoryFactory historyFactory = this.toolBelt.getHistoryFactory();
                    History history = historyFactory.delete(userAccount, concept);
                    DAO dao = this.toolBelt.getKnowledgebaseDAOFactory().newDAO();
                    dao.startTransaction();
                    concept = dao.merge(concept);
                    Concept parentConcept = concept.getParentConcept();
                    if (parentConcept != null) {
                        parentConcept.getConceptMetadata().addHistory(history);
                        dao.persist(history);
                        dao.endTransaction();
                        waitIndicator.dispose();
                        EventBus.publish((String)"vars.knowledgebase.ui.Lookup-ApproveHistory", (Object)history);
                    } else {
                        EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicWarning", (Object)"Unable to delete root concept");
                    }
                    dao.endTransaction();
                    dao.close();
                }
            }
        }
    }
}

