/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.shared.ui.FancyButton;

public class ConceptPanel
extends JPanel {
    private Concept concept;
    private UserAccount userAccount;
    private JPanel topPanel = null;
    private JPanel centerPanel = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel3 = null;
    private JLabel nameLabel = null;
    private JLabel userLabel = null;
    private JButton lockButton = null;
    private JLabel originatorLabel = null;
    private JLabel authorLabel = null;
    private JLabel rankLabel = null;
    private JScrollPane jScrollPane = null;
    private JTextArea referenceArea = null;
    private Icon lockedIcon = new ImageIcon(this.getClass().getResource("/images/vars/knowledgebase/lock.png"));
    private Icon unlockedIcon = new ImageIcon(this.getClass().getResource("/images/vars/knowledgebase/lock_open.png"));
    private boolean locked = true;

    public ConceptPanel() {
        this.initialize();
        this.setConcept(null);
        this.setUserAccount(null);
    }

    public Concept getConcept() {
        return this.concept;
    }

    public void setConcept(Concept concept) {
        if (concept == null) {
            this.nameLabel.setText("");
            this.authorLabel.setText(" ");
            this.rankLabel.setText(" ");
            this.referenceArea.setText(" ");
            this.originatorLabel.setText(" ");
        } else {
            String originator;
            String rankName;
            String rankLevel;
            String author = concept.getPrimaryConceptName().getAuthor();
            if (author == null) {
                author = " ";
            }
            if ((rankLevel = concept.getRankLevel()) == null) {
                rankLevel = " ";
            }
            if ((rankName = concept.getRankName()) == null) {
                rankName = " ";
            }
            String rank = rankLevel + rankName;
            String reference = concept.getReference();
            if (reference == null) {
                reference = " ";
            }
            if ((originator = concept.getOriginator()) == null) {
                originator = " ";
            }
            this.nameLabel.setText(concept.getPrimaryConceptName().getName());
            this.authorLabel.setText(author);
            this.rankLabel.setText(rank);
            this.referenceArea.setText(reference);
            this.originatorLabel.setText(originator);
        }
        this.concept = concept;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(306, 327));
        this.add((Component)this.getCenterPanel(), "Center");
        this.add((Component)this.getTopPanel(), "North");
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new BoxLayout(this.getTopPanel(), 0));
            this.topPanel.add(Box.createHorizontalStrut(20));
            this.topPanel.add((Component)this.getNameLabel(), null);
            this.topPanel.add(Box.createHorizontalGlue());
            this.topPanel.add(this.getUserLabel());
            this.topPanel.add(Box.createHorizontalStrut(4));
            this.topPanel.add((Component)this.getLockButton(), null);
            this.topPanel.add(Box.createHorizontalStrut(20));
        }
        return this.topPanel;
    }

    private JPanel getCenterPanel() {
        if (this.centerPanel == null) {
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 1;
            gridBagConstraints10.gridy = 3;
            gridBagConstraints10.weightx = 1.0;
            gridBagConstraints10.weighty = 1.0;
            gridBagConstraints10.insets = new Insets(0, 4, 10, 20);
            gridBagConstraints10.gridx = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 1;
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.insets = new Insets(0, 4, 4, 20);
            gridBagConstraints9.gridy = 2;
            this.rankLabel = new JLabel();
            this.rankLabel.setText("");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.insets = new Insets(0, 4, 4, 20);
            gridBagConstraints8.gridy = 1;
            this.authorLabel = new JLabel();
            this.authorLabel.setText("");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.insets = new Insets(10, 4, 4, 20);
            gridBagConstraints7.gridy = 0;
            this.originatorLabel = new JLabel();
            this.originatorLabel.setText("");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.insets = new Insets(0, 20, 10, 0);
            gridBagConstraints3.gridy = 3;
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("Reference:");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 20, 4, 0);
            gridBagConstraints2.gridy = 2;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("Rank:");
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.insets = new Insets(0, 20, 4, 0);
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridy = 1;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("Author:");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(10, 20, 4, 0);
            gridBagConstraints.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Originator:");
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout(new GridBagLayout());
            this.centerPanel.add((Component)this.jLabel, gridBagConstraints);
            this.centerPanel.add((Component)this.jLabel1, gridBagConstraints1);
            this.centerPanel.add((Component)this.jLabel2, gridBagConstraints2);
            this.centerPanel.add((Component)this.jLabel3, gridBagConstraints3);
            this.centerPanel.add((Component)this.originatorLabel, gridBagConstraints7);
            this.centerPanel.add((Component)this.authorLabel, gridBagConstraints8);
            this.centerPanel.add((Component)this.rankLabel, gridBagConstraints9);
            this.centerPanel.add((Component)this.getJScrollPane(), gridBagConstraints10);
        }
        return this.centerPanel;
    }

    private JLabel getNameLabel() {
        if (this.nameLabel == null) {
            this.nameLabel = new JLabel();
            this.nameLabel.setText("");
            this.nameLabel.setFont(new Font("Lucida Grande", 1, 18));
        }
        return this.nameLabel;
    }

    public JLabel getUserLabel() {
        if (this.userLabel == null) {
            this.userLabel = new JLabel();
            this.userLabel.setText("");
        }
        return this.userLabel;
    }

    public JButton getLockButton() {
        if (this.lockButton == null) {
            this.lockButton = new FancyButton();
            this.lockButton.setIcon(new ImageIcon(this.getClass().getResource("/images/vars/knowledgebase/lock.png")));
        }
        return this.lockButton;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getReferenceArea());
            this.jScrollPane.setPreferredSize(new Dimension(190, 120));
        }
        return this.jScrollPane;
    }

    private JTextArea getReferenceArea() {
        if (this.referenceArea == null) {
            this.referenceArea = new JTextArea();
            this.referenceArea.setEditable(false);
        }
        return this.referenceArea;
    }

    public UserAccount getUserAccount() {
        return this.userAccount;
    }

    public void setUserAccount(UserAccount userAccount) {
        this.userAccount = userAccount;
        this.locked = userAccount == null || userAccount.isReadOnly();
        Icon lockIcon = this.locked ? this.lockedIcon : this.unlockedIcon;
        this.getLockButton().setIcon(lockIcon);
        String userText = "Not logged in";
        String userName = "";
        if (userAccount != null) {
            userName = userAccount.getUserName();
            userText = userName + " [" + userAccount.getRole() + "]";
        }
        this.getLockButton().setToolTipText(userText);
        this.getUserLabel().setText(userName);
    }
}

