/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import java.util.Collection;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventTopicSubscriber;
import vars.UserAccount;
import vars.knowledgebase.Concept;
import vars.knowledgebase.History;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.actions.ApproveHistoryTask;

public class ApproveHistoriesSubscriber
implements EventTopicSubscriber<Collection<? extends History>> {
    private final ApproveHistoryTask approveHistoryTask;

    public ApproveHistoriesSubscriber(ApproveHistoryTask approveHistoryTask) {
        this.approveHistoryTask = approveHistoryTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(String topic, Collection<? extends History> histories) {
        if ("vars.knowledgebase.ui.Lookup-ApproveHistories".equals(topic)) {
            UserAccount userAccount = StateLookup.getUserAccount();
            try {
                if (userAccount != null && userAccount.isAdministrator()) {
                    this.approveHistoryTask.doTask(userAccount, histories);
                }
            }
            catch (Exception e) {
                EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (Object)e);
            }
            finally {
                Concept concept;
                if (histories.size() > 0 && (concept = histories.iterator().next().getConceptMetadata().getConcept()) != null) {
                    EventBus.publish((String)"vars.knowledgebase.ui.Lookup-RefreshKnowledgebase", (Object)concept.getPrimaryConceptName().getName());
                }
            }
        }
    }
}

