/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.ui;

import com.google.inject.Injector;
import foxtrot.Task;
import foxtrot.Worker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.bushe.swing.event.EventBus;
import org.bushe.swing.event.EventTopicSubscriber;
import org.mbari.swing.SplashFrame;
import org.mbari.util.SystemUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ui.ApproveHistoriesSubscriber;
import vars.knowledgebase.ui.ApproveHistorySubscriber;
import vars.knowledgebase.ui.KnowledgebaseFrame;
import vars.knowledgebase.ui.StateLookup;
import vars.knowledgebase.ui.ToolBelt;
import vars.knowledgebase.ui.actions.PopulateDatabaseAction;
import vars.shared.ui.event.ExitTopicSubscriber;
import vars.shared.ui.event.FatalExceptionSubscriber;
import vars.shared.ui.event.NonFatalErrorSubscriber;
import vars.shared.ui.event.WarningSubscriber;

public class App {
    private static Logger log;
    private KnowledgebaseFrame knowledgebaseFrame;
    private final ToolBelt toolBelt;
    private final EventTopicSubscriber approveHistorySubscriber;
    private final EventTopicSubscriber approveHistoriesSubscriber;
    private final EventTopicSubscriber exitSubscriber = new ExitTopicSubscriber();
    private final EventTopicSubscriber nonFatalErrorSubscriber;
    private final EventTopicSubscriber fatalErrorSubscriber;
    private final EventTopicSubscriber warningSubscriber;

    public App() {
        Injector injector = StateLookup.GUICE_INJECTOR;
        this.toolBelt = (ToolBelt)injector.getInstance(ToolBelt.class);
        this.approveHistorySubscriber = new ApproveHistorySubscriber(this.toolBelt.getApproveHistoryTask());
        this.approveHistoriesSubscriber = new ApproveHistoriesSubscriber(this.toolBelt.getApproveHistoryTask());
        FatalExceptionSubscriber tempFatalErrorSubscriber = new FatalExceptionSubscriber(null);
        NonFatalErrorSubscriber tempNonFatalErrorSubscriber = new NonFatalErrorSubscriber(null);
        EventBus.subscribe((String)"vars.knowledgebase.ui.Lookup-ApproveHistory", (EventTopicSubscriber)this.approveHistorySubscriber);
        EventBus.subscribe((String)"vars.knowledgebase.ui.Lookup-ApproveHistories", (EventTopicSubscriber)this.approveHistoriesSubscriber);
        EventBus.subscribe((String)"vars.shared.ui.GlobalLookup-Exit", (EventTopicSubscriber)this.exitSubscriber);
        EventBus.subscribe((String)"vars.shared.ui.GlobalLookup-TopicFatalError", (EventTopicSubscriber)tempFatalErrorSubscriber);
        EventBus.subscribe((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (EventTopicSubscriber)tempNonFatalErrorSubscriber);
        this.initialize();
        EventBus.unsubscribe((String)"vars.shared.ui.GlobalLookup-TopicFatalError", (EventTopicSubscriber)tempFatalErrorSubscriber);
        EventBus.unsubscribe((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (EventTopicSubscriber)tempNonFatalErrorSubscriber);
        this.fatalErrorSubscriber = new FatalExceptionSubscriber((Frame)this.getKnowledgebaseFrame());
        this.nonFatalErrorSubscriber = new NonFatalErrorSubscriber((Frame)this.getKnowledgebaseFrame());
        this.warningSubscriber = new WarningSubscriber((Frame)this.getKnowledgebaseFrame());
        EventBus.subscribe((String)"vars.shared.ui.GlobalLookup-TopicFatalError", (EventTopicSubscriber)this.fatalErrorSubscriber);
        EventBus.subscribe((String)"vars.shared.ui.GlobalLookup-TopicNonfatalError", (EventTopicSubscriber)this.nonFatalErrorSubscriber);
        EventBus.subscribe((String)"vars.shared.ui.GlobalLookup-TopicWarning", (EventTopicSubscriber)this.warningSubscriber);
        StateLookup.setApplication(this);
        StateLookup.userAccountProperty().addListener((obs, oldVal, newVal) -> {
            Concept selectedConcept = StateLookup.getSelectedConcept();
            StateLookup.setSelectedConcept(null);
            StateLookup.setSelectedConcept(selectedConcept);
        });
    }

    public KnowledgebaseFrame getKnowledgebaseFrame() {
        if (this.knowledgebaseFrame == null) {
            this.knowledgebaseFrame = new KnowledgebaseFrame(this.toolBelt);
            StateLookup.setApplicationFrame(this.knowledgebaseFrame);
            StateLookup.setSelectedFrame((Frame)this.knowledgebaseFrame);
        }
        return this.knowledgebaseFrame;
    }

    private static Logger getLog() {
        if (log == null) {
            log = LoggerFactory.getLogger(App.class);
        }
        return log;
    }

    private void initialize() {
        ImageIcon mbariLogo = new ImageIcon(this.getClass().getResource("/images/vars/knowledgebase/knowledgebase-splash.png"));
        SplashFrame splashFrame = new SplashFrame(mbariLogo);
        splashFrame.setVisible(true);
        splashFrame.setMessage(" Loading knowledgebase...");
        splashFrame.repaint();
        try {
            Worker.post((Task)new Task(){

                public Object run() throws Exception {
                    App.this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO().findRoot();
                    return null;
                }
            });
        }
        catch (Exception e) {
            splashFrame.setMessage(" WARNING: Failed to load the knowledgebase");
            App.getLog().warn("Failed to load the knowledgebase", (Throwable)e);
            splashFrame.repaint();
            JOptionPane.showMessageDialog((Component)splashFrame, "Unable to load knowledgebase", "VARS - Error", 0, null);
            System.exit(-1);
        }
        try {
            new PopulateDatabaseAction(this.toolBelt).doAction();
        }
        catch (Exception e) {
            splashFrame.setMessage(" Error: Failed to load the knowledgebase");
            App.getLog().error("Failed to load the knowledgebase", (Throwable)e);
            splashFrame.repaint();
            JOptionPane.showMessageDialog((Component)splashFrame, "Unable to load knowledgebase", "VARS - Error", 0, null);
            System.exit(-1);
        }
        splashFrame.setMessage(" Initializing the GUI...");
        splashFrame.repaint();
        this.getKnowledgebaseFrame().pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getKnowledgebaseFrame().getSize();
        double newHeight = screenSize.getHeight() - 150.0;
        frameSize.setSize(frameSize.getWidth(), (double)((int)newHeight));
        this.getKnowledgebaseFrame().setSize(frameSize);
        this.getKnowledgebaseFrame().setIconImage(mbariLogo.getImage());
        try {
            ConceptDAO dao = this.toolBelt.getKnowledgebaseDAOFactory().newConceptDAO();
            dao.startTransaction();
            Concept rootConcept = dao.findRoot();
            dao.endTransaction();
            dao.close();
            StateLookup.setSelectedConcept(rootConcept);
        }
        catch (Exception e) {
            log.error("Unable to locate root concept --- this means trouble!!", (Throwable)e);
            EventBus.publish((String)"vars.shared.ui.GlobalLookup-TopicFatalError", (Object)e);
        }
        this.getKnowledgebaseFrame().setVisible(true);
        splashFrame.dispose();
    }

    public static void main(String[] args) {
        Logger myLog;
        File logDirectory;
        System.setProperty("user.timezone", "UTC");
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable e) {
                Logger log = LoggerFactory.getLogger(thread.getClass());
                log.error("Exception in thread [" + thread.getName() + "]", e);
            }
        });
        String home = System.getProperty("user.home");
        File settingsDirectory = new File(home, ".vars");
        if (!settingsDirectory.exists()) {
            settingsDirectory.mkdir();
        }
        if (!(logDirectory = new File(settingsDirectory, "logs")).exists()) {
            logDirectory.mkdir();
        }
        if ((myLog = App.getLog()).isInfoEnabled()) {
            Date date = new Date();
            myLog.info("This application was launched at " + date.toString());
        }
        if (SystemUtilities.isMacOS()) {
            SystemUtilities.configureMacOSApplication((String)"VARS Knowledgebase");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            myLog.info("Unable to set look and feel", (Throwable)e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new App();
            }
        });
    }
}

