/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;

public final class ViewDescriptor
extends UniqueTupleDescriptor
implements Dependent,
Provider {
    private final int checkOption;
    private String viewName;
    private final String viewText;
    private UUID uuid;
    private final UUID compSchemaId;
    public static final int NO_CHECK_OPTION = 0;

    public ViewDescriptor(DataDictionary dataDictionary, UUID uUID, String string, String string2, int n, UUID uUID2) {
        super(dataDictionary);
        this.uuid = uUID;
        this.viewText = string2;
        this.viewName = string;
        this.checkOption = n;
        this.compSchemaId = uUID2;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uUID) {
        this.uuid = uUID;
    }

    public String getViewText() {
        return this.viewText;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public int getCheckOptionType() {
        return this.checkOption;
    }

    public UUID getCompSchemaId() {
        return this.compSchemaId;
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(145);
    }

    @Override
    public String getObjectName() {
        return this.viewName;
    }

    @Override
    public UUID getObjectID() {
        return this.uuid;
    }

    @Override
    public String getClassType() {
        return "View";
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void prepareToInvalidate(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        switch (n) {
            case 2: 
            case 3: 
            case 12: 
            case 15: 
            case 20: 
            case 22: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 47: 
            case 48: {
                break;
            }
            case 23: {
                break;
            }
            default: {
                DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
                throw StandardException.newException("X0Y23.S", dependencyManager.getActionString(n), provider.getObjectName(), this.viewName);
            }
        }
    }

    @Override
    public void makeInvalid(int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        switch (n) {
            case 2: 
            case 3: 
            case 12: 
            case 15: 
            case 20: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 48: {
                break;
            }
            case 37: 
            case 44: 
            case 47: {
                TableDescriptor tableDescriptor = this.getDataDictionary().getTableDescriptor(this.uuid);
                if (tableDescriptor == null) break;
                this.drop(languageConnectionContext, tableDescriptor.getSchemaDescriptor(), tableDescriptor, n);
                languageConnectionContext.getLastActivation().addWarning(StandardException.newWarning("01501", this.getObjectName()));
                break;
            }
        }
    }

    public String toString() {
        return "";
    }

    public void drop(LanguageConnectionContext languageConnectionContext, SchemaDescriptor schemaDescriptor, TableDescriptor tableDescriptor) throws StandardException {
        this.drop(languageConnectionContext, schemaDescriptor, tableDescriptor, 9);
    }

    private void drop(LanguageConnectionContext languageConnectionContext, SchemaDescriptor schemaDescriptor, TableDescriptor tableDescriptor, int n) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.dropAllColumnDescriptors(tableDescriptor.getUUID(), transactionController);
        dependencyManager.invalidateFor(tableDescriptor, n, languageConnectionContext);
        dependencyManager.clearDependencies(languageConnectionContext, this);
        dataDictionary.dropViewDescriptor(this, transactionController);
        dataDictionary.dropAllTableAndColPermDescriptors(tableDescriptor.getUUID(), transactionController);
        dataDictionary.dropTableDescriptor(tableDescriptor, schemaDescriptor, transactionController);
    }

    public String getName() {
        return this.viewName;
    }
}

