/*
 * Decompiled with CFR 0.152.
 */
package vars.query.results;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mbari.util.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.query.results.QueryResults;

public class SaveImagesFn {
    private final File targetDir;
    private final QueryResults queryResults;
    private volatile boolean ok = true;
    private Consumer<Double> progressFn;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Executor executor;

    public SaveImagesFn(Executor executor, File targetDir, QueryResults queryResults, Consumer<Double> progressFn) {
        this.executor = executor;
        this.queryResults = queryResults;
        this.targetDir = targetDir;
        this.progressFn = progressFn;
    }

    public void apply() {
        this.executor.execute(() -> {
            Tuple2<List<String>, List<String[]>> rowData = this.queryResults.toRowOrientedData();
            List rows = (List)rowData.getB();
            double n = rows.size();
            for (int i = 0; i < rows.size(); ++i) {
                this.progressFn.accept((double)i / n);
                if (!this.ok) break;
                List imageRefs = Arrays.stream((Object[])rows.get(i)).filter(s -> {
                    String u = s.toUpperCase();
                    return !(!u.startsWith("HTTP") && !u.startsWith("FILE") || !u.endsWith(".PNG") && !u.endsWith(".JPG") && !u.endsWith(".JPEG") && !u.endsWith(".TIF") && !u.endsWith(".TIFF") && !u.endsWith(".GIF"));
                }).collect(Collectors.toList());
                if (imageRefs.isEmpty()) continue;
                try {
                    URL src = new URL((String)imageRefs.get(0));
                    File dst = this.urlToLocalPath(src);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Saving " + src.toExternalForm() + " to " + dst.getAbsolutePath());
                    }
                    this.copy(src, dst);
                    continue;
                }
                catch (Exception e) {
                    this.log.debug("Failed to save image from " + (String)imageRefs.get(0));
                }
            }
            this.progressFn.accept(0.0);
        });
    }

    private void copy(URL src, File dst) throws IOException {
        if (src != null && dst != null) {
            boolean success = true;
            File parent = dst.getParentFile();
            if (!parent.exists()) {
                success = parent.mkdirs();
            }
            if (success) {
                int len;
                InputStream in = src.openStream();
                FileOutputStream out = new FileOutputStream(dst);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                in.close();
                ((OutputStream)out).close();
            }
        }
    }

    private File urlToLocalPath(URL url) {
        String[] parts = url.toExternalForm().replace("%20", " ").split("/");
        int idx = 0;
        for (int i = 0; i < parts.length; ++i) {
            String s = parts[i];
            if (!s.equalsIgnoreCase("framegrabs")) continue;
            idx = i + 1;
            break;
        }
        File f = this.targetDir;
        for (int i = idx; i < parts.length; ++i) {
            String s = parts[i];
            if (s.equalsIgnoreCase("http:") || s.equals("")) continue;
            f = new File(f, parts[i]);
        }
        return f;
    }
}

