/*
 * Decompiled with CFR 0.152.
 */
package vars.query.results;

import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.mbari.util.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResults {
    private Map<String, List<Object>> resultsMap = new TreeMap<String, List<Object>>();
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final transient int rows;

    public QueryResults(Map<String, List<Object>> data) {
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"Data can not be null");
        Preconditions.checkArgument((!data.isEmpty() ? 1 : 0) != 0, (Object)"Data can not be empty");
        Map.Entry<String, List<Object>> firstEntry = data.entrySet().iterator().next();
        this.rows = firstEntry.getValue().size();
        for (Map.Entry<String, List<Object>> entry : data.entrySet()) {
            Preconditions.checkArgument((entry.getValue().size() == this.rows ? 1 : 0) != 0, (Object)("Expected column to have " + this.rows + " elements. Found " + entry.getValue().size()));
        }
        this.resultsMap.putAll(data);
    }

    public List getValues(String columnName) {
        Set columnNames = this.resultsMap.keySet().stream().filter(s -> s.equalsIgnoreCase(columnName)).collect(Collectors.toSet());
        if (columnNames.isEmpty()) {
            return new ArrayList();
        }
        return this.resultsMap.get(columnNames.iterator().next());
    }

    public Tuple2<List<String>, List<String[]>> toRowOrientedData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        int rows = this.getRows();
        int cols = this.getColumns();
        for (int r = 0; r < rows; ++r) {
            data.add(new String[cols]);
        }
        ArrayList<String> columnNames = new ArrayList<String>(this.getColumnNames());
        for (int c = 0; c < cols; ++c) {
            List d = this.getValues((String)columnNames.get(c));
            for (int r = 0; r < rows; ++r) {
                String s;
                Object val = d.get(r);
                ((String[])data.get((int)r))[c] = s = val == null ? "" : val.toString();
            }
        }
        return new Tuple2(columnNames, data);
    }

    public String[][] toRowOrientedArray() {
        Tuple2<List<String>, List<String[]>> t = this.toRowOrientedData();
        List array = (List)t.getB();
        int r = array.size();
        int c = ((String[])array.get(0)).length;
        String[][] data = new String[r][c];
        for (int i = 0; i < r; ++i) {
            data[i] = (String[])array.get(i);
        }
        return data;
    }

    public Set<String> getColumnNames() {
        return new TreeSet<String>(this.resultsMap.keySet());
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.resultsMap.keySet().size();
    }

    public Map<String, List<Object>> copyData() {
        TreeMap<String, List<Object>> newMap = new TreeMap<String, List<Object>>();
        this.resultsMap.entrySet().stream().forEach(entry -> {
            List cfr_ignored_0 = newMap.put((String)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        });
        return newMap;
    }

    public static QueryResults fromResultSet(ResultSet resultSet) throws SQLException {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<String> returnTypes = new ArrayList<String>();
        ResultSetMetaData metaData = resultSet.getMetaData();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            columnNames.add(metaData.getColumnLabel(i));
            returnTypes.add(metaData.getColumnClassName(i).toLowerCase());
        }
        ArrayList data = new ArrayList();
        TreeMap<String, List<Object>> resultsMap = new TreeMap<String, List<Object>>();
        columnNames.stream().forEach(n -> {
            ArrayList list = new ArrayList();
            resultsMap.put((String)n, list);
            data.add(list);
        });
        int colCount = metaData.getColumnCount();
        while (resultSet.next()) {
            for (int i = 0; i < colCount; ++i) {
                List d = (List)data.get(i);
                if (((String)returnTypes.get(i)).equals("oracle.sql.timestamp")) {
                    d.add(resultSet.getTimestamp(i + 1));
                    continue;
                }
                d.add(resultSet.getObject(i + 1));
            }
        }
        return new QueryResults(resultsMap);
    }
}

