/*
 * Decompiled with CFR 0.152.
 */
package vars.query.results;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import vars.query.results.QueryResults;

public class CoalescingDecorator {
    public static QueryResults coalesce(QueryResults queryResults, String keyColumnName) {
        Map<String, List<Object>> resultsMap = queryResults.copyData();
        Map<String, List<Object>> combinedMap = CoalescingDecorator.newEmptyResultMap(resultsMap);
        List keyColumn = queryResults.getValues(keyColumnName);
        List<Object> distinctKeys = keyColumn.stream().distinct().collect(Collectors.toList());
        distinctKeys.forEach(key -> {
            Map<String, List<Object>> rows = CoalescingDecorator.extractRowsWithSameKey(resultsMap, keyColumn, key);
            if (rows.values().iterator().next().size() == 1) {
                CoalescingDecorator.addRowToMap(combinedMap, rows);
            } else {
                Map<String, Object> row = CoalescingDecorator.combineRows(rows);
                CoalescingDecorator.addNewRowToMap(combinedMap, row);
            }
        });
        return new QueryResults(combinedMap);
    }

    private static Map<String, Object> combineRows(Map<String, List<Object>> rowsToCombine) {
        HashMap<String, Object> combinedValues = new HashMap<String, Object>();
        for (String key : rowsToCombine.keySet()) {
            List<Object> values = rowsToCombine.get(key);
            String combinedValue = values.stream().filter(obj -> obj != null).distinct().map(Object::toString).sorted().collect(Collectors.joining(", "));
            combinedValues.put(key, combinedValue);
        }
        return combinedValues;
    }

    private static Map<String, List<Object>> extractRowsWithSameKey(Map<String, List<Object>> resultsMap, List<Object> keyColumn, Object key) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i2 = 0; i2 < keyColumn.size(); ++i2) {
            Object key0 = keyColumn.get(i2);
            if (key == null || !key.equals(key0)) continue;
            rows.add(i2);
        }
        Map<String, List<Object>> matches = CoalescingDecorator.newEmptyResultMap(resultsMap);
        for (String columnName : resultsMap.keySet()) {
            List<Object> allRows = resultsMap.get(columnName);
            List<Object> matchedRows = matches.get(columnName);
            rows.forEach(i -> matchedRows.add(allRows.get((int)i)));
        }
        return matches;
    }

    private static Map<String, List<Object>> newEmptyResultMap(Map<String, List<Object>> resultsMap) {
        HashMap<String, List<Object>> emptyMap = new HashMap<String, List<Object>>(resultsMap.size());
        for (String key : resultsMap.keySet()) {
            emptyMap.put(key, new ArrayList());
        }
        return emptyMap;
    }

    private static void addNewRowToMap(Map<String, List<Object>> combinedMap, Map<String, Object> row) {
        for (String key : combinedMap.keySet()) {
            combinedMap.get(key).add(row.get(key));
        }
    }

    private static void addRowToMap(Map<String, List<Object>> combinedMap, Map<String, List<Object>> row) {
        for (String key : combinedMap.keySet()) {
            combinedMap.get(key).add(row.get(key).get(0));
        }
    }
}

