/*
 * Decompiled with CFR 0.152.
 */
package vars.query;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mbari.sql.QueryFunction;
import org.mbari.sql.QueryResults;
import org.mbari.sql.QueryableImpl;
import vars.ILink;
import vars.LinkBean;
import vars.VARSException;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.query.QueryPersistenceService;

public class QueryPersistenceServiceImpl
implements QueryPersistenceService {
    private final QueryableImpl annoQueryable;
    private final QueryableImpl kbQueryable;
    private final String url;
    private final KnowledgebaseDAOFactory knowledgebaseDAOFactory;
    protected final Function<Concept, Collection<String>> asNames = c -> c.getConceptNames().stream().map(ConceptName::getName).collect(Collectors.toList());

    @Inject
    public QueryPersistenceServiceImpl(KnowledgebaseDAOFactory knowledgebaseDAOFactory) {
        String jdbcUrl;
        this.knowledgebaseDAOFactory = knowledgebaseDAOFactory;
        ResourceBundle bundle = ResourceBundle.getBundle("annotation-jdbc", Locale.US);
        this.url = jdbcUrl = bundle.getString("jdbc.url");
        String jdbcUsername = bundle.getString("jdbc.username");
        String jdbcPassword = bundle.getString("jdbc.password");
        String jdbcDriver = bundle.getString("jdbc.driver");
        this.annoQueryable = new QueryableImpl(jdbcUrl, jdbcUsername, jdbcPassword, jdbcDriver);
        bundle = ResourceBundle.getBundle("knowledgebase-jdbc", Locale.US);
        jdbcUrl = bundle.getString("jdbc.url");
        jdbcUsername = bundle.getString("jdbc.username");
        jdbcPassword = bundle.getString("jdbc.password");
        jdbcDriver = bundle.getString("jdbc.driver");
        this.kbQueryable = new QueryableImpl(jdbcUrl, jdbcUsername, jdbcPassword, jdbcDriver);
    }

    public List<String> findAllConceptNamesAsStrings() {
        QueryFunction queryFunction = resultSet -> {
            ArrayList<String> conceptNamesAsStrings = new ArrayList<String>();
            while (resultSet.next()) {
                conceptNamesAsStrings.add(resultSet.getString(1));
            }
            return conceptNamesAsStrings;
        };
        String query = "SELECT ConceptName FROM ConceptName ORDER BY ConceptName";
        return (List)this.kbQueryable.executeQueryFunction(query, queryFunction);
    }

    public Collection<ILink> findAllLinkTemplates() {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT DISTINCT linkName, toConcept, linkValue ");
        sb.append("FROM LinkTemplate");
        QueryFunction queryFunction = resultSet -> {
            ArrayList<LinkBean> associationBeans = new ArrayList<LinkBean>();
            while (resultSet.next()) {
                LinkBean bean = new LinkBean();
                bean.setLinkName(resultSet.getString(1));
                bean.setToConcept(resultSet.getString(2));
                bean.setLinkValue(resultSet.getString(3));
                associationBeans.add(bean);
            }
            return associationBeans;
        };
        return (Collection)this.kbQueryable.executeQueryFunction(sb.toString(), queryFunction);
    }

    public Collection<String> findAllNamesUsedInAnnotations() {
        HashSet allNames = new HashSet();
        QueryFunction queryFunction = resultSet -> {
            while (resultSet.next()) {
                allNames.add(resultSet.getString(1));
            }
            return allNames;
        };
        String sql = "SELECT DISTINCT ConceptName From ConceptName WHERE ConceptName IS NOT NULL";
        this.kbQueryable.executeQueryFunction(sql, queryFunction);
        String query = "SELECT DISTINCT ConceptName FROM Observation WHERE ConceptName IS NOT NULL UNION SELECT DISTINCT ToConcept FROM Association WHERE ToConcept IS NOT NULL";
        this.annoQueryable.executeQueryFunction(query, queryFunction);
        ArrayList<String> sortedNames = new ArrayList<String>(allNames);
        Collections.sort(sortedNames);
        return sortedNames;
    }

    public Collection<ILink> findLinksByConceptNames(Collection<String> conceptNames) {
        QueryFunction queryFunction = new QueryFunction(){

            public Object apply(ResultSet resultSet) throws SQLException {
                ArrayList<LinkBean> associationBeans = new ArrayList<LinkBean>();
                while (resultSet.next()) {
                    LinkBean bean = new LinkBean();
                    bean.setLinkName(resultSet.getString(1));
                    bean.setToConcept(resultSet.getString(2));
                    bean.setLinkValue(resultSet.getString(3));
                    associationBeans.add(bean);
                }
                return associationBeans;
            }
        };
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT DISTINCT linkName, toConcept, linkValue ");
        sb.append("FROM Association JOIN Observation ON Observation.id = Association.ObservationID_FK ");
        sb.append("WHERE ");
        Iterator<String> i = conceptNames.iterator();
        while (i.hasNext()) {
            String conceptName = i.next();
            sb.append("ConceptName = ?");
            if (!i.hasNext()) continue;
            sb.append(" OR ");
        }
        sb.append(" ORDER BY LinkName, toConcept, linkValue");
        ArrayList<ILink> links = new ArrayList<ILink>();
        try {
            Connection connection = this.annoQueryable.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());
            int idx = 1;
            for (String name : conceptNames) {
                preparedStatement.setString(idx, name);
                ++idx;
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            links.addAll((Collection)queryFunction.apply(resultSet));
            preparedStatement.close();
        }
        catch (Exception e) {
            throw new VARSException("Failed to execute PreparedStatement of " + sb.toString(), (Throwable)e);
        }
        return links;
    }

    public QueryableImpl getAnnotationQueryable() {
        return this.annoQueryable;
    }

    public Integer getCountOfUniqueValuesByColumn(String columnName) {
        QueryFunction queryFunction = new QueryFunction(){

            public Object apply(ResultSet resultSet) throws SQLException {
                Integer count = 0;
                while (resultSet.next()) {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                return count;
            }
        };
        String query = "SELECT DISTINCT count(" + columnName + ") FROM Annotations";
        return (Integer)this.annoQueryable.executeQueryFunction(query, queryFunction);
    }

    public Map<String, String> getMetaData() {
        QueryFunction queryFunction = new QueryFunction(){

            public Object apply(ResultSet resultSet) throws SQLException {
                TreeMap<String, String> map = new TreeMap<String, String>();
                ResultSetMetaData metaData = resultSet.getMetaData();
                int colCount = metaData.getColumnCount();
                for (int i = 1; i <= colCount; ++i) {
                    map.put(metaData.getColumnLabel(i), metaData.getColumnClassName(i));
                }
                return map;
            }
        };
        String query = "SELECT * FROM Annotations WHERE ObservationID_FK = 0";
        return (Map)this.annoQueryable.executeQueryFunction(query, queryFunction);
    }

    public String getURL() {
        return this.url;
    }

    public Collection<?> getUniqueValuesByColumn(String columnName) {
        String query = "SELECT DISTINCT " + columnName + " FROM Annotations WHERE " + columnName + " IS NOT NULL ORDER BY " + columnName;
        QueryFunction queryFunction = new QueryFunction(){

            public Object apply(ResultSet resultSet) throws SQLException {
                ArrayList<Object> values = new ArrayList<Object>();
                while (resultSet.next()) {
                    values.add(resultSet.getObject(1));
                }
                return values;
            }
        };
        return (Collection)this.annoQueryable.executeQueryFunction(query, queryFunction);
    }

    public List<Concept> findAncestors(String conceptName) {
        Concept concept;
        ArrayList<Concept> names = new ArrayList<Concept>();
        ConceptDAO conceptDAO = this.knowledgebaseDAOFactory.newConceptDAO();
        conceptDAO.startTransaction();
        if (concept != null) {
            for (concept = conceptDAO.findByName(conceptName); concept != null; concept = concept.getParentConcept()) {
                names.add(concept);
            }
        }
        conceptDAO.endTransaction();
        Collections.reverse(names);
        return names;
    }

    public Collection<Concept> findConcepts(String name, boolean extendToParent, boolean extendToSiblings, boolean extendToChildren, boolean extendToDescendants) {
        HashSet<Concept> concepts = new HashSet<Concept>();
        ConceptDAO conceptDAO = this.knowledgebaseDAOFactory.newConceptDAO();
        conceptDAO.startTransaction();
        Concept c = conceptDAO.findByName(name);
        if (c != null) {
            concepts.add(c);
            if (extendToParent && c.getParentConcept() != null) {
                concepts.add(c.getParentConcept());
            }
            if (extendToSiblings && c.getParentConcept() != null) {
                concepts.addAll(c.getParentConcept().getChildConcepts());
            }
            if (extendToChildren && !extendToDescendants) {
                concepts.addAll(c.getChildConcepts());
            }
            if (extendToDescendants) {
                concepts.addAll(conceptDAO.findDescendents(c));
            }
        }
        conceptDAO.endTransaction();
        conceptDAO.close();
        return concepts;
    }

    public List<String> findConceptNamesAsStrings(String name, boolean extendToParent, boolean extendToSiblings, boolean extendToChildren, boolean extendToDescendants) {
        Collection<Concept> concepts = this.findConcepts(name, extendToParent, extendToSiblings, extendToChildren, extendToDescendants);
        List<String> names = concepts != null ? concepts.stream().flatMap(c -> this.asNames.apply((Concept)c).stream()).sorted().collect(Collectors.toList()) : new ArrayList<String>();
        return names;
    }

    public List<String> findDescendantNamesAsStrings(String conceptName) {
        ConceptDAO conceptDAO = this.knowledgebaseDAOFactory.newConceptDAO();
        conceptDAO.startTransaction();
        Concept concept = conceptDAO.findByName(conceptName);
        List<Object> names = concept == null ? Lists.newArrayList() : conceptDAO.findDescendentNames(concept).stream().map(ConceptName::getName).sorted().collect(Collectors.toList());
        conceptDAO.endTransaction();
        return names;
    }

    public QueryResults executeQuery(String query) throws Exception {
        return this.annoQueryable.executeQuery(query);
    }

    public <T> T executeQueryFunction(String query, QueryFunction<T> queryFunction) {
        return (T)this.annoQueryable.executeQueryFunction(query, queryFunction);
    }
}

