/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.jpa;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import javax.persistence.EntityManager;
import vars.ILink;
import vars.LinkComparator;
import vars.jpa.DAO;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.LinkTemplate;
import vars.knowledgebase.LinkTemplateDAO;
import vars.knowledgebase.jpa.ConceptDAOImpl;

public class LinkTemplateDAOImpl
extends DAO
implements LinkTemplateDAO {
    private static final Comparator<ILink> linkComparator = new LinkComparator();
    private final ConceptDAO conceptDAO;

    @Inject
    public LinkTemplateDAOImpl(EntityManager entityManager) {
        super(entityManager);
        this.conceptDAO = new ConceptDAOImpl(entityManager);
    }

    public Collection<LinkTemplate> findAllApplicableToConcept(Concept concept) {
        ArrayList<LinkTemplate> linkTemplates = new ArrayList<LinkTemplate>();
        while (concept != null) {
            linkTemplates.addAll(concept.getConceptMetadata().getLinkTemplates());
            concept = concept.getParentConcept();
        }
        linkTemplates.sort(linkComparator);
        return linkTemplates;
    }

    public Collection<LinkTemplate> findAllByLinkFields(String linkName, String toConcept, String linkValue) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("linkName", linkName);
        params.put("toConcept", toConcept);
        params.put("linkValue", linkValue);
        return this.findByNamedQuery("LinkTemplate.findByFields", params);
    }

    public Collection<LinkTemplate> findAllByLinkName(String linkName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("linkName", linkName);
        return this.findByNamedQuery("LinkTemplate.findByLinkName", params);
    }

    public Collection<LinkTemplate> findAllByLinkName(final String linkName, Concept concept) {
        Collection<LinkTemplate> linkTemplates = this.findAllApplicableToConcept(concept);
        return Collections2.filter(linkTemplates, (Predicate)new Predicate<LinkTemplate>(){

            public boolean apply(LinkTemplate linkTemplate) {
                return linkTemplate.getLinkName().equals(linkName);
            }
        });
    }

    public void validateName(LinkTemplate object) {
        Concept concept = this.conceptDAO.findByName(object.getToConcept());
        if (concept != null) {
            object.setToConcept(concept.getPrimaryConceptName().getName());
        } else {
            this.log.warn(object + " contains a 'conceptName', " + object.getToConcept() + " that was not found in the knowlegebase");
        }
    }
}

