/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.jpa;

import com.google.common.collect.ImmutableList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import vars.ILink;
import vars.LinkUtilities;
import vars.jpa.JPAEntity;
import vars.jpa.KeyNullifier;
import vars.jpa.TransactionLogger;
import vars.knowledgebase.ConceptMetadata;
import vars.knowledgebase.LinkRealization;
import vars.knowledgebase.jpa.ConceptMetadataImpl;

@Entity(name="LinkRealization")
@Table(name="LinkRealization", indexes={@Index(name="idx_LinkRealization_FK1", columnList="ConceptDelegateID_FK"), @Index(name="idx_LinkRealization_LUT", columnList="LAST_UPDATED_TIME")})
@EntityListeners(value={TransactionLogger.class, KeyNullifier.class})
@NamedQueries(value={@NamedQuery(name="LinkRealization.findById", query="SELECT v FROM LinkRealization v WHERE v.id = :id"), @NamedQuery(name="LinkRealization.findByLinkName", query="SELECT l FROM LinkRealization l WHERE l.linkName = :linkName"), @NamedQuery(name="LinkRealization.findByToConcept", query="SELECT l FROM LinkRealization l WHERE l.toConcept = :toConcept"), @NamedQuery(name="LinkRealization.findByLinkValue", query="SELECT l FROM LinkRealization l WHERE l.linkValue = :linkValue")})
public class LinkRealizationImpl
implements Serializable,
LinkRealization,
JPAEntity,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    @Transient
    private static final List<String> PROPS = ImmutableList.of((Object)"linkName", (Object)"toConcept", (Object)"linkValue");
    @Id
    @Column(name="id", nullable=false, updatable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="LinkRealization_Gen")
    @TableGenerator(name="LinkRealization_Gen", table="UniqueID", pkColumnName="TableName", valueColumnName="NextID", pkColumnValue="LinkRealization", allocationSize=1)
    Long id;
    @Version
    @Column(name="LAST_UPDATED_TIME")
    private Timestamp updatedTime;
    @Column(name="LinkName", length=50)
    String linkName;
    @Column(name="ToConcept", length=128)
    String toConcept;
    @Column(name="LinkValue", length=2048)
    String linkValue;
    @ManyToOne(optional=false, targetEntity=ConceptMetadataImpl.class, cascade={CascadeType.MERGE, CascadeType.REFRESH})
    @JoinColumn(name="ConceptDelegateID_FK")
    ConceptMetadata conceptMetadata;
    static final long serialVersionUID = -5519100880681708489L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public LinkRealizationImpl() {
    }

    public LinkRealizationImpl(String linkName, String toConcept, String linkValue) {
        this.linkName = linkName;
        this.toConcept = toConcept;
        this.linkValue = linkValue;
    }

    public String getFromConcept() {
        return this._persistence_get_conceptMetadata() == null ? null : this._persistence_get_conceptMetadata().getConcept().getPrimaryConceptName().getName();
    }

    public String stringValue() {
        return LinkUtilities.formatAsString((ILink)this);
    }

    public String toString() {
        return "LinkRealizationImpl ([id=" + this._persistence_get_id() + "] linkName=" + this._persistence_get_linkName() + ", toConcept=" + this._persistence_get_toConcept() + ", linkValue=" + this._persistence_get_linkValue() + ")";
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this.getClass() != that.getClass()) {
            return false;
        }
        return this.stringValue().equals(((LinkRealization)that).stringValue());
    }

    public int hashCode() {
        return this.stringValue().hashCode() * 11;
    }

    public ConceptMetadata getConceptMetadata() {
        return this._persistence_get_conceptMetadata();
    }

    public String getLinkName() {
        return this._persistence_get_linkName();
    }

    public void setLinkName(String linkName) {
        this._persistence_set_linkName(linkName);
    }

    public String getToConcept() {
        return this._persistence_get_toConcept();
    }

    public Object getPrimaryKey() {
        return this.getId();
    }

    public void setId(Long id) {
        this._persistence_set_id(id);
    }

    public void setToConcept(String toConcept) {
        this._persistence_set_toConcept(toConcept);
    }

    public String getLinkValue() {
        return this._persistence_get_linkValue();
    }

    public void setLinkValue(String linkValue) {
        this._persistence_set_linkValue(linkValue);
    }

    @Override
    public Long getId() {
        return this._persistence_get_id();
    }

    public void setConceptMetadata(ConceptMetadata conceptMetadata) {
        this._persistence_set_conceptMetadata(conceptMetadata);
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new LinkRealizationImpl();
    }

    public Object _persistence_get(String string) {
        if (string == "linkValue") {
            return this.linkValue;
        }
        if (string == "updatedTime") {
            return this.updatedTime;
        }
        if (string == "toConcept") {
            return this.toConcept;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "conceptMetadata") {
            return this.conceptMetadata;
        }
        if (string == "linkName") {
            return this.linkName;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "linkValue") {
            this.linkValue = (String)object;
            return;
        }
        if (string == "updatedTime") {
            this.updatedTime = (Timestamp)object;
            return;
        }
        if (string == "toConcept") {
            this.toConcept = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "conceptMetadata") {
            this.conceptMetadata = (ConceptMetadata)object;
            return;
        }
        if (string == "linkName") {
            this.linkName = (String)object;
            return;
        }
    }

    public String _persistence_get_linkValue() {
        this._persistence_checkFetched("linkValue");
        return this.linkValue;
    }

    public void _persistence_set_linkValue(String string) {
        this._persistence_checkFetchedForSet("linkValue");
        this._persistence_propertyChange("linkValue", this.linkValue, string);
        this.linkValue = string;
    }

    public Timestamp _persistence_get_updatedTime() {
        this._persistence_checkFetched("updatedTime");
        return this.updatedTime;
    }

    public void _persistence_set_updatedTime(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("updatedTime");
        this._persistence_propertyChange("updatedTime", this.updatedTime, timestamp);
        this.updatedTime = timestamp;
    }

    public String _persistence_get_toConcept() {
        this._persistence_checkFetched("toConcept");
        return this.toConcept;
    }

    public void _persistence_set_toConcept(String string) {
        this._persistence_checkFetchedForSet("toConcept");
        this._persistence_propertyChange("toConcept", this.toConcept, string);
        this.toConcept = string;
    }

    public Long _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(Long l) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, l);
        this.id = l;
    }

    public ConceptMetadata _persistence_get_conceptMetadata() {
        this._persistence_checkFetched("conceptMetadata");
        return this.conceptMetadata;
    }

    public void _persistence_set_conceptMetadata(ConceptMetadata conceptMetadata) {
        this._persistence_checkFetchedForSet("conceptMetadata");
        this._persistence_propertyChange("conceptMetadata", this.conceptMetadata, conceptMetadata);
        this.conceptMetadata = conceptMetadata;
    }

    public String _persistence_get_linkName() {
        this._persistence_checkFetched("linkName");
        return this.linkName;
    }

    public void _persistence_set_linkName(String string) {
        this._persistence_checkFetchedForSet("linkName");
        this._persistence_propertyChange("linkName", this.linkName, string);
        this.linkName = string;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

