/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.jpa;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import javax.persistence.EntityManager;
import vars.jpa.DAO;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.LinkRealization;
import vars.knowledgebase.LinkRealizationDAO;
import vars.knowledgebase.jpa.ConceptDAOImpl;

public class LinkRealizationDAOImpl
extends DAO
implements LinkRealizationDAO {
    private final ConceptDAO conceptDAO;

    @Inject
    public LinkRealizationDAOImpl(EntityManager entityManager) {
        super(entityManager);
        this.conceptDAO = new ConceptDAOImpl(entityManager);
    }

    public Collection<LinkRealization> findAllByLinkName(String linkName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("linkName", linkName);
        return this.findByNamedQuery("LinkRealization.findByLinkName", params);
    }

    public void validateName(LinkRealization object) {
        Concept concept = this.conceptDAO.findByName(object.getToConcept());
        if (concept != null) {
            object.setToConcept(concept.getPrimaryConceptName().getName());
        } else {
            this.log.warn(object + " contains a 'conceptName', " + object.getToConcept() + " that was not found in the knowlegebase");
        }
    }
}

