/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.jpa;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import vars.DAO;
import vars.jpa.EntityManagerFactoryAspect;
import vars.knowledgebase.ArtifactDAO;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptMetadataDAO;
import vars.knowledgebase.ConceptNameDAO;
import vars.knowledgebase.HistoryDAO;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.knowledgebase.LinkRealizationDAO;
import vars.knowledgebase.LinkTemplateDAO;
import vars.knowledgebase.MediaDAO;
import vars.knowledgebase.UsageDAO;
import vars.knowledgebase.jpa.ArtifactDAOImpl;
import vars.knowledgebase.jpa.ConceptDAOImpl;
import vars.knowledgebase.jpa.ConceptMetadataDAOImpl;
import vars.knowledgebase.jpa.ConceptNameDAOImpl;
import vars.knowledgebase.jpa.HistoryDAOImpl;
import vars.knowledgebase.jpa.LinkRealizationDAOImpl;
import vars.knowledgebase.jpa.LinkTemplateDAOImpl;
import vars.knowledgebase.jpa.MediaDAOImpl;
import vars.knowledgebase.jpa.UsageDAOImpl;

public class KnowledgebaseDAOFactoryImpl
implements KnowledgebaseDAOFactory,
EntityManagerFactoryAspect {
    private final EntityManagerFactory entityManagerFactory;

    @Inject
    public KnowledgebaseDAOFactoryImpl(@Named(value="knowledgebasePersistenceUnit") EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public ArtifactDAO newArtifactDAO() {
        return new ArtifactDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public ArtifactDAO newArtifactDAO(EntityManager entityManager) {
        return new ArtifactDAOImpl(entityManager);
    }

    public ConceptDAO newConceptDAO() {
        return new ConceptDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public ConceptDAO newConceptDAO(EntityManager entityManager) {
        return new ConceptDAOImpl(entityManager);
    }

    public ConceptMetadataDAO newConceptMetadataDAO() {
        return new ConceptMetadataDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public ConceptMetadataDAO newConceptMetadataDAO(EntityManager entityManager) {
        return new ConceptMetadataDAOImpl(entityManager);
    }

    public ConceptNameDAO newConceptNameDAO() {
        return new ConceptNameDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public ConceptNameDAO newConceptNameDAO(EntityManager entityManager) {
        return new ConceptNameDAOImpl(entityManager);
    }

    public DAO newDAO() {
        return new vars.jpa.DAO(this.entityManagerFactory.createEntityManager());
    }

    public DAO newDAO(EntityManager entityManager) {
        return new vars.jpa.DAO(entityManager);
    }

    public HistoryDAO newHistoryDAO() {
        return new HistoryDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public HistoryDAO newHistoryDAO(EntityManager entityManager) {
        return new HistoryDAOImpl(entityManager);
    }

    public LinkRealizationDAO newLinkRealizationDAO() {
        return new LinkRealizationDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public LinkRealizationDAO newLinkRealizationDAO(EntityManager entityManager) {
        return new LinkRealizationDAOImpl(entityManager);
    }

    public LinkTemplateDAO newLinkTemplateDAO() {
        return new LinkTemplateDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public LinkTemplateDAO newLinkTemplateDAO(EntityManager entityManager) {
        return new LinkTemplateDAOImpl(entityManager);
    }

    public MediaDAO newMediaDAO() {
        return new MediaDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public MediaDAO newMediaDAO(EntityManager entityManager) {
        return new MediaDAOImpl(entityManager);
    }

    public UsageDAO newUsageDAO() {
        return new UsageDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public UsageDAO newUsageDAO(EntityManager entityManager) {
        return new UsageDAOImpl(entityManager);
    }
}

