/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.jpa;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import vars.jpa.JPAEntity;
import vars.jpa.KeyNullifier;
import vars.jpa.TransactionLogger;
import vars.knowledgebase.ConceptMetadata;
import vars.knowledgebase.History;
import vars.knowledgebase.jpa.ConceptMetadataImpl;

@Entity(name="History")
@Table(name="History", indexes={@Index(name="idx_History_FK1", columnList="ConceptDelegateID_FK"), @Index(name="idx_History_LUT", columnList="LAST_UPDATED_TIME")})
@EntityListeners(value={TransactionLogger.class, KeyNullifier.class})
@NamedQueries(value={@NamedQuery(name="History.findAll", query="SELECT h FROM History h"), @NamedQuery(name="History.findById", query="SELECT v FROM History v WHERE v.id = :id"), @NamedQuery(name="History.findByProcessedDate", query="SELECT h FROM History h WHERE h.processedDate = :processedDate"), @NamedQuery(name="History.findByCreationDate", query="SELECT h FROM History h WHERE h.creationDate = :creationDate"), @NamedQuery(name="History.findByCreatorName", query="SELECT h FROM History h WHERE h.creatorName = :creatorName"), @NamedQuery(name="History.findByProcessorName", query="SELECT h FROM History h WHERE h.processorName = :processorName"), @NamedQuery(name="History.findByField", query="SELECT h FROM History h WHERE h.field = :field"), @NamedQuery(name="History.findByOldValue", query="SELECT h FROM History h WHERE h.oldValue = :oldValue"), @NamedQuery(name="History.findByNewValue", query="SELECT h FROM History h WHERE h.newValue = :newValue"), @NamedQuery(name="History.findByAction", query="SELECT h FROM History h WHERE h.action = :action"), @NamedQuery(name="History.findByComment", query="SELECT h FROM History h WHERE h.comment = :comment"), @NamedQuery(name="History.findByApproved", query="SELECT h FROM History h WHERE h.approved = :approved"), @NamedQuery(name="History.findPendingApproval", query="SELECT h FROM History h WHERE h.processedDate IS NULL"), @NamedQuery(name="History.findApproved", query="SELECT h FROM History h WHERE h.processedDate IS NOT NULL")})
public class HistoryImpl
implements Serializable,
History,
JPAEntity,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    @Id
    @Column(name="id", nullable=false, updatable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="History_Gen")
    @TableGenerator(name="History_Gen", table="UniqueID", pkColumnName="TableName", valueColumnName="NextID", pkColumnValue="History", allocationSize=1)
    Long id;
    @Version
    @Column(name="LAST_UPDATED_TIME")
    private Timestamp updatedTime;
    @Column(name="ProcessedDTG")
    @Temporal(value=TemporalType.TIMESTAMP)
    Date processedDate;
    @Column(name="CreationDTG", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    Date creationDate;
    @Column(name="CreatorName", nullable=false, length=50)
    String creatorName;
    @Column(name="ProcessorName", length=50)
    String processorName;
    @Column(name="Field", length=2048)
    String field;
    @Column(name="OldValue", length=2048)
    String oldValue;
    @Column(name="NewValue", length=2048)
    String newValue;
    @Column(name="Action", length=16)
    String action;
    @Column(name="Comment", length=2048)
    String comment;
    @Column(name="Approved")
    private Short approved = 0;
    @ManyToOne(optional=false, targetEntity=ConceptMetadataImpl.class, cascade={CascadeType.MERGE, CascadeType.REFRESH})
    @JoinColumn(name="ConceptDelegateID_FK")
    ConceptMetadata conceptMetadata;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    static final long serialVersionUID = -6795823073684394389L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public boolean isAdd() {
        return "ADD".equalsIgnoreCase(this._persistence_get_action());
    }

    public Boolean isApproved() {
        return this.isProcessed() ? this._persistence_get_approved() == 1 : false;
    }

    public boolean isDelete() {
        return "DELETE".equalsIgnoreCase(this._persistence_get_action());
    }

    public boolean isReplace() {
        return "REPLACE".equalsIgnoreCase(this._persistence_get_action());
    }

    public boolean isRejected() {
        return this.isProcessed() ? !this.isApproved().booleanValue() : false;
    }

    public boolean isProcessed() {
        return this._persistence_get_processedDate() != null;
    }

    public void setApproved(Boolean approved) {
        this._persistence_set_approved(approved != false ? Short.valueOf((short)1) : Short.valueOf((short)0));
    }

    public String stringValue() {
        String oldVal;
        StringBuffer sb = new StringBuffer("[").append(DATE_FORMAT.format(this._persistence_get_creationDate()));
        sb.append(" by ").append(this._persistence_get_creatorName()).append("] ").append(this._persistence_get_action()).append(" ").append(this._persistence_get_field());
        String newVal = this._persistence_get_newValue() == null ? "" : this._persistence_get_newValue();
        String string = oldVal = this._persistence_get_oldValue() == null ? "" : this._persistence_get_oldValue();
        if ("ADD".equals(this._persistence_get_action())) {
            sb.append(" '").append(newVal).append("'");
        } else if ("DELETE".equals(this._persistence_get_action())) {
            sb.append(" '").append(oldVal).append("'");
        } else if ("REPLACE".equals(this._persistence_get_action())) {
            sb.append(" '").append(oldVal).append("' with '").append(newVal).append("'");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._persistence_get_action() == null ? 0 : this._persistence_get_action().hashCode());
        result = 31 * result + (this._persistence_get_creationDate() == null ? 0 : this._persistence_get_creationDate().hashCode());
        result = 31 * result + (this._persistence_get_creatorName() == null ? 0 : this._persistence_get_creatorName().hashCode());
        result = 31 * result + (this._persistence_get_field() == null ? 0 : this._persistence_get_field().hashCode());
        result = 31 * result + (this._persistence_get_newValue() == null ? 0 : this._persistence_get_newValue().hashCode());
        result = 31 * result + (this._persistence_get_oldValue() == null ? 0 : this._persistence_get_oldValue().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HistoryImpl other = (HistoryImpl)obj;
        if (this._persistence_get_action() == null ? other._persistence_get_action() != null : !this._persistence_get_action().equals(other._persistence_get_action())) {
            return false;
        }
        if (this._persistence_get_creationDate() == null ? other._persistence_get_creationDate() != null : !this._persistence_get_creationDate().equals(other._persistence_get_creationDate())) {
            return false;
        }
        if (this._persistence_get_creatorName() == null ? other._persistence_get_creatorName() != null : !this._persistence_get_creatorName().equals(other._persistence_get_creatorName())) {
            return false;
        }
        if (this._persistence_get_field() == null ? other._persistence_get_field() != null : !this._persistence_get_field().equals(other._persistence_get_field())) {
            return false;
        }
        if (this._persistence_get_newValue() == null ? other._persistence_get_newValue() != null : !this._persistence_get_newValue().equals(other._persistence_get_newValue())) {
            return false;
        }
        return !(this._persistence_get_oldValue() == null ? other._persistence_get_oldValue() != null : !this._persistence_get_oldValue().equals(other._persistence_get_oldValue()));
    }

    public String getAction() {
        return this._persistence_get_action();
    }

    public Date getProcessedDate() {
        return this._persistence_get_processedDate();
    }

    public String getProcessorName() {
        return this._persistence_get_processorName();
    }

    public String getComment() {
        return this._persistence_get_comment();
    }

    public ConceptMetadata getConceptMetadata() {
        return this._persistence_get_conceptMetadata();
    }

    public Date getCreationDate() {
        return this._persistence_get_creationDate();
    }

    public String getCreatorName() {
        return this._persistence_get_creatorName();
    }

    public String getField() {
        return this._persistence_get_field();
    }

    public void setId(Long id) {
        this._persistence_set_id(id);
    }

    public String getNewValue() {
        return this._persistence_get_newValue();
    }

    public String getOldValue() {
        return this._persistence_get_oldValue();
    }

    public Object getPrimaryKey() {
        return this.getId();
    }

    public void setAction(String action) {
        this._persistence_set_action(action);
    }

    public void setProcessedDate(Date approvalDate) {
        this._persistence_set_processedDate(approvalDate);
    }

    public void setProcessorName(String approverName) {
        this._persistence_set_processorName(approverName);
    }

    public void setComment(String comment) {
        this._persistence_set_comment(comment);
    }

    public void setCreationDate(Date creationDate) {
        this._persistence_set_creationDate(creationDate);
    }

    public void setCreatorName(String creatorName) {
        this._persistence_set_creatorName(creatorName);
    }

    public void setField(String field) {
        this._persistence_set_field(field);
    }

    public void setNewValue(String newValue) {
        this._persistence_set_newValue(newValue);
    }

    public void setOldValue(String oldValue) {
        this._persistence_set_oldValue(oldValue);
    }

    @Override
    public Long getId() {
        return this._persistence_get_id();
    }

    void setConceptMetadata(ConceptMetadata conceptMetadata) {
        this._persistence_set_conceptMetadata(conceptMetadata);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HistoryImpl ([id=").append(this._persistence_get_id()).append("] creatorName=").append(this._persistence_get_creatorName()).append(", creationDate=").append(this._persistence_get_creationDate()).append(", action=").append(this._persistence_get_action()).append(", field=").append(this._persistence_get_field()).append(", oldValue=").append(this._persistence_get_oldValue()).append(", newValue=").append(this._persistence_get_newValue()).append(", approved=").append(this._persistence_get_approved()).append(")");
        return builder.toString();
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new HistoryImpl();
    }

    public Object _persistence_get(String string) {
        if (string == "updatedTime") {
            return this.updatedTime;
        }
        if (string == "newValue") {
            return this.newValue;
        }
        if (string == "creatorName") {
            return this.creatorName;
        }
        if (string == "creationDate") {
            return this.creationDate;
        }
        if (string == "processedDate") {
            return this.processedDate;
        }
        if (string == "approved") {
            return this.approved;
        }
        if (string == "field") {
            return this.field;
        }
        if (string == "action") {
            return this.action;
        }
        if (string == "processorName") {
            return this.processorName;
        }
        if (string == "comment") {
            return this.comment;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "oldValue") {
            return this.oldValue;
        }
        if (string == "conceptMetadata") {
            return this.conceptMetadata;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "updatedTime") {
            this.updatedTime = (Timestamp)object;
            return;
        }
        if (string == "newValue") {
            this.newValue = (String)object;
            return;
        }
        if (string == "creatorName") {
            this.creatorName = (String)object;
            return;
        }
        if (string == "creationDate") {
            this.creationDate = (Date)object;
            return;
        }
        if (string == "processedDate") {
            this.processedDate = (Date)object;
            return;
        }
        if (string == "approved") {
            this.approved = (Short)object;
            return;
        }
        if (string == "field") {
            this.field = (String)object;
            return;
        }
        if (string == "action") {
            this.action = (String)object;
            return;
        }
        if (string == "processorName") {
            this.processorName = (String)object;
            return;
        }
        if (string == "comment") {
            this.comment = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "oldValue") {
            this.oldValue = (String)object;
            return;
        }
        if (string == "conceptMetadata") {
            this.conceptMetadata = (ConceptMetadata)object;
            return;
        }
    }

    public Timestamp _persistence_get_updatedTime() {
        this._persistence_checkFetched("updatedTime");
        return this.updatedTime;
    }

    public void _persistence_set_updatedTime(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("updatedTime");
        this._persistence_propertyChange("updatedTime", this.updatedTime, timestamp);
        this.updatedTime = timestamp;
    }

    public String _persistence_get_newValue() {
        this._persistence_checkFetched("newValue");
        return this.newValue;
    }

    public void _persistence_set_newValue(String string) {
        this._persistence_checkFetchedForSet("newValue");
        this._persistence_propertyChange("newValue", this.newValue, string);
        this.newValue = string;
    }

    public String _persistence_get_creatorName() {
        this._persistence_checkFetched("creatorName");
        return this.creatorName;
    }

    public void _persistence_set_creatorName(String string) {
        this._persistence_checkFetchedForSet("creatorName");
        this._persistence_propertyChange("creatorName", this.creatorName, string);
        this.creatorName = string;
    }

    public Date _persistence_get_creationDate() {
        this._persistence_checkFetched("creationDate");
        return this.creationDate;
    }

    public void _persistence_set_creationDate(Date date) {
        this._persistence_checkFetchedForSet("creationDate");
        this._persistence_propertyChange("creationDate", this.creationDate, date);
        this.creationDate = date;
    }

    public Date _persistence_get_processedDate() {
        this._persistence_checkFetched("processedDate");
        return this.processedDate;
    }

    public void _persistence_set_processedDate(Date date) {
        this._persistence_checkFetchedForSet("processedDate");
        this._persistence_propertyChange("processedDate", this.processedDate, date);
        this.processedDate = date;
    }

    public Short _persistence_get_approved() {
        this._persistence_checkFetched("approved");
        return this.approved;
    }

    public void _persistence_set_approved(Short s) {
        this._persistence_checkFetchedForSet("approved");
        this._persistence_propertyChange("approved", this.approved, s);
        this.approved = s;
    }

    public String _persistence_get_field() {
        this._persistence_checkFetched("field");
        return this.field;
    }

    public void _persistence_set_field(String string) {
        this._persistence_checkFetchedForSet("field");
        this._persistence_propertyChange("field", this.field, string);
        this.field = string;
    }

    public String _persistence_get_action() {
        this._persistence_checkFetched("action");
        return this.action;
    }

    public void _persistence_set_action(String string) {
        this._persistence_checkFetchedForSet("action");
        this._persistence_propertyChange("action", this.action, string);
        this.action = string;
    }

    public String _persistence_get_processorName() {
        this._persistence_checkFetched("processorName");
        return this.processorName;
    }

    public void _persistence_set_processorName(String string) {
        this._persistence_checkFetchedForSet("processorName");
        this._persistence_propertyChange("processorName", this.processorName, string);
        this.processorName = string;
    }

    public String _persistence_get_comment() {
        this._persistence_checkFetched("comment");
        return this.comment;
    }

    public void _persistence_set_comment(String string) {
        this._persistence_checkFetchedForSet("comment");
        this._persistence_propertyChange("comment", this.comment, string);
        this.comment = string;
    }

    public Long _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(Long l) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, l);
        this.id = l;
    }

    public String _persistence_get_oldValue() {
        this._persistence_checkFetched("oldValue");
        return this.oldValue;
    }

    public void _persistence_set_oldValue(String string) {
        this._persistence_checkFetchedForSet("oldValue");
        this._persistence_propertyChange("oldValue", this.oldValue, string);
        this.oldValue = string;
    }

    public ConceptMetadata _persistence_get_conceptMetadata() {
        this._persistence_checkFetched("conceptMetadata");
        return this.conceptMetadata;
    }

    public void _persistence_set_conceptMetadata(ConceptMetadata conceptMetadata) {
        this._persistence_checkFetchedForSet("conceptMetadata");
        this._persistence_propertyChange("conceptMetadata", this.conceptMetadata, conceptMetadata);
        this.conceptMetadata = conceptMetadata;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

