/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.jpa;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import vars.jpa.DAO;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameDAO;

public class ConceptNameDAOImpl
extends DAO
implements ConceptNameDAO {
    @Inject
    public ConceptNameDAOImpl(EntityManager entityManager) {
        super(entityManager);
    }

    public ConceptName findByName(final String name) {
        List names = this.findByNamedQuery("ConceptName.findByName", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("name", name);
            }
        });
        return names.size() == 0 ? null : (ConceptName)names.get(0);
    }

    public Collection<ConceptName> findAll() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.findByNamedQuery("ConceptName.findAll", params);
    }

    public Collection<ConceptName> findByNameContaining(final String substring) {
        HashMap<String, Object> params = new HashMap<String, Object>(){
            {
                this.put("name", "%" + substring.toLowerCase() + "%");
            }
        };
        return this.findByNamedQuery("ConceptName.findByNameLike", (Map<String, Object>)params);
    }

    public Collection<ConceptName> findByNameStartingWith(final String s) {
        HashMap<String, Object> params = new HashMap<String, Object>(){
            {
                this.put("name", s.toLowerCase() + "%");
            }
        };
        return this.findByNamedQuery("ConceptName.findByNameLike", (Map<String, Object>)params);
    }

    public List<String> findAllNamesAsStrings() {
        Query query = this.getEntityManager().createNamedQuery("ConceptName.findAllNamesAsStrings");
        return query.getResultList();
    }

    public boolean doesConceptNameExist(String name) {
        Query query = this.getEntityManager().createNamedQuery("ConceptName.countByName");
        query.setParameter(1, (Object)name);
        return (Boolean)query.getResultList().stream().findFirst().map(i -> (Integer)i > 0).orElse(Boolean.FALSE);
    }
}

