/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.jpa;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import vars.jpa.JPAEntity;
import vars.jpa.KeyNullifier;
import vars.jpa.TransactionLogger;
import vars.knowledgebase.Artifact;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptMetadata;
import vars.knowledgebase.History;
import vars.knowledgebase.LinkRealization;
import vars.knowledgebase.LinkTemplate;
import vars.knowledgebase.Media;
import vars.knowledgebase.MediaTypes;
import vars.knowledgebase.Usage;
import vars.knowledgebase.jpa.ArtifactImpl;
import vars.knowledgebase.jpa.ConceptImpl;
import vars.knowledgebase.jpa.HistoryImpl;
import vars.knowledgebase.jpa.LinkRealizationImpl;
import vars.knowledgebase.jpa.LinkTemplateImpl;
import vars.knowledgebase.jpa.MediaImpl;
import vars.knowledgebase.jpa.UsageImpl;

@Entity(name="ConceptMetadata")
@Table(name="ConceptDelegate", indexes={@Index(name="idx_ConceptDelegate_FK1", columnList="ConceptID_FK"), @Index(name="idx_ConceptDelegate_LUT", columnList="LAST_UPDATED_TIME")})
@EntityListeners(value={TransactionLogger.class, KeyNullifier.class})
@NamedQueries(value={@NamedQuery(name="ConceptMetadata.findById", query="SELECT v FROM ConceptMetadata v WHERE v.id = :id")})
public class ConceptMetadataImpl
implements Serializable,
ConceptMetadata,
JPAEntity,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedRest {
    @OneToOne(optional=false, targetEntity=ConceptImpl.class, cascade={CascadeType.MERGE, CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @JoinColumn(name="ConceptID_FK", nullable=false)
    private Concept concept;
    @OneToMany(targetEntity=HistoryImpl.class, mappedBy="conceptMetadata", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @OrderBy(value="creationDate")
    private List<HistoryImpl> histories;
    @Id
    @Column(name="id", nullable=false, updatable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="ConceptDelegate_Gen")
    @TableGenerator(name="ConceptDelegate_Gen", table="UniqueID", pkColumnName="TableName", valueColumnName="NextID", pkColumnValue="ConceptDelegate", allocationSize=1)
    private Long id;
    @OneToMany(targetEntity=LinkRealizationImpl.class, mappedBy="conceptMetadata", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<LinkRealizationImpl> linkRealizations;
    @OneToMany(targetEntity=LinkTemplateImpl.class, mappedBy="conceptMetadata", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<LinkTemplateImpl> linkTemplates;
    @OneToMany(targetEntity=MediaImpl.class, mappedBy="conceptMetadata", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<Media> medias;
    @OneToMany(targetEntity=ArtifactImpl.class, mappedBy="conceptMetadata", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<Artifact> artifacts;
    @Version
    @Column(name="LAST_UPDATED_TIME")
    private Timestamp updatedTime;
    @OneToOne(mappedBy="conceptMetadata", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, targetEntity=UsageImpl.class)
    private Usage usage;
    static final long serialVersionUID = 3333957094451580330L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_concept_vh;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public ConceptMetadataImpl() {
    }

    public void addArtifact(Artifact artifact) {
        if (this.getArtifacts().add(artifact)) {
            ((ArtifactImpl)artifact).setConceptMetadata(this);
        }
    }

    public void addHistory(History history) {
        if (this.getHistories().add(history)) {
            ((HistoryImpl)history).setConceptMetadata(this);
        }
    }

    public void addLinkRealization(LinkRealization linkRealization) {
        if (this.getLinkRealizations().add(linkRealization)) {
            ((LinkRealizationImpl)linkRealization).setConceptMetadata(this);
        }
    }

    public void addLinkTemplate(LinkTemplate linkTemplate) {
        if (this.getLinkTemplates().add(linkTemplate)) {
            ((LinkTemplateImpl)linkTemplate).setConceptMetadata(this);
        }
    }

    public void addMedia(Media media) {
        if (this.getMedias().add(media)) {
            ((MediaImpl)media).setConceptMetadata(this);
        }
    }

    public Concept getConcept() {
        return this._persistence_get_concept();
    }

    public Collection<Artifact> getArtifacts() {
        if (this._persistence_get_artifacts() == null) {
            this._persistence_set_artifacts(new ArrayList());
        }
        return this._persistence_get_artifacts();
    }

    public Collection<History> getHistories() {
        if (this._persistence_get_histories() == null) {
            this._persistence_set_histories(new ArrayList());
        }
        return this._persistence_get_histories();
    }

    @Override
    public Long getId() {
        return this._persistence_get_id();
    }

    public Collection<LinkRealization> getLinkRealizations() {
        if (this._persistence_get_linkRealizations() == null) {
            this._persistence_set_linkRealizations(new ArrayList());
        }
        return this._persistence_get_linkRealizations();
    }

    public Collection<LinkTemplate> getLinkTemplates() {
        if (this._persistence_get_linkTemplates() == null) {
            this._persistence_set_linkTemplates(new ArrayList());
        }
        return this._persistence_get_linkTemplates();
    }

    public Collection<Media> getMedias() {
        if (this._persistence_get_medias() == null) {
            this._persistence_set_medias(new ArrayList());
        }
        return this._persistence_get_medias();
    }

    public Media getPrimaryImage() {
        Media media = null;
        ArrayList<Media> m = new ArrayList<Media>(this.getMedias());
        for (Media media1 : m) {
            if (!media1.isPrimary().booleanValue() || !media1.getType().equalsIgnoreCase(MediaTypes.IMAGE.toString())) continue;
            media = media1;
            break;
        }
        return media;
    }

    public Media getPrimaryMedia(MediaTypes mediaType) {
        Media primaryMedia = null;
        HashSet<Media> ms = new HashSet<Media>(this.getMedias());
        for (Media media : ms) {
            if (!media.isPrimary().booleanValue() || !media.getType().equals(mediaType.toString())) continue;
            primaryMedia = media;
        }
        return primaryMedia;
    }

    public Usage getUsage() {
        return this._persistence_get_usage();
    }

    public Object getPrimaryKey() {
        return this.getId();
    }

    public boolean hasPrimaryImage() {
        return this.getPrimaryImage() != null;
    }

    public boolean isPendingApproval() {
        boolean isPending = false;
        for (History history : this.getHistories()) {
            if (history.isApproved().booleanValue() || history.isRejected()) continue;
            isPending = true;
            break;
        }
        return isPending;
    }

    public void removeArtifact(Artifact artifact) {
        if (this.getArtifacts().remove(artifact)) {
            ((ArtifactImpl)artifact).setConceptMetadata(null);
        }
    }

    public void removeHistory(History history) {
        if (this.getHistories().remove(history)) {
            ((HistoryImpl)history).setConceptMetadata(null);
        }
    }

    public void removeLinkRealization(LinkRealization linkRealization) {
        if (this.getLinkRealizations().remove(linkRealization)) {
            ((LinkRealizationImpl)linkRealization).setConceptMetadata(null);
        }
    }

    public void removeLinkTemplate(LinkTemplate linkTemplate) {
        if (this.getLinkTemplates().remove(linkTemplate)) {
            ((LinkTemplateImpl)linkTemplate).setConceptMetadata(null);
        }
    }

    public void removeMedia(Media media) {
        if (this.getMedias().remove(media)) {
            ((MediaImpl)media).setConceptMetadata(null);
        }
    }

    protected void setConcept(Concept concept) {
        this._persistence_set_concept(concept);
    }

    public void setId(Long id) {
        this._persistence_set_id(id);
    }

    public void setUsage(Usage usage) {
        if (this._persistence_get_usage() != null) {
            UsageImpl thisUsage = (UsageImpl)this._persistence_get_usage();
            thisUsage.setConceptMetadata(null);
        }
        this._persistence_set_usage(usage);
        if (usage != null) {
            ((UsageImpl)usage).setConceptMetadata(this);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConceptMetadataImpl other = (ConceptMetadataImpl)obj;
        return this._persistence_get_id().equals(other._persistence_get_id()) || this._persistence_get_id() != null && this._persistence_get_id().equals(other._persistence_get_id());
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + (this._persistence_get_id() != null ? this._persistence_get_id().hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "ConceptMetadataImpl ([id=" + this._persistence_get_id() + "] updatedTime=" + this._persistence_get_updatedTime() + ")";
    }

    public Object _persistence_post_clone() {
        if (this._persistence_concept_vh != null) {
            this._persistence_concept_vh = (WeavedAttributeValueHolderInterface)this._persistence_concept_vh.clone();
        }
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ConceptMetadataImpl(persistenceObject);
    }

    public ConceptMetadataImpl(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "updatedTime") {
            return this.updatedTime;
        }
        if (string == "medias") {
            return this.medias;
        }
        if (string == "linkTemplates") {
            return this.linkTemplates;
        }
        if (string == "concept") {
            return this.concept;
        }
        if (string == "usage") {
            return this.usage;
        }
        if (string == "histories") {
            return this.histories;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "linkRealizations") {
            return this.linkRealizations;
        }
        if (string == "artifacts") {
            return this.artifacts;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "updatedTime") {
            this.updatedTime = (Timestamp)object;
            return;
        }
        if (string == "medias") {
            this.medias = (List)object;
            return;
        }
        if (string == "linkTemplates") {
            this.linkTemplates = (List)object;
            return;
        }
        if (string == "concept") {
            this.concept = (Concept)object;
            return;
        }
        if (string == "usage") {
            this.usage = (Usage)object;
            return;
        }
        if (string == "histories") {
            this.histories = (List)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "linkRealizations") {
            this.linkRealizations = (List)object;
            return;
        }
        if (string == "artifacts") {
            this.artifacts = (List)object;
            return;
        }
    }

    public Timestamp _persistence_get_updatedTime() {
        this._persistence_checkFetched("updatedTime");
        return this.updatedTime;
    }

    public void _persistence_set_updatedTime(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("updatedTime");
        this.updatedTime = timestamp;
    }

    public List _persistence_get_medias() {
        this._persistence_checkFetched("medias");
        return this.medias;
    }

    public void _persistence_set_medias(List list) {
        this._persistence_checkFetchedForSet("medias");
        this.medias = list;
    }

    public List _persistence_get_linkTemplates() {
        this._persistence_checkFetched("linkTemplates");
        return this.linkTemplates;
    }

    public void _persistence_set_linkTemplates(List list) {
        this._persistence_checkFetchedForSet("linkTemplates");
        this.linkTemplates = list;
    }

    protected void _persistence_initialize_concept_vh() {
        if (this._persistence_concept_vh == null) {
            this._persistence_concept_vh = new ValueHolder((Object)this.concept);
            this._persistence_concept_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_concept_vh() {
        Concept concept;
        this._persistence_initialize_concept_vh();
        if ((this._persistence_concept_vh.isCoordinatedWithProperty() || this._persistence_concept_vh.isNewlyWeavedValueHolder()) && (concept = this._persistence_get_concept()) != this._persistence_concept_vh.getValue()) {
            this._persistence_set_concept(concept);
        }
        return this._persistence_concept_vh;
    }

    public void _persistence_set_concept_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_concept_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Concept concept = this._persistence_get_concept();
            if (concept != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_concept((Concept)object);
            }
        } else {
            this.concept = null;
        }
    }

    public Concept _persistence_get_concept() {
        this._persistence_checkFetched("concept");
        this._persistence_initialize_concept_vh();
        this.concept = (Concept)this._persistence_concept_vh.getValue();
        return this.concept;
    }

    public void _persistence_set_concept(Concept concept) {
        this._persistence_checkFetchedForSet("concept");
        this._persistence_initialize_concept_vh();
        this.concept = (Concept)this._persistence_concept_vh.getValue();
        this.concept = concept;
        this._persistence_concept_vh.setValue((Object)concept);
    }

    public Usage _persistence_get_usage() {
        this._persistence_checkFetched("usage");
        return this.usage;
    }

    public void _persistence_set_usage(Usage usage) {
        this._persistence_checkFetchedForSet("usage");
        this.usage = usage;
    }

    public List _persistence_get_histories() {
        this._persistence_checkFetched("histories");
        return this.histories;
    }

    public void _persistence_set_histories(List list) {
        this._persistence_checkFetchedForSet("histories");
        this.histories = list;
    }

    public Long _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(Long l) {
        this._persistence_checkFetchedForSet("id");
        this.id = l;
    }

    public List _persistence_get_linkRealizations() {
        this._persistence_checkFetched("linkRealizations");
        return this.linkRealizations;
    }

    public void _persistence_set_linkRealizations(List list) {
        this._persistence_checkFetchedForSet("linkRealizations");
        this.linkRealizations = list;
    }

    public List _persistence_get_artifacts() {
        this._persistence_checkFetched("artifacts");
        return this.artifacts;
    }

    public void _persistence_set_artifacts(List list) {
        this._persistence_checkFetchedForSet("artifacts");
        this.artifacts = list;
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

