/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.jpa;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.WeavedAttributeValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedLazy;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import vars.jpa.JPAEntity;
import vars.jpa.KeyNullifier;
import vars.jpa.TransactionLogger;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptMetadata;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.ConceptNameTypes;
import vars.knowledgebase.jpa.ConceptMetadataImpl;
import vars.knowledgebase.jpa.ConceptNameImpl;

@Entity(name="Concept")
@Table(name="Concept", indexes={@Index(name="idx_Concept_FK1", columnList="ParentConceptID_FK"), @Index(name="idx_Concept_LUT", columnList="LAST_UPDATED_TIME")})
@EntityListeners(value={TransactionLogger.class, KeyNullifier.class})
@NamedQueries(value={@NamedQuery(name="Concept.findById", query="SELECT v FROM Concept v WHERE v.id = :id"), @NamedQuery(name="Concept.findByOriginator", query="SELECT c FROM Concept c WHERE c.originator = :originator"), @NamedQuery(name="Concept.findByStructureType", query="SELECT c FROM Concept c WHERE c.structureType = :structureType"), @NamedQuery(name="Concept.findByReference", query="SELECT c FROM Concept c WHERE c.reference = :reference"), @NamedQuery(name="Concept.findByNodcCode", query="SELECT c FROM Concept c WHERE c.nodcCode = :nodcCode"), @NamedQuery(name="Concept.findByRankName", query="SELECT c FROM Concept c WHERE c.rankName = :rankName"), @NamedQuery(name="Concept.findByRankLevel", query="SELECT c FROM Concept c WHERE c.rankLevel = :rankLevel"), @NamedQuery(name="Concept.findByTaxonomyType", query="SELECT c FROM Concept c WHERE c.taxonomyType = :taxonomyType"), @NamedQuery(name="Concept.findRoot", query="SELECT c FROM Concept c WHERE c.parentConcept IS NULL"), @NamedQuery(name="Concept.findAll", query="SELECT c FROM Concept c"), @NamedQuery(name="Concept.findByName", query="SELECT c FROM Concept c, IN (c.conceptNames) AS n WHERE n.name = :name"), @NamedQuery(name="Concept.findAllByNameGlob", query="SELECT DISTINCT c FROM Concept c, IN (c.conceptNames) AS n WHERE lower(n.name) LIKE :name ORDER BY n.name"), @NamedQuery(name="Concept.eagerFindById", query="SELECT c FROM Concept c JOIN FETCH c.conceptMetadata m WHERE c.id = :id")})
public class ConceptImpl
implements Serializable,
Concept,
JPAEntity,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedLazy,
PersistenceWeavedRest {
    @OneToMany(targetEntity=ConceptImpl.class, mappedBy="parentConcept", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private List<ConceptImpl> childConcepts;
    @OneToOne(mappedBy="concept", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, targetEntity=ConceptMetadataImpl.class)
    private ConceptMetadataImpl conceptMetadata;
    @OneToMany(targetEntity=ConceptNameImpl.class, mappedBy="concept", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private Set<ConceptNameImpl> conceptNames;
    @Id
    @Column(name="id", nullable=false, updatable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="Concept_Gen")
    @TableGenerator(name="Concept_Gen", table="UniqueID", pkColumnName="TableName", valueColumnName="NextID", pkColumnValue="Concept", allocationSize=1)
    private Long id;
    @Column(name="NodcCode", length=20)
    private String nodcCode;
    @Column(name="Originator", length=255)
    private String originator;
    @ManyToOne(fetch=FetchType.LAZY, optional=true, targetEntity=ConceptImpl.class)
    @JoinColumn(name="ParentConceptID_FK")
    private Concept parentConcept;
    @Column(name="RankLevel", length=20)
    private String rankLevel;
    @Column(name="RankName", length=20)
    private String rankName;
    @Column(name="Reference", length=1024)
    private String reference;
    @Column(name="StructureType", length=10)
    private String structureType;
    @Column(name="TaxonomyType", length=20)
    private String taxonomyType;
    @Version
    @Column(name="LAST_UPDATED_TIME")
    private Timestamp updatedTime;
    static final long serialVersionUID = 7024885254460318807L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_parentConcept_vh;
    @Transient
    @XmlTransient
    protected WeavedAttributeValueHolderInterface _persistence_conceptMetadata_vh;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public ConceptImpl() {
    }

    public void addChildConcept(Concept child) {
        ConceptImpl ci = (ConceptImpl)child;
        if (this.getChildConcepts().add(child)) {
            ci.setParentConcept(this);
        }
    }

    public void addConceptName(ConceptName conceptName) {
        if (conceptName.getNameType().equalsIgnoreCase(ConceptNameTypes.PRIMARY.toString()) && this.getPrimaryConceptName() != null) {
            throw new IllegalArgumentException("Can't add a second primay conceptname to a concept");
        }
        ArrayList<ConceptName> names = new ArrayList<ConceptName>(this.getConceptNames());
        for (ConceptName cn : names) {
            if (!cn.getName().equals(conceptName.getName())) continue;
            throw new IllegalArgumentException("A ConceptName with the name '${conceptName.name}' already exists in " + this);
        }
        this.getConceptNames().add(conceptName);
        conceptName.setConcept((Concept)this);
    }

    public List<Concept> getChildConcepts() {
        if (this._persistence_get_childConcepts() == null) {
            this._persistence_set_childConcepts(new ArrayList());
        }
        return this._persistence_get_childConcepts();
    }

    public ConceptMetadata getConceptMetadata() {
        if (this._persistence_get_conceptMetadata() == null) {
            this._persistence_set_conceptMetadata(new ConceptMetadataImpl());
            this._persistence_get_conceptMetadata().setConcept(this);
        }
        return this._persistence_get_conceptMetadata();
    }

    public void setConceptMetadata(ConceptMetadata conceptMetadata) {
        ((ConceptMetadataImpl)this.getConceptMetadata()).setConcept(null);
        this._persistence_set_conceptMetadata((ConceptMetadataImpl)conceptMetadata);
        ((ConceptMetadataImpl)conceptMetadata).setConcept(this);
    }

    public ConceptName getConceptName(String name) {
        ConceptName conceptName = null;
        ArrayList<ConceptName> names = new ArrayList<ConceptName>(this.getConceptNames());
        for (ConceptName cn : names) {
            if (!cn.getName().equals(name)) continue;
            conceptName = cn;
            break;
        }
        return conceptName;
    }

    public Set<ConceptName> getConceptNames() {
        if (this._persistence_get_conceptNames() == null) {
            this._persistence_set_conceptNames(new HashSet());
        }
        return this._persistence_get_conceptNames();
    }

    @Override
    public Long getId() {
        return this._persistence_get_id();
    }

    public String getNodcCode() {
        return this._persistence_get_nodcCode();
    }

    public String getOriginator() {
        return this._persistence_get_originator();
    }

    public Concept getParentConcept() {
        return this._persistence_get_parentConcept();
    }

    public ConceptName getPrimaryConceptName() {
        ConceptName conceptName = null;
        ArrayList<ConceptName> names = new ArrayList<ConceptName>(this.getConceptNames());
        for (ConceptName cn : names) {
            if (!cn.getNameType().equalsIgnoreCase(ConceptNameTypes.PRIMARY.toString())) continue;
            conceptName = cn;
            break;
        }
        return conceptName;
    }

    public String getRankLevel() {
        return this._persistence_get_rankLevel();
    }

    public String getRankName() {
        return this._persistence_get_rankName();
    }

    public String getReference() {
        return this._persistence_get_reference();
    }

    public Concept getRootConcept() {
        ConceptImpl concept = this;
        while (concept.getParentConcept() != null) {
            concept = concept.getParentConcept();
        }
        return concept;
    }

    public String getStructureType() {
        return this._persistence_get_structureType();
    }

    public boolean hasChildConcepts() {
        return this.getChildConcepts().size() > 0;
    }

    public boolean hasDescendent(String child) {
        return this.hasDescendent(child, this);
    }

    private boolean hasDescendent(String childName, Concept concept) {
        Concept child;
        boolean match = false;
        ArrayList children = new ArrayList(concept.getChildConcepts());
        Iterator iterator = children.iterator();
        while (iterator.hasNext() && !(match = (child = (Concept)iterator.next()).getConceptName(childName) != null)) {
        }
        iterator = children.iterator();
        while (iterator.hasNext() && !(match = this.hasDescendent(childName, child = (Concept)iterator.next()))) {
        }
        return match;
    }

    public boolean hasDetails() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean hasParent() {
        return this._persistence_get_parentConcept() != null;
    }

    public void loadLazyRelations() {
        for (Concept concept : this._persistence_get_childConcepts()) {
            concept.getConceptNames();
        }
    }

    public void removeChildConcept(Concept childConcept) {
        ConceptImpl ci = (ConceptImpl)childConcept;
        if (this.getChildConcepts().remove(childConcept)) {
            ci.setParentConcept(null);
        }
    }

    public void removeConceptName(ConceptName conceptName) {
        if (this.getConceptNames().remove(conceptName)) {
            conceptName.setConcept(null);
        }
    }

    public void setId(Long id) {
        this._persistence_set_id(id);
    }

    public void setNodcCode(String nodcCode) {
        this._persistence_set_nodcCode(nodcCode);
    }

    public void setOriginator(String originator) {
        this._persistence_set_originator(originator);
    }

    private void setParentConcept(ConceptImpl parentConcept) {
        this._persistence_set_parentConcept(parentConcept);
    }

    public void setRankLevel(String rankLevel) {
        this._persistence_set_rankLevel(rankLevel);
    }

    public void setRankName(String rankName) {
        this._persistence_set_rankName(rankName);
    }

    public void setReference(String reference) {
        this._persistence_set_reference(reference);
    }

    public void setStructureType(String structureType) {
        this._persistence_set_structureType(structureType);
    }

    public Object getPrimaryKey() {
        return this.getId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " ([id=" + this._persistence_get_id() + "])";
    }

    public void setTaxonomyType(String taxonomyType) {
        this._persistence_set_taxonomyType(taxonomyType);
    }

    public String getTaxonomyType() {
        return this._persistence_get_taxonomyType();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Concept other = (Concept)obj;
        return this.hashCode() == other.hashCode();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Object _persistence_post_clone() {
        if (this._persistence_parentConcept_vh != null) {
            this._persistence_parentConcept_vh = (WeavedAttributeValueHolderInterface)this._persistence_parentConcept_vh.clone();
        }
        if (this._persistence_conceptMetadata_vh != null) {
            this._persistence_conceptMetadata_vh = (WeavedAttributeValueHolderInterface)this._persistence_conceptMetadata_vh.clone();
        }
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ConceptImpl(persistenceObject);
    }

    public ConceptImpl(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "nodcCode") {
            return this.nodcCode;
        }
        if (string == "updatedTime") {
            return this.updatedTime;
        }
        if (string == "originator") {
            return this.originator;
        }
        if (string == "taxonomyType") {
            return this.taxonomyType;
        }
        if (string == "reference") {
            return this.reference;
        }
        if (string == "childConcepts") {
            return this.childConcepts;
        }
        if (string == "parentConcept") {
            return this.parentConcept;
        }
        if (string == "rankLevel") {
            return this.rankLevel;
        }
        if (string == "structureType") {
            return this.structureType;
        }
        if (string == "rankName") {
            return this.rankName;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "conceptMetadata") {
            return this.conceptMetadata;
        }
        if (string == "conceptNames") {
            return this.conceptNames;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "nodcCode") {
            this.nodcCode = (String)object;
            return;
        }
        if (string == "updatedTime") {
            this.updatedTime = (Timestamp)object;
            return;
        }
        if (string == "originator") {
            this.originator = (String)object;
            return;
        }
        if (string == "taxonomyType") {
            this.taxonomyType = (String)object;
            return;
        }
        if (string == "reference") {
            this.reference = (String)object;
            return;
        }
        if (string == "childConcepts") {
            this.childConcepts = (List)object;
            return;
        }
        if (string == "parentConcept") {
            this.parentConcept = (Concept)object;
            return;
        }
        if (string == "rankLevel") {
            this.rankLevel = (String)object;
            return;
        }
        if (string == "structureType") {
            this.structureType = (String)object;
            return;
        }
        if (string == "rankName") {
            this.rankName = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "conceptMetadata") {
            this.conceptMetadata = (ConceptMetadataImpl)object;
            return;
        }
        if (string == "conceptNames") {
            this.conceptNames = (Set)object;
            return;
        }
    }

    public String _persistence_get_nodcCode() {
        this._persistence_checkFetched("nodcCode");
        return this.nodcCode;
    }

    public void _persistence_set_nodcCode(String string) {
        this._persistence_checkFetchedForSet("nodcCode");
        this.nodcCode = string;
    }

    public Timestamp _persistence_get_updatedTime() {
        this._persistence_checkFetched("updatedTime");
        return this.updatedTime;
    }

    public void _persistence_set_updatedTime(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("updatedTime");
        this.updatedTime = timestamp;
    }

    public String _persistence_get_originator() {
        this._persistence_checkFetched("originator");
        return this.originator;
    }

    public void _persistence_set_originator(String string) {
        this._persistence_checkFetchedForSet("originator");
        this.originator = string;
    }

    public String _persistence_get_taxonomyType() {
        this._persistence_checkFetched("taxonomyType");
        return this.taxonomyType;
    }

    public void _persistence_set_taxonomyType(String string) {
        this._persistence_checkFetchedForSet("taxonomyType");
        this.taxonomyType = string;
    }

    public String _persistence_get_reference() {
        this._persistence_checkFetched("reference");
        return this.reference;
    }

    public void _persistence_set_reference(String string) {
        this._persistence_checkFetchedForSet("reference");
        this.reference = string;
    }

    public List _persistence_get_childConcepts() {
        this._persistence_checkFetched("childConcepts");
        return this.childConcepts;
    }

    public void _persistence_set_childConcepts(List list) {
        this._persistence_checkFetchedForSet("childConcepts");
        this.childConcepts = list;
    }

    protected void _persistence_initialize_parentConcept_vh() {
        if (this._persistence_parentConcept_vh == null) {
            this._persistence_parentConcept_vh = new ValueHolder((Object)this.parentConcept);
            this._persistence_parentConcept_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_parentConcept_vh() {
        Concept concept;
        this._persistence_initialize_parentConcept_vh();
        if ((this._persistence_parentConcept_vh.isCoordinatedWithProperty() || this._persistence_parentConcept_vh.isNewlyWeavedValueHolder()) && (concept = this._persistence_get_parentConcept()) != this._persistence_parentConcept_vh.getValue()) {
            this._persistence_set_parentConcept(concept);
        }
        return this._persistence_parentConcept_vh;
    }

    public void _persistence_set_parentConcept_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_parentConcept_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            Concept concept = this._persistence_get_parentConcept();
            if (concept != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_parentConcept((Concept)object);
            }
        } else {
            this.parentConcept = null;
        }
    }

    public Concept _persistence_get_parentConcept() {
        this._persistence_checkFetched("parentConcept");
        this._persistence_initialize_parentConcept_vh();
        this.parentConcept = (Concept)this._persistence_parentConcept_vh.getValue();
        return this.parentConcept;
    }

    public void _persistence_set_parentConcept(Concept concept) {
        this._persistence_checkFetchedForSet("parentConcept");
        this._persistence_initialize_parentConcept_vh();
        this.parentConcept = (Concept)this._persistence_parentConcept_vh.getValue();
        this.parentConcept = concept;
        this._persistence_parentConcept_vh.setValue((Object)concept);
    }

    public String _persistence_get_rankLevel() {
        this._persistence_checkFetched("rankLevel");
        return this.rankLevel;
    }

    public void _persistence_set_rankLevel(String string) {
        this._persistence_checkFetchedForSet("rankLevel");
        this.rankLevel = string;
    }

    public String _persistence_get_structureType() {
        this._persistence_checkFetched("structureType");
        return this.structureType;
    }

    public void _persistence_set_structureType(String string) {
        this._persistence_checkFetchedForSet("structureType");
        this.structureType = string;
    }

    public String _persistence_get_rankName() {
        this._persistence_checkFetched("rankName");
        return this.rankName;
    }

    public void _persistence_set_rankName(String string) {
        this._persistence_checkFetchedForSet("rankName");
        this.rankName = string;
    }

    public Long _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(Long l) {
        this._persistence_checkFetchedForSet("id");
        this.id = l;
    }

    protected void _persistence_initialize_conceptMetadata_vh() {
        if (this._persistence_conceptMetadata_vh == null) {
            this._persistence_conceptMetadata_vh = new ValueHolder((Object)this.conceptMetadata);
            this._persistence_conceptMetadata_vh.setIsNewlyWeavedValueHolder(true);
        }
    }

    public WeavedAttributeValueHolderInterface _persistence_get_conceptMetadata_vh() {
        ConceptMetadataImpl conceptMetadataImpl;
        this._persistence_initialize_conceptMetadata_vh();
        if ((this._persistence_conceptMetadata_vh.isCoordinatedWithProperty() || this._persistence_conceptMetadata_vh.isNewlyWeavedValueHolder()) && (conceptMetadataImpl = this._persistence_get_conceptMetadata()) != this._persistence_conceptMetadata_vh.getValue()) {
            this._persistence_set_conceptMetadata(conceptMetadataImpl);
        }
        return this._persistence_conceptMetadata_vh;
    }

    public void _persistence_set_conceptMetadata_vh(WeavedAttributeValueHolderInterface weavedAttributeValueHolderInterface) {
        this._persistence_conceptMetadata_vh = weavedAttributeValueHolderInterface;
        if (weavedAttributeValueHolderInterface.isInstantiated()) {
            Object object;
            ConceptMetadataImpl conceptMetadataImpl = this._persistence_get_conceptMetadata();
            if (conceptMetadataImpl != (object = weavedAttributeValueHolderInterface.getValue())) {
                this._persistence_set_conceptMetadata((ConceptMetadataImpl)object);
            }
        } else {
            this.conceptMetadata = null;
        }
    }

    public ConceptMetadataImpl _persistence_get_conceptMetadata() {
        this._persistence_checkFetched("conceptMetadata");
        this._persistence_initialize_conceptMetadata_vh();
        this.conceptMetadata = (ConceptMetadataImpl)this._persistence_conceptMetadata_vh.getValue();
        return this.conceptMetadata;
    }

    public void _persistence_set_conceptMetadata(ConceptMetadataImpl conceptMetadataImpl) {
        this._persistence_checkFetchedForSet("conceptMetadata");
        this._persistence_initialize_conceptMetadata_vh();
        this.conceptMetadata = (ConceptMetadataImpl)this._persistence_conceptMetadata_vh.getValue();
        this.conceptMetadata = conceptMetadataImpl;
        this._persistence_conceptMetadata_vh.setValue((Object)conceptMetadataImpl);
    }

    public Set _persistence_get_conceptNames() {
        this._persistence_checkFetched("conceptNames");
        return this.conceptNames;
    }

    public void _persistence_set_conceptNames(Set set) {
        this._persistence_checkFetchedForSet("conceptNames");
        this.conceptNames = set;
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

