/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase.jpa;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import vars.VARSPersistenceException;
import vars.jpa.DAO;
import vars.jpa.JPAEntity;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.jpa.ConceptImpl;

public class ConceptDAOImpl
extends DAO
implements ConceptDAO {
    @Inject
    public ConceptDAOImpl(EntityManager entityManager) {
        super(entityManager);
    }

    public Concept findRoot() {
        Concept root = null;
        List roots = this.findByNamedQuery("Concept.findRoot", new HashMap<String, Object>());
        if (roots.size() == 1) {
            root = (Concept)roots.get(0);
        } else {
            if (roots.size() > 1) {
                throw new VARSPersistenceException("ERROR!! More than one root was found in the knowedgebase");
            }
            if (roots.size() == 0) {
                this.log.warn("No root was found in the knowledgebase");
            }
        }
        return root;
    }

    public Concept findByName(final String name) {
        List concepts = this.findByNamedQuery("Concept.findByName", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("name", name);
            }
        });
        return concepts.size() == 0 ? null : (Concept)concepts.get(0);
    }

    public List<Concept> findAllByNameContaining(String nameGlob) {
        final String name = "%" + nameGlob + "%";
        return this.findByNamedQuery("Concept.findAllByNameGlob", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("name", name.toLowerCase());
            }
        });
    }

    public List<Concept> findAllByNameStartingWith(String nameGlob) {
        final String name = nameGlob + "%";
        return this.findByNamedQuery("Concept.findAllByNameGlob", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("name", name.toLowerCase());
            }
        });
    }

    public List<Concept> findAllByNameEndingWith(String nameGlob) {
        final String name = '%' + nameGlob;
        return this.findByNamedQuery("Concept.findAllByNameGlob", (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("name", name.toLowerCase());
            }
        });
    }

    public Collection<ConceptName> findDescendentNames(Concept concept) {
        ArrayList<ConceptName> conceptNames = new ArrayList<ConceptName>();
        Concept mergedConcept = concept instanceof JPAEntity ? (Concept)this.findByPrimaryKey(ConceptImpl.class, ((JPAEntity)concept).getId()) : this.findByName(concept.getPrimaryConceptName().getName());
        if (mergedConcept != null) {
            conceptNames.addAll(mergedConcept.getConceptNames());
            this.findDescendentNames(mergedConcept.getChildConcepts(), conceptNames);
        }
        return conceptNames;
    }

    private void findDescendentNames(Collection<Concept> concepts, Collection<ConceptName> conceptNames) {
        for (Concept concept : concepts) {
            conceptNames.addAll(concept.getConceptNames());
            this.findDescendentNames(concept.getChildConcepts(), conceptNames);
        }
    }

    public Collection<Concept> findAll() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.findByNamedQuery("Concept.findAll", params);
    }

    public Collection<Concept> findDescendents(Concept concept) {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        this.findDescendents(concept, concepts);
        return concepts;
    }

    private void findDescendents(Concept concept, Collection<Concept> concepts) {
        concepts.add(concept);
        for (Concept child : concept.getChildConcepts()) {
            this.findDescendents(child, concepts);
        }
    }

    public void cascadeRemove(Concept concept) {
        if (((JPAEntity)concept).getId() == null) {
            this.log.info("Attempted to cascade delete a non-mnaged entity");
            return;
        }
        this.startTransaction();
        concept = this.find(concept);
        LinkedList<Concept> queue = new LinkedList<Concept>(this.findDescendents(concept));
        this.endTransaction();
        while (queue.size() > 0) {
            Concept c = (Concept)queue.poll();
            if (c.getChildConcepts().size() == 0) {
                this.startTransaction();
                c = this.find(c);
                Concept parent = c.getParentConcept();
                if (parent != null) {
                    parent.removeChildConcept(c);
                }
                this.remove(c);
                this.endTransaction();
                continue;
            }
            queue.offer(c);
        }
    }
}

