/*
 * Decompiled with CFR 0.152.
 */
package vars.knowledgebase;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import org.mbari.sql.QueryFunction;
import org.mbari.sql.QueryableImpl;
import vars.VARSException;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.KnowledgebasePersistenceService;

public class KnowledgebasePersistenceServiceImpl
extends QueryableImpl
implements KnowledgebasePersistenceService {
    private static final String jdbcPassword;
    private static final String jdbcUrl;
    private static final String jdbcUsername;
    private static final String jdbcDriver;

    public KnowledgebasePersistenceServiceImpl() {
        super(jdbcUrl, jdbcUsername, jdbcPassword, jdbcDriver);
    }

    public void updateConceptNameUsedByLinkTemplates(Concept concept) {
        String primaryName = concept.getPrimaryConceptName().getName();
        ArrayList conceptNames = new ArrayList(concept.getConceptNames());
        conceptNames.remove(concept.getPrimaryConceptName());
        String sql = "UPDATE LinkTemplate SET ToConcept = ? WHERE ToConcept = ?";
        try {
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            for (ConceptName conceptName : conceptNames) {
                preparedStatement.setString(1, primaryName);
                preparedStatement.setString(2, conceptName.getName());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            preparedStatement.close();
        }
        catch (Exception e) {
            throw new VARSException("Failed to update LinkTemplates", (Throwable)e);
        }
    }

    public boolean doesConceptNameExist(String conceptname) {
        String sql = "SELECT count(*) FROM ConceptName WHERE ConceptName = ?";
        QueryFunction<Boolean> queryFunction = new QueryFunction<Boolean>(){

            public Boolean apply(ResultSet resultSet) throws SQLException {
                Integer n = 0;
                while (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
                return new Boolean(n > 0);
            }
        };
        try {
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement = connection.prepareStatement(sql);
            preparedStatement.setString(1, conceptname);
            boolean exists = (Boolean)queryFunction.apply(preparedStatement.executeQuery());
            preparedStatement.close();
            return exists;
        }
        catch (Exception e) {
            throw new VARSException("Failed to execute " + sql, (Throwable)e);
        }
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle("knowledgebase-jdbc", Locale.US);
        jdbcUrl = bundle.getString("jdbc.url");
        jdbcUsername = bundle.getString("jdbc.username");
        jdbcPassword = bundle.getString("jdbc.password");
        jdbcDriver = bundle.getString("jdbc.driver");
    }
}

