/*
 * Decompiled with CFR 0.152.
 */
package vars.jpa;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.jpa.PreferenceNode;

public class VarsUserPreferences
extends AbstractPreferences {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EntityManagerFactory entityManagerFactory;

    @Inject
    public VarsUserPreferences(@Named(value="miscPersistenceUnit") String persistenceUnit) {
        this(Persistence.createEntityManagerFactory((String)persistenceUnit), null, "");
    }

    public VarsUserPreferences(EntityManagerFactory entityManagerFactory, VarsUserPreferences parent, String name) {
        super(parent, name);
        this.entityManagerFactory = entityManagerFactory;
    }

    @Override
    protected void putSpi(String key, String value) {
        try {
            PreferenceNode node = this.findByKey(key);
            if (node == null) {
                node = new PreferenceNode();
                node.setNodeName(this.absolutePath());
                node.setPrefKey(key);
                node.setPrefValue(value);
                this.insert(node);
            } else if (!value.equals(node.getPrefValue())) {
                node.setPrefValue(value);
                this.update(node);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to on call of putSpi(" + key + ", " + value + ")", (Throwable)e);
        }
    }

    private void insert(PreferenceNode node) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction entityTransaction = entityManager.getTransaction();
        entityTransaction.begin();
        entityManager.persist((Object)node);
        entityTransaction.commit();
        entityManager.close();
    }

    private void update(PreferenceNode node) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction entityTransaction = entityManager.getTransaction();
        entityTransaction.begin();
        entityManager.merge((Object)node);
        entityTransaction.commit();
        entityManager.close();
    }

    private void delete(PreferenceNode node) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        EntityTransaction entityTransaction = entityManager.getTransaction();
        entityTransaction.begin();
        node = (PreferenceNode)entityManager.merge((Object)node);
        entityManager.remove((Object)node);
        entityTransaction.commit();
        entityManager.close();
    }

    public List findByNamedQuery(String name, Map<String, Object> namedParameters) {
        if (this.log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Executing FIND using named query '");
            sb.append(name).append("'");
            if (namedParameters.size() > 0) {
                sb.append(" with parameters:\n");
                for (String string : namedParameters.keySet()) {
                    sb.append("\t").append(string).append(" = ").append(namedParameters.get(string));
                }
            }
            this.log.debug(sb.toString());
        }
        List resultList = null;
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        Query query = entityManager.createNamedQuery(name);
        for (String key : namedParameters.keySet()) {
            query.setParameter(key, namedParameters.get(key));
        }
        resultList = query.getResultList();
        return resultList;
    }

    @Override
    protected String getSpi(String key) {
        String prefValue = null;
        try {
            PreferenceNode node = this.findByKey(key);
            if (node != null) {
                prefValue = node.getPrefValue();
            }
        }
        catch (Exception e) {
            this.log.error("Call of getSpi(" + key + ") failed", (Throwable)e);
        }
        return prefValue;
    }

    @Override
    protected void removeSpi(String key) {
        try {
            PreferenceNode node = this.findByKey(key);
            this.delete(node);
        }
        catch (Exception e) {
            this.log.error("Failed to retrieve keys for " + this.absolutePath(), (Throwable)e);
        }
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        try {
            List<PreferenceNode> preferenceNodes = this.findByNodeNameLike(this.absolutePath());
            for (PreferenceNode node : preferenceNodes) {
                this.delete(node);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to retrieve keys for " + this.absolutePath(), (Throwable)e);
            throw new BackingStoreException(e);
        }
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        ArrayList<String> keys = new ArrayList<String>();
        try {
            List<PreferenceNode> preferenceNodes = this.findByNodeName(this.absolutePath());
            for (PreferenceNode node : preferenceNodes) {
                keys.add(node.getPrefKey());
            }
        }
        catch (Exception e) {
            this.log.error("Failed to retrieve keys for " + this.absolutePath(), (Throwable)e);
            throw new BackingStoreException(e);
        }
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        ArrayList<String> keys = new ArrayList<String>();
        String parentNode = this.absolutePath();
        try {
            List<PreferenceNode> preferenceNodes = this.findByNodeNameLike(parentNode);
            for (PreferenceNode node : preferenceNodes) {
                String nodeName = node.getNodeName();
                String childPath = nodeName.substring(parentNode.length(), nodeName.length());
                if (childPath.startsWith("/")) {
                    childPath = childPath.substring(1, childPath.length());
                }
                String bareName = null;
                bareName = childPath.indexOf("/") >= 0 ? childPath.substring(0, childPath.indexOf("/")) : childPath;
                if (keys.contains(bareName) || bareName.compareTo("") == 0) continue;
                keys.add(bareName);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to retrieve keys for " + this.absolutePath(), (Throwable)e);
            throw new BackingStoreException(e);
        }
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        return new VarsUserPreferences(this.entityManagerFactory, this, name);
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    public static void copyPrefs(Preferences source, Preferences destination) {
        try {
            String[] prefKeys = source.keys();
            for (int i = 0; i < prefKeys.length; ++i) {
                destination.put(prefKeys[i], source.get(prefKeys[i], ""));
            }
            String[] childrenNames = source.childrenNames();
            for (int i = 0; i < childrenNames.length; ++i) {
                VarsUserPreferences.copyPrefs(source.node(childrenNames[i]), destination.node(childrenNames[i]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private PreferenceNode findByKey(String key) {
        PreferenceNode node = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("nodeName", this.absolutePath());
        params.put("prefKey", key);
        List preferenceNodes = this.findByNamedQuery("PreferenceNode.findByNodeNameAndPrefKey", params);
        if (preferenceNodes.size() > 0) {
            node = (PreferenceNode)preferenceNodes.get(0);
        }
        return node;
    }

    private List<PreferenceNode> findByNodeName(String nodeName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("nodeName", nodeName);
        return this.findByNamedQuery("PreferenceNode.findAllByNodeName", params);
    }

    private List<PreferenceNode> findByNodeNameLike(String nodeName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("nodeName", nodeName + "%");
        return this.findByNamedQuery("PreferenceNode.findAllLikeNodeName", params);
    }
}

