/*
 * Decompiled with CFR 0.152.
 */
package vars.jpa;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.prefs.PreferencesFactory;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.EXPDPersistenceService;
import vars.ExternalDataPersistenceService;
import vars.MiscDAOFactory;
import vars.MiscFactory;
import vars.PersistenceCacheProvider;
import vars.VarsUserPreferencesFactory;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.AnnotationFactory;
import vars.annotation.AnnotationPersistenceService;
import vars.annotation.AnnotationPersistenceServiceImpl;
import vars.annotation.jpa.AnnotationDAOFactoryImpl;
import vars.annotation.jpa.AnnotationFactoryImpl;
import vars.jpa.JPACacheProvider;
import vars.jpa.MiscDAOFactoryImpl;
import vars.jpa.MiscFactoryImpl;
import vars.jpa.VarsUserPreferencesFactoryImpl;
import vars.knowledgebase.KnowledgebaseDAOFactory;
import vars.knowledgebase.KnowledgebaseFactory;
import vars.knowledgebase.KnowledgebasePersistenceService;
import vars.knowledgebase.KnowledgebasePersistenceServiceImpl;
import vars.knowledgebase.jpa.KnowledgebaseDAOFactoryImpl;
import vars.knowledgebase.jpa.KnowledgebaseFactoryImpl;
import vars.query.QueryPersistenceService;
import vars.query.QueryPersistenceServiceImpl;

public class VarsJpaModule
implements Module {
    private final String annotationPersistenceUnit;
    private final String knowledgebasePersistenceUnit;
    private final String miscPersistenceUnit;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public VarsJpaModule(String annotationPersistenceUnit, String knowledgebasePersistenceUnit, String miscPersistenceUnit) {
        this.annotationPersistenceUnit = annotationPersistenceUnit;
        this.knowledgebasePersistenceUnit = knowledgebasePersistenceUnit;
        this.miscPersistenceUnit = miscPersistenceUnit;
    }

    public void configure(Binder binder) {
        SimpleDateFormat dateFormatISO = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"){
            {
                this.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
        };
        binder.bind(DateFormat.class).toInstance((Object)dateFormatISO);
        binder.bind(EntityManagerFactory.class).annotatedWith((Annotation)Names.named((String)"annotationPersistenceUnit")).toInstance((Object)Persistence.createEntityManagerFactory((String)this.annotationPersistenceUnit));
        binder.bind(EntityManagerFactory.class).annotatedWith((Annotation)Names.named((String)"knowledgebasePersistenceUnit")).toInstance((Object)Persistence.createEntityManagerFactory((String)this.knowledgebasePersistenceUnit));
        binder.bind(EntityManagerFactory.class).annotatedWith((Annotation)Names.named((String)"miscPersistenceUnit")).toInstance((Object)Persistence.createEntityManagerFactory((String)this.miscPersistenceUnit));
        binder.bind(AnnotationDAOFactory.class).to(AnnotationDAOFactoryImpl.class).in(Scopes.SINGLETON);
        binder.bind(AnnotationFactory.class).to(AnnotationFactoryImpl.class);
        binder.bind(AnnotationPersistenceService.class).to(AnnotationPersistenceServiceImpl.class).in(Scopes.SINGLETON);
        binder.bind(ExternalDataPersistenceService.class).to(EXPDPersistenceService.class);
        binder.bind(KnowledgebaseDAOFactory.class).to(KnowledgebaseDAOFactoryImpl.class).in(Scopes.SINGLETON);
        binder.bind(KnowledgebaseFactory.class).to(KnowledgebaseFactoryImpl.class);
        binder.bind(KnowledgebasePersistenceService.class).to(KnowledgebasePersistenceServiceImpl.class);
        binder.bind(MiscDAOFactory.class).to(MiscDAOFactoryImpl.class).in(Scopes.SINGLETON);
        binder.bind(MiscFactory.class).to(MiscFactoryImpl.class);
        binder.bind(PersistenceCacheProvider.class).to(JPACacheProvider.class);
        binder.bind(QueryPersistenceService.class).to(QueryPersistenceServiceImpl.class);
        binder.bind(VarsUserPreferencesFactory.class).to(VarsUserPreferencesFactoryImpl.class).in(Scopes.SINGLETON);
        binder.bind(PreferencesFactory.class).toProvider(PreferenceFactoryProvider.class);
    }

    private static class PreferenceFactoryProvider
    implements Provider<VarsUserPreferencesFactory> {
        private final VarsUserPreferencesFactory preferencesFactory;

        @Inject
        public PreferenceFactoryProvider(VarsUserPreferencesFactory preferencesFactory) {
            this.preferencesFactory = preferencesFactory;
        }

        public VarsUserPreferencesFactory get() {
            return this.preferencesFactory;
        }
    }
}

