/*
 * Decompiled with CFR 0.152.
 */
package vars.jpa;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.jasypt.util.password.BasicPasswordEncryptor;
import vars.UserAccount;
import vars.UserAccountRoles;
import vars.jpa.JPAEntity;
import vars.jpa.KeyNullifier;
import vars.jpa.TransactionLogger;

@Entity(name="UserAccount")
@Table(name="UserAccount")
@EntityListeners(value={TransactionLogger.class, KeyNullifier.class})
@NamedQueries(value={@NamedQuery(name="UserAccount.findById", query="SELECT v FROM UserAccount v WHERE v.id = :id"), @NamedQuery(name="UserAccount.findByUserName", query="SELECT v FROM UserAccount v WHERE v.userName = :userName"), @NamedQuery(name="UserAccount.findByFirstName", query="SELECT c FROM UserAccount c WHERE c.firstName = :firstName"), @NamedQuery(name="UserAccount.findByLastName", query="SELECT c FROM UserAccount c WHERE c.lastName = :lastName"), @NamedQuery(name="UserAccount.findByAffiliation", query="SELECT c FROM UserAccount c WHERE c.affiliation LIKE :affiliation"), @NamedQuery(name="UserAccount.findByRole", query="SELECT c FROM UserAccount c WHERE c.role LIKE :role"), @NamedQuery(name="UserAccount.findAll", query="SELECT c FROM UserAccount c")})
public class UserAccountImpl
implements Serializable,
UserAccount,
JPAEntity,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    @Column(name="Affiliation", length=512)
    String affiliation;
    @Column(name="Email", length=50)
    String email;
    @Column(name="FirstName", length=50)
    String firstName;
    @Id
    @Column(name="id", nullable=false, updatable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="UserAccount_Gen")
    @TableGenerator(name="UserAccount_Gen", table="UniqueID", pkColumnName="TableName", valueColumnName="NextID", pkColumnValue="UserName", allocationSize=1)
    Long id;
    @Column(name="LastName", length=50)
    String lastName;
    @Column(name="Password", nullable=false, length=50)
    String password;
    @Column(name="Role", nullable=false, length=10)
    String role;
    @Version
    @Column(name="LAST_UPDATED_TIME")
    private Timestamp updatedTime;
    @Column(name="UserName", nullable=false, unique=true, length=50)
    String userName;
    static final long serialVersionUID = 127566040000574505L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public UserAccountImpl() {
    }

    public boolean authenticate(String unencryptedPassword) {
        return new BasicPasswordEncryptor().checkPassword(unencryptedPassword, this._persistence_get_password());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserAccountImpl other = (UserAccountImpl)obj;
        return !(this._persistence_get_userName() == null ? other._persistence_get_userName() != null : !this._persistence_get_userName().equals(other._persistence_get_userName()));
    }

    public String getAffiliation() {
        return this._persistence_get_affiliation();
    }

    public String getEmail() {
        return this._persistence_get_email();
    }

    public String getFirstName() {
        return this._persistence_get_firstName();
    }

    @Override
    public Long getId() {
        return this._persistence_get_id();
    }

    public String getLastName() {
        return this._persistence_get_lastName();
    }

    public String getPassword() {
        return this._persistence_get_password();
    }

    public String getRole() {
        return this._persistence_get_role();
    }

    public String getUserName() {
        return this._persistence_get_userName();
    }

    public int hashCode() {
        int hash = 5;
        hash = 41 * hash + (this._persistence_get_userName() != null ? this._persistence_get_userName().hashCode() : 0);
        return hash;
    }

    public boolean isAdministrator() {
        return UserAccountRoles.ADMINISTRATOR.getRoleName().equals(this._persistence_get_role());
    }

    public boolean isMaintainer() {
        return UserAccountRoles.MAINTENANCE.getRoleName().equals(this._persistence_get_role());
    }

    public boolean isReadOnly() {
        return UserAccountRoles.READONLY.getRoleName().equals(this._persistence_get_role());
    }

    public void setAffiliation(String affiliation) {
        this._persistence_set_affiliation(affiliation);
    }

    public void setEmail(String email) {
        this._persistence_set_email(email);
    }

    public void setFirstName(String firstName) {
        this._persistence_set_firstName(firstName);
    }

    public void setId(Long id) {
        this._persistence_set_id(id);
    }

    public void setLastName(String lastName) {
        this._persistence_set_lastName(lastName);
    }

    public void setPassword(String unencryptedPassword) {
        this._persistence_set_password(new BasicPasswordEncryptor().encryptPassword(unencryptedPassword));
    }

    public void setRole(String role) {
        this._persistence_set_role(role);
    }

    public void setUserName(String userName) {
        this._persistence_set_userName(userName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" ([id=").append(this.getId()).append("] ");
        sb.append("userName=").append(this._persistence_get_userName()).append(")");
        return sb.toString();
    }

    public Object getPrimaryKey() {
        return this.getId();
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new UserAccountImpl(persistenceObject);
    }

    public UserAccountImpl(PersistenceObject persistenceObject) {
    }

    public Object _persistence_get(String string) {
        if (string == "firstName") {
            return this.firstName;
        }
        if (string == "lastName") {
            return this.lastName;
        }
        if (string == "updatedTime") {
            return this.updatedTime;
        }
        if (string == "password") {
            return this.password;
        }
        if (string == "role") {
            return this.role;
        }
        if (string == "affiliation") {
            return this.affiliation;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "userName") {
            return this.userName;
        }
        if (string == "email") {
            return this.email;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "firstName") {
            this.firstName = (String)object;
            return;
        }
        if (string == "lastName") {
            this.lastName = (String)object;
            return;
        }
        if (string == "updatedTime") {
            this.updatedTime = (Timestamp)object;
            return;
        }
        if (string == "password") {
            this.password = (String)object;
            return;
        }
        if (string == "role") {
            this.role = (String)object;
            return;
        }
        if (string == "affiliation") {
            this.affiliation = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "userName") {
            this.userName = (String)object;
            return;
        }
        if (string == "email") {
            this.email = (String)object;
            return;
        }
    }

    public String _persistence_get_firstName() {
        this._persistence_checkFetched("firstName");
        return this.firstName;
    }

    public void _persistence_set_firstName(String string) {
        this._persistence_checkFetchedForSet("firstName");
        this._persistence_propertyChange("firstName", this.firstName, string);
        this.firstName = string;
    }

    public String _persistence_get_lastName() {
        this._persistence_checkFetched("lastName");
        return this.lastName;
    }

    public void _persistence_set_lastName(String string) {
        this._persistence_checkFetchedForSet("lastName");
        this._persistence_propertyChange("lastName", this.lastName, string);
        this.lastName = string;
    }

    public Timestamp _persistence_get_updatedTime() {
        this._persistence_checkFetched("updatedTime");
        return this.updatedTime;
    }

    public void _persistence_set_updatedTime(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("updatedTime");
        this._persistence_propertyChange("updatedTime", this.updatedTime, timestamp);
        this.updatedTime = timestamp;
    }

    public String _persistence_get_password() {
        this._persistence_checkFetched("password");
        return this.password;
    }

    public void _persistence_set_password(String string) {
        this._persistence_checkFetchedForSet("password");
        this._persistence_propertyChange("password", this.password, string);
        this.password = string;
    }

    public String _persistence_get_role() {
        this._persistence_checkFetched("role");
        return this.role;
    }

    public void _persistence_set_role(String string) {
        this._persistence_checkFetchedForSet("role");
        this._persistence_propertyChange("role", this.role, string);
        this.role = string;
    }

    public String _persistence_get_affiliation() {
        this._persistence_checkFetched("affiliation");
        return this.affiliation;
    }

    public void _persistence_set_affiliation(String string) {
        this._persistence_checkFetchedForSet("affiliation");
        this._persistence_propertyChange("affiliation", this.affiliation, string);
        this.affiliation = string;
    }

    public Long _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(Long l) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, l);
        this.id = l;
    }

    public String _persistence_get_userName() {
        this._persistence_checkFetched("userName");
        return this.userName;
    }

    public void _persistence_set_userName(String string) {
        this._persistence_checkFetchedForSet("userName");
        this._persistence_propertyChange("userName", this.userName, string);
        this.userName = string;
    }

    public String _persistence_get_email() {
        this._persistence_checkFetched("email");
        return this.email;
    }

    public void _persistence_set_email(String string) {
        this._persistence_checkFetchedForSet("email");
        this._persistence_propertyChange("email", this.email, string);
        this.email = string;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

