/*
 * Decompiled with CFR 0.152.
 */
package vars.jpa;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import javax.persistence.Cache;
import javax.persistence.EntityManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.PersistenceCacheProvider;
import vars.VARSObject;
import vars.annotation.AnnotationObject;
import vars.knowledgebase.KnowledgebaseObject;

public class JPACacheProvider
implements PersistenceCacheProvider {
    private final EntityManagerFactory kbEmf;
    private final EntityManagerFactory annoEmf;
    private final EntityManagerFactory miscEmf;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Inject
    public JPACacheProvider(@Named(value="annotationPersistenceUnit") EntityManagerFactory annoEmf, @Named(value="knowledgebasePersistenceUnit") EntityManagerFactory kbEmf, @Named(value="miscPersistenceUnit") EntityManagerFactory miscEmf) {
        this.kbEmf = kbEmf;
        this.annoEmf = annoEmf;
        this.miscEmf = miscEmf;
    }

    public void clear() {
        Cache cache = this.kbEmf.getCache();
        cache.evictAll();
        cache = this.annoEmf.getCache();
        cache.evictAll();
        cache = this.miscEmf.getCache();
        cache.evictAll();
    }

    public void evict(AnnotationObject entity) {
        this.evict(this.annoEmf.getCache(), (VARSObject)entity);
    }

    public void evict(KnowledgebaseObject entity) {
        this.evict(this.kbEmf.getCache(), (VARSObject)entity);
    }

    private void evict(Cache cache, VARSObject entity) {
        try {
            cache.evict(entity.getClass(), entity.getPrimaryKey());
        }
        catch (Exception e) {
            this.log.info("Failed to evict " + entity + " from cache", (Throwable)e);
        }
    }
}

