/*
 * Decompiled with CFR 0.152.
 */
package vars.jpa;

import com.google.inject.Inject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.jpa.EntityManagerAspect;
import vars.jpa.JPAEntity;

public class DAO
implements vars.DAO,
EntityManagerAspect {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final EntityManager entityManager;
    private final String JDBC_URL_KEY = "javax.persistence.jdbc.url";

    @Inject
    public DAO(EntityManager entityManager) {
        Map m;
        this.entityManager = entityManager;
        if (this.log.isInfoEnabled() && entityManager != null && (m = entityManager.getProperties()).containsKey("javax.persistence.jdbc.url")) {
            this.log.info("Connecting to {}", m.get("javax.persistence.jdbc.url"));
        }
    }

    public void close() {
        if (this.entityManager.isOpen()) {
            this.entityManager.close();
        }
    }

    public void commit() {
        if (this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().commit();
        }
    }

    public void endTransaction() {
        EntityTransaction entityTransaction = this.entityManager.getTransaction();
        if (entityTransaction.isActive()) {
            try {
                if (entityTransaction.getRollbackOnly()) {
                    entityTransaction.rollback();
                } else {
                    entityTransaction.commit();
                }
            }
            catch (PersistenceException e) {
                if (entityTransaction.isActive()) {
                    entityTransaction.rollback();
                }
                throw e;
            }
            finally {
                this.log.debug("JPA Transaction Ended");
            }
        }
    }

    public boolean equalInDatastore(Object thisObj, Object thatObj) {
        JPAEntity thisEntity = (JPAEntity)thisObj;
        JPAEntity thatEntity = (JPAEntity)thatObj;
        return thisEntity.getId().equals(thatEntity.getId());
    }

    public <T> T find(T object) {
        this.log.debug("Executing FIND on {}", object);
        JPAEntity jpaEntity = (JPAEntity)object;
        return (T)this.entityManager.find(jpaEntity.getClass(), (Object)jpaEntity.getId());
    }

    public List findByNamedQuery(String name, Map<String, Object> namedParameters) {
        if (this.log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("Executing FIND using named query '");
            sb.append(name).append("'");
            if (namedParameters.size() > 0) {
                sb.append(" with parameters:\n");
                for (String string : namedParameters.keySet()) {
                    sb.append("\t").append(string).append(" = ").append(namedParameters.get(string));
                }
            }
            this.log.debug(sb.toString());
        }
        List resultList = null;
        Query query = this.entityManager.createNamedQuery(name);
        for (String key : namedParameters.keySet()) {
            query.setParameter(key, namedParameters.get(key));
        }
        resultList = query.getResultList();
        return resultList;
    }

    public List findByNamedQuery(String name) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.findByNamedQuery(name, params);
    }

    public <T> T findByPrimaryKey(Class<T> clazz, Object primaryKey) {
        Object value = null;
        this.log.debug("Executing FIND for {} using primary key = {}", clazz, primaryKey);
        value = this.entityManager.find(clazz, primaryKey);
        return (T)value;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public boolean isPersistent(Object entity) {
        boolean hasNullPK;
        boolean bl = entity instanceof JPAEntity ? ((JPAEntity)entity).getId() == null : (hasNullPK = false);
        return hasNullPK ? false : this.find(entity) != null;
    }

    public void loadLazyRelations(Object entity) {
        this.log.debug("Executing {} on {}", (Object)TransactionType.LOAD_LAZY_RELATIONS, entity);
        try {
            Method method = entity.getClass().getMethod("invokeLazyGetters", new Class[0]);
            method.invoke(entity, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            this.log.warn("Attempted to invoke 'invokeLazyGetters' method on " + entity + " but no such method exists", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("Failed to call 'invokeLazyGetters on " + entity, (Throwable)e);
        }
    }

    public <T> T merge(T entity) {
        this.log.debug("Executing {} on {}", (Object)TransactionType.MERGE, entity);
        return (T)this.entityManager.merge(entity);
    }

    public void persist(Object entity) {
        this.log.debug("Executing {} on {}", (Object)TransactionType.PERSIST, entity);
        this.entityManager.persist(entity);
    }

    public void remove(Object entity) {
        this.log.debug("Executing {} on {}", (Object)TransactionType.REMOVE, entity);
        this.entityManager.remove(entity);
    }

    public void startTransaction() {
        EntityTransaction entityTransaction = this.entityManager.getTransaction();
        if (!entityTransaction.isActive()) {
            entityTransaction.begin();
            this.log.debug("JPA Transaction Started");
        }
    }

    public static Map<String, Object> toParameterMap(Object ... args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (int i = 0; i < args.length; i += 2) {
            params.put((String)args[i], args[i + 1]);
        }
        return params;
    }

    public static enum TransactionType {
        REMOVE,
        FIND,
        PERSIST,
        LOAD_LAZY_RELATIONS,
        MERGE;

    }
}

