/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.jpa;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import vars.VideoMomentByTimecodeComparator;
import vars.annotation.CameraDeployment;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveSet;
import vars.annotation.VideoFrame;
import vars.annotation.jpa.CameraDeploymentImpl;
import vars.annotation.jpa.VideoArchiveImpl;
import vars.jpa.JPAEntity;
import vars.jpa.KeyNullifier;
import vars.jpa.TransactionLogger;

@Entity(name="VideoArchiveSet")
@Table(name="VideoArchiveSet", indexes={@Index(name="idx_VideoArchiveSet_LUT", columnList="LAST_UPDATED_TIME")})
@Cacheable(value=true)
@EntityListeners(value={TransactionLogger.class, KeyNullifier.class})
@NamedQueries(value={@NamedQuery(name="VideoArchiveSet.findById", query="SELECT v FROM VideoArchiveSet v WHERE v.id = :id"), @NamedQuery(name="VideoArchiveSet.findAll", query="SELECT v FROM VideoArchiveSet v"), @NamedQuery(name="VideoArchiveSet.findByTrackingNumber", query="SELECT v FROM VideoArchiveSet v WHERE v.trackingNumber = :trackingNumber"), @NamedQuery(name="VideoArchiveSet.findByPlatformName", query="SELECT v FROM VideoArchiveSet v WHERE v.platformName = :platformName"), @NamedQuery(name="VideoArchiveSet.findByFormatCode", query="SELECT v FROM VideoArchiveSet v WHERE v.formatCode = :formatCode"), @NamedQuery(name="VideoArchiveSet.findByStartDate", query="SELECT v FROM VideoArchiveSet v WHERE v.startDate = :startDate"), @NamedQuery(name="VideoArchiveSet.findByEndDate", query="SELECT v FROM VideoArchiveSet v WHERE v.endDate = :endDate"), @NamedQuery(name="VideoArchiveSet.findBetweenDates", query="SELECT v FROM VideoArchiveSet v WHERE v.startDate BETWEEN :date0 AND :date1"), @NamedQuery(name="VideoArchiveSet.findByPlatformAndTrackingNumber", query="SELECT v FROM VideoArchiveSet v WHERE v.platformName = :platformName AND v.trackingNumber = :trackingNumber"), @NamedQuery(name="VideoArchiveSet.findByPlatformAndSequenceNumber", query="SELECT v FROM VideoArchiveSet v, IN (v.cameraDeployments) c WHERE v.platformName = :platformName AND c.sequenceNumber = :sequenceNumber"), @NamedQuery(name="VideoArchiveSet.findAllWithMissingDates", query="SELECT v FROM VideoArchiveSet v WHERE v.startDate IS NULL OR v.endDate IS NULL"), @NamedQuery(name="VideoArchiveSet.findAllWithMissingTrackingNumbers", query="SELECT v FROM VideoArchiveSet v WHERE v.trackingNumber IS NULL"), @NamedQuery(name="VideoArchiveSet.findAllWithMultipleCameraDeployments", query="SELECT v FROM VideoArchiveSet v WHERE SIZE(v.cameraDeployments) > 1"), @NamedQuery(name="VideoArchiveSet.findAllWithMissingCameraDeployments", query="SELECT v FROM VideoArchiveSet v WHERE SIZE(v.cameraDeployments) = 0")})
public class VideoArchiveSetImpl
implements Serializable,
VideoArchiveSet,
JPAEntity,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedRest {
    @Transient
    private final VideoMomentByTimecodeComparator comparator = new VideoMomentByTimecodeComparator();
    @Id
    @Column(name="id", nullable=false, updatable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="VideoArchiveSet_Gen")
    @TableGenerator(name="VideoArchiveSet_Gen", table="UniqueID", pkColumnName="TableName", valueColumnName="NextID", pkColumnValue="VideoArchiveSet", allocationSize=1)
    Long id;
    @Version
    @Column(name="LAST_UPDATED_TIME")
    private Timestamp updatedTime;
    @Column(name="TrackingNumber", length=7)
    String trackingNumber;
    @Column(name="ShipName", length=32)
    @Deprecated
    String shipName;
    @Column(name="PlatformName", nullable=false, length=32)
    String platformName;
    @Column(name="FormatCode", length=2)
    char formatCode;
    @Column(name="StartDTG")
    @Temporal(value=TemporalType.TIMESTAMP)
    Date startDate;
    @Column(name="EndDTG")
    @Temporal(value=TemporalType.TIMESTAMP)
    Date endDate;
    @OneToMany(targetEntity=VideoArchiveImpl.class, mappedBy="videoArchiveSet", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @OrderBy(value="name")
    Set<VideoArchive> videoArchives;
    @OneToMany(targetEntity=CameraDeploymentImpl.class, mappedBy="videoArchiveSet", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    Set<CameraDeployment> cameraDeployments;
    static final long serialVersionUID = -3543050601419728296L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public Set<CameraDeployment> getCameraDeployments() {
        if (this._persistence_get_cameraDeployments() == null) {
            this._persistence_set_cameraDeployments(new HashSet());
        }
        return this._persistence_get_cameraDeployments();
    }

    public Set<VideoArchive> getVideoArchives() {
        if (this._persistence_get_videoArchives() == null) {
            this._persistence_set_videoArchives(new HashSet());
        }
        return this._persistence_get_videoArchives();
    }

    public void addVideoArchive(VideoArchive videoArchive) {
        Collection archives = Collections2.filter(this.getVideoArchives(), (Predicate)new NamePredicate(videoArchive.getName()));
        if (archives.size() > 0) {
            throw new IllegalArgumentException("A VideoArchive named '" + videoArchive.getName() + "' already exists in " + this);
        }
        if (this.getVideoArchives().add(videoArchive)) {
            ((VideoArchiveImpl)videoArchive).setVideoArchiveSet(this);
        }
    }

    public void removeVideoArchive(VideoArchive videoArchive) {
        if (this.getVideoArchives().remove(videoArchive)) {
            ((VideoArchiveImpl)videoArchive).setVideoArchiveSet(null);
        }
    }

    public void addCameraDeployment(CameraDeployment cameraDeployment) {
        if (this.getCameraDeployments().add(cameraDeployment)) {
            ((CameraDeploymentImpl)cameraDeployment).setVideoArchiveSet(this);
        }
    }

    public void removeCameraDeployment(CameraDeployment cameraDeployment) {
        if (this.getCameraDeployments().remove(cameraDeployment)) {
            ((CameraDeploymentImpl)cameraDeployment).setVideoArchiveSet(null);
        }
    }

    public VideoArchive getVideoArchiveByName(String videoArchiveName) {
        Collection archives = Collections2.filter(this.getVideoArchives(), (Predicate)new NamePredicate(videoArchiveName));
        VideoArchive videoArchive = null;
        if (archives.size() > 0) {
            videoArchive = (VideoArchive)archives.iterator().next();
        }
        return videoArchive;
    }

    public List<VideoFrame> getVideoFrames() {
        ArrayList<VideoFrame> videoFrames = new ArrayList<VideoFrame>();
        for (VideoArchive videoArchive : this.getVideoArchives()) {
            videoFrames.addAll(videoArchive.getVideoFrames());
        }
        Collections.sort(videoFrames, this.comparator);
        return videoFrames;
    }

    public boolean hasSequenceNumber(int seqNumber) {
        Collection deployments = Collections2.filter(this.getCameraDeployments(), (Predicate)new SequenceNumberPredicate(seqNumber));
        return deployments.size() > 0;
    }

    public boolean hasVideoArchiveName(String videoArchiveName) {
        return this.getVideoArchiveByName(videoArchiveName) != null;
    }

    public Date getEndDate() {
        return this._persistence_get_endDate();
    }

    public char getFormatCode() {
        return this._persistence_get_formatCode();
    }

    public String getPlatformName() {
        return this._persistence_get_platformName();
    }

    public String getShipName() {
        return this._persistence_get_shipName();
    }

    public Date getStartDate() {
        return this._persistence_get_startDate();
    }

    public String getTrackingNumber() {
        return this._persistence_get_trackingNumber();
    }

    public void setEndDate(Date endDTG) {
        this._persistence_set_endDate(endDTG);
    }

    public void setFormatCode(char formatCode) {
        this._persistence_set_formatCode(formatCode);
    }

    public void setId(Long id) {
        this._persistence_set_id(id);
    }

    public void setPlatformName(String platformName) {
        this._persistence_set_platformName(platformName);
    }

    public void setShipName(String shipName) {
        this._persistence_set_shipName(shipName);
    }

    public void setStartDate(Date startDTG) {
        this._persistence_set_startDate(startDTG);
    }

    public void setTrackingNumber(String trackingNumber) {
        this._persistence_set_trackingNumber(trackingNumber);
    }

    @Override
    public Long getId() {
        return this._persistence_get_id();
    }

    public Object getPrimaryKey() {
        return this.getId();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VideoArchiveSetImpl other = (VideoArchiveSetImpl)obj;
        if (this._persistence_get_trackingNumber() == null ? other._persistence_get_trackingNumber() != null : !this._persistence_get_trackingNumber().equals(other._persistence_get_trackingNumber())) {
            return false;
        }
        if (this._persistence_get_platformName() == null ? other._persistence_get_platformName() != null : !this._persistence_get_platformName().equals(other._persistence_get_platformName())) {
            return false;
        }
        if (this._persistence_get_formatCode() != other._persistence_get_formatCode()) {
            return false;
        }
        if (!(this._persistence_get_startDate() == other._persistence_get_startDate() || this._persistence_get_startDate() != null && this._persistence_get_startDate().equals(other._persistence_get_startDate()))) {
            return false;
        }
        return this._persistence_get_endDate() == other._persistence_get_endDate() || this._persistence_get_endDate() != null && this._persistence_get_endDate().equals(other._persistence_get_endDate());
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this._persistence_get_trackingNumber() != null ? this._persistence_get_trackingNumber().hashCode() : 0);
        hash = 97 * hash + (this._persistence_get_platformName() != null ? this._persistence_get_platformName().hashCode() : 0);
        hash = 97 * hash + this._persistence_get_formatCode();
        hash = 97 * hash + (this._persistence_get_startDate() != null ? this._persistence_get_startDate().hashCode() : 0);
        hash = 97 * hash + (this._persistence_get_endDate() != null ? this._persistence_get_endDate().hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" ([id=").append(this.getId()).append("] platformName=");
        sb.append(this._persistence_get_platformName()).append(", trackingNumber=").append(this._persistence_get_trackingNumber());
        sb.append(", formatCode=").append(this._persistence_get_formatCode()).append(")");
        return sb.toString();
    }

    public Object _persistence_post_clone() {
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new VideoArchiveSetImpl();
    }

    public Object _persistence_get(String string) {
        if (string == "updatedTime") {
            return this.updatedTime;
        }
        if (string == "formatCode") {
            return Character.valueOf(this.formatCode);
        }
        if (string == "endDate") {
            return this.endDate;
        }
        if (string == "videoArchives") {
            return this.videoArchives;
        }
        if (string == "cameraDeployments") {
            return this.cameraDeployments;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "shipName") {
            return this.shipName;
        }
        if (string == "platformName") {
            return this.platformName;
        }
        if (string == "trackingNumber") {
            return this.trackingNumber;
        }
        if (string == "startDate") {
            return this.startDate;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "updatedTime") {
            this.updatedTime = (Timestamp)object;
            return;
        }
        if (string == "formatCode") {
            this.formatCode = ((Character)object).charValue();
            return;
        }
        if (string == "endDate") {
            this.endDate = (Date)object;
            return;
        }
        if (string == "videoArchives") {
            this.videoArchives = (Set)object;
            return;
        }
        if (string == "cameraDeployments") {
            this.cameraDeployments = (Set)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "shipName") {
            this.shipName = (String)object;
            return;
        }
        if (string == "platformName") {
            this.platformName = (String)object;
            return;
        }
        if (string == "trackingNumber") {
            this.trackingNumber = (String)object;
            return;
        }
        if (string == "startDate") {
            this.startDate = (Date)object;
            return;
        }
    }

    public Timestamp _persistence_get_updatedTime() {
        this._persistence_checkFetched("updatedTime");
        return this.updatedTime;
    }

    public void _persistence_set_updatedTime(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("updatedTime");
        this.updatedTime = timestamp;
    }

    public char _persistence_get_formatCode() {
        this._persistence_checkFetched("formatCode");
        return this.formatCode;
    }

    public void _persistence_set_formatCode(char c) {
        this._persistence_checkFetchedForSet("formatCode");
        this.formatCode = c;
    }

    public Date _persistence_get_endDate() {
        this._persistence_checkFetched("endDate");
        return this.endDate;
    }

    public void _persistence_set_endDate(Date date) {
        this._persistence_checkFetchedForSet("endDate");
        this.endDate = date;
    }

    public Set _persistence_get_videoArchives() {
        this._persistence_checkFetched("videoArchives");
        return this.videoArchives;
    }

    public void _persistence_set_videoArchives(Set set) {
        this._persistence_checkFetchedForSet("videoArchives");
        this.videoArchives = set;
    }

    public Set _persistence_get_cameraDeployments() {
        this._persistence_checkFetched("cameraDeployments");
        return this.cameraDeployments;
    }

    public void _persistence_set_cameraDeployments(Set set) {
        this._persistence_checkFetchedForSet("cameraDeployments");
        this.cameraDeployments = set;
    }

    public Long _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(Long l) {
        this._persistence_checkFetchedForSet("id");
        this.id = l;
    }

    public String _persistence_get_shipName() {
        this._persistence_checkFetched("shipName");
        return this.shipName;
    }

    public void _persistence_set_shipName(String string) {
        this._persistence_checkFetchedForSet("shipName");
        this.shipName = string;
    }

    public String _persistence_get_platformName() {
        this._persistence_checkFetched("platformName");
        return this.platformName;
    }

    public void _persistence_set_platformName(String string) {
        this._persistence_checkFetchedForSet("platformName");
        this.platformName = string;
    }

    public String _persistence_get_trackingNumber() {
        this._persistence_checkFetched("trackingNumber");
        return this.trackingNumber;
    }

    public void _persistence_set_trackingNumber(String string) {
        this._persistence_checkFetchedForSet("trackingNumber");
        this.trackingNumber = string;
    }

    public Date _persistence_get_startDate() {
        this._persistence_checkFetched("startDate");
        return this.startDate;
    }

    public void _persistence_set_startDate(Date date) {
        this._persistence_checkFetchedForSet("startDate");
        this.startDate = date;
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }

    private class SequenceNumberPredicate
    implements Predicate<CameraDeployment> {
        private final Integer sequenceNumber;

        public SequenceNumberPredicate(Integer sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public boolean apply(CameraDeployment input) {
            return input.getSequenceNumber().equals(this.sequenceNumber);
        }
    }

    private class NamePredicate
    implements Predicate<VideoArchive> {
        private final String name;

        public NamePredicate(String name) {
            this.name = name;
        }

        public boolean apply(VideoArchive input) {
            return input.getName().equals(this.name);
        }
    }
}

