/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.jpa;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import vars.annotation.AnnotationFactory;
import vars.annotation.CameraDeployment;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoArchiveSet;
import vars.annotation.VideoArchiveSetDAO;
import vars.annotation.jpa.CameraDeploymentDAOImpl;
import vars.annotation.jpa.VideoArchiveDAOImpl;
import vars.jpa.DAO;
import vars.knowledgebase.Concept;

public class VideoArchiveSetDAOImpl
extends DAO
implements VideoArchiveSetDAO {
    private final VideoArchiveDAO videoArchiveDAO;

    @Inject
    public VideoArchiveSetDAOImpl(EntityManager entityManager, AnnotationFactory annotationFactory) {
        super(entityManager);
        this.videoArchiveDAO = new VideoArchiveDAOImpl(entityManager, annotationFactory);
    }

    public Set<String> findAllLinkValues(VideoArchiveSet videoArchiveSet, String linkName) {
        return this.findAllLinkValues(videoArchiveSet, linkName, null);
    }

    public Set<String> findAllLinkValues(VideoArchiveSet videoArchiveSet, String linkName, Concept concept) {
        HashSet<String> linkValues = new HashSet<String>();
        for (VideoArchive videoArchive : videoArchiveSet.getVideoArchives()) {
            linkValues.addAll(this.videoArchiveDAO.findAllLinkValues(videoArchive, linkName, concept));
        }
        return linkValues;
    }

    public Collection<VideoArchiveSet> findAllByPlatform(String platform) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("platformName", platform);
        return this.findByNamedQuery("VideoArchiveSet.findByPlatformName", params);
    }

    public Collection<VideoArchiveSet> findAllBetweenDates(Date startDate, Date endDate) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("date0", startDate);
        params.put("date1", endDate);
        return this.findByNamedQuery("VideoArchiveSet.findBetweenDates", params);
    }

    public Collection<VideoArchiveSet> findAll() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.findByNamedQuery("VideoArchiveSet.findAll", params);
    }

    public Collection<VideoArchiveSet> findAllByPlatformAndSequenceNumber(String platform, int sequenceNumber) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("platformName", platform);
        params.put("sequenceNumber", sequenceNumber);
        return this.findByNamedQuery("VideoArchiveSet.findByPlatformAndSequenceNumber", params);
    }

    public Collection<VideoArchiveSet> findAllByPlatformAndTrackingNumber(String platform, String trackingNumber) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("platformName", platform);
        params.put("trackingNumber", trackingNumber);
        return this.findByNamedQuery("VideoArchiveSet.findByPlatformAndTrackingNumber", params);
    }

    public Collection<VideoArchiveSet> findAllByTrackingNumber(String trackingNumber) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("trackingNumber", trackingNumber);
        return this.findByNamedQuery("VideoArchiveSet.findByTrackingNumber", params);
    }

    public Set<Integer> findAllSequenceNumbersByPlatformName(String platformName) {
        HashSet<Integer> sequenceNumbers = new HashSet<Integer>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("platformName", platformName);
        List videoArchiveSets = this.findByNamedQuery("VideoArchiveSet.findByPlatformName", params);
        for (VideoArchiveSet videoArchiveSet : videoArchiveSets) {
            for (CameraDeployment cameraDeployment : videoArchiveSet.getCameraDeployments()) {
                sequenceNumbers.add(cameraDeployment.getSequenceNumber());
            }
        }
        return sequenceNumbers;
    }

    public Integer findVideoFrameCountByPrimaryKey(Object primaryKey) {
        Integer count = 0;
        VideoArchiveSet videoArchiveSet = this.findByPrimaryKey(VideoArchiveSet.class, primaryKey);
        if (videoArchiveSet != null) {
            count = videoArchiveSet.getVideoFrames().size();
        } else {
            this.log.info("No VideoArchiveSet with id = " + primaryKey + " was found in the database");
        }
        return count;
    }

    public Collection<VideoArchiveSet> findAllWithMissingCameraDeployments() {
        return this.findByNamedQuery("VideoArchiveSet.findAllWithMissingCameraDeployments");
    }

    public Collection<VideoArchiveSet> findAllWithoutTrackingNumber() {
        return this.findByNamedQuery("VideoArchiveSet.findAllWithMissingTrackingNumbers");
    }

    public Collection<VideoArchiveSet> findAllThatDuplicatePlatformAndSequenceNumber() {
        return null;
    }

    public Collection<VideoArchiveSet> findAllWithMultipleCameraDeployments() {
        return this.findByNamedQuery("VideoArchiveSet.findAllWithMultipleCameraDeployments");
    }

    public Collection<VideoArchiveSet> findAllWithoutDates() {
        return this.findByNamedQuery("VideoArchiveSet.findAllWithMissingDates");
    }

    public Collection<VideoArchiveSet> findAllWithNoChiefScientist() {
        CameraDeploymentDAOImpl dao = new CameraDeploymentDAOImpl(this.getEntityManager());
        List cameraDeployments = dao.findAllWithoutChiefScientistName();
        HashSet<VideoArchiveSet> videoArchiveSets = new HashSet<VideoArchiveSet>();
        for (CameraDeployment cameraDeployment : cameraDeployments) {
            videoArchiveSets.add(cameraDeployment.getVideoArchiveSet());
        }
        return videoArchiveSets;
    }

    public VideoArchiveSet findByPrimaryKey(final Object primaryKey) {
        HashMap<String, Object> params = new HashMap<String, Object>(){
            {
                this.put("id", primaryKey);
            }
        };
        List vas = this.findByNamedQuery("VideoArchiveSet.findById", (Map<String, Object>)params);
        return vas.size() > 0 ? (VideoArchiveSet)vas.get(0) : null;
    }
}

