/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.jpa;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveSet;
import vars.annotation.VideoFrame;
import vars.annotation.VideoFrameTCBean;
import vars.annotation.jpa.VideoArchiveSetImpl;
import vars.annotation.jpa.VideoFrameImpl;
import vars.jpa.JPAEntity;
import vars.jpa.KeyNullifier;
import vars.jpa.TransactionLogger;

@Entity(name="VideoArchive")
@Table(name="VideoArchive", indexes={@Index(name="idx_VideoArchive_FK1", columnList="VideoArchiveSetID_FK"), @Index(name="idx_VideoArchive_name", columnList="VideoArchiveName"), @Index(name="idx_VideoArchive_LUT", columnList="LAST_UPDATED_TIME")})
@Cacheable(value=false)
@EntityListeners(value={TransactionLogger.class, KeyNullifier.class})
@NamedQueries(value={@NamedQuery(name="VideoArchive.findById", query="SELECT v FROM VideoArchive v WHERE v.id = :id"), @NamedQuery(name="VideoArchive.findByName", query="SELECT v FROM VideoArchive v WHERE v.name = :name")})
public class VideoArchiveImpl
implements Serializable,
VideoArchive,
JPAEntity,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
ChangeTracker,
PersistenceWeavedChangeTracking,
PersistenceWeavedRest {
    @Transient
    private final Predicate<VideoFrame> emptyVideoFramePredicate = new EmptyVideoFramePredicate();
    @Id
    @Column(name="id", nullable=false, updatable=false)
    @GeneratedValue(strategy=GenerationType.TABLE, generator="VideoArchive_Gen")
    @TableGenerator(name="VideoArchive_Gen", table="UniqueID", pkColumnName="TableName", valueColumnName="NextID", pkColumnValue="VideoArchive", allocationSize=1)
    Long id;
    @Version
    @Column(name="LAST_UPDATED_TIME")
    private Timestamp updatedTime;
    @ManyToOne(optional=false, targetEntity=VideoArchiveSetImpl.class)
    @JoinColumn(name="VideoArchiveSetID_FK")
    VideoArchiveSet videoArchiveSet;
    @Column(name="VideoArchiveName", nullable=false, unique=true, length=512)
    String name;
    @Column(name="StartTimeCode", length=11)
    @Deprecated
    String startTimecode;
    @OneToMany(fetch=FetchType.LAZY, targetEntity=VideoFrameImpl.class, mappedBy="videoArchive", cascade={CascadeType.ALL})
    @OrderBy(value="timecode")
    List<VideoFrame> videoFrames;
    static final long serialVersionUID = -4584320595976093497L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient PropertyChangeListener _persistence_listener;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public List<VideoFrame> getVideoFrames() {
        if (this._persistence_get_videoFrames() == null) {
            this._persistence_set_videoFrames(new ArrayList());
        }
        return this._persistence_get_videoFrames();
    }

    private int indexByTimecode(String timecode) {
        return Collections.binarySearch(this.getVideoFrames(), new VideoFrameTCBean(timecode), new Comparator<VideoFrame>(){

            @Override
            public int compare(VideoFrame o1, VideoFrame o2) {
                return o1.getTimecode().compareTo(o2.getTimecode());
            }
        });
    }

    public void addVideoFrame(VideoFrame videoFrame) {
        this.getVideoFrames().add(videoFrame);
        ((VideoFrameImpl)videoFrame).setVideoArchive(this);
    }

    public VideoFrame findVideoFrameByTimeCode(String timecode) {
        VideoFrame videoFrame = null;
        for (VideoFrame vf : this.getVideoFrames()) {
            if (!vf.getTimecode().equals(timecode)) continue;
            videoFrame = vf;
        }
        return videoFrame;
    }

    public Collection<VideoFrame> getEmptyVideoFrames() {
        return Collections2.filter(this.getVideoFrames(), this.emptyVideoFramePredicate);
    }

    public void removeVideoFrame(VideoFrame videoFrame) {
        if (this.getVideoFrames().remove(videoFrame)) {
            ((VideoFrameImpl)videoFrame).setVideoArchive(null);
        }
    }

    public void loadLazyRelations() {
        for (VideoFrame videoFrame : this._persistence_get_videoFrames()) {
            videoFrame.getTimecode();
        }
    }

    public String getStartTimecode() {
        return this._persistence_get_startTimecode();
    }

    public void setId(Long id) {
        this._persistence_set_id(id);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public VideoArchiveSet getVideoArchiveSet() {
        return this._persistence_get_videoArchiveSet();
    }

    public void setStartTimecode(String timecode) {
        this._persistence_set_startTimecode(timecode);
    }

    public void setName(String videoArchiveName) {
        this._persistence_set_name(videoArchiveName);
    }

    @Override
    public Long getId() {
        return this._persistence_get_id();
    }

    void setVideoArchiveSet(VideoArchiveSet videoArchiveSet) {
        this._persistence_set_videoArchiveSet(videoArchiveSet);
    }

    public Object getPrimaryKey() {
        return this.getId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "([id=" + this._persistence_get_id() + "] name=" + this._persistence_get_name() + ")";
    }

    public Object _persistence_post_clone() {
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new VideoArchiveImpl();
    }

    public Object _persistence_get(String string) {
        if (string == "updatedTime") {
            return this.updatedTime;
        }
        if (string == "startTimecode") {
            return this.startTimecode;
        }
        if (string == "videoArchiveSet") {
            return this.videoArchiveSet;
        }
        if (string == "videoFrames") {
            return this.videoFrames;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "id") {
            return this.id;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "updatedTime") {
            this.updatedTime = (Timestamp)object;
            return;
        }
        if (string == "startTimecode") {
            this.startTimecode = (String)object;
            return;
        }
        if (string == "videoArchiveSet") {
            this.videoArchiveSet = (VideoArchiveSet)object;
            return;
        }
        if (string == "videoFrames") {
            this.videoFrames = (List)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
    }

    public Timestamp _persistence_get_updatedTime() {
        this._persistence_checkFetched("updatedTime");
        return this.updatedTime;
    }

    public void _persistence_set_updatedTime(Timestamp timestamp) {
        this._persistence_checkFetchedForSet("updatedTime");
        this._persistence_propertyChange("updatedTime", this.updatedTime, timestamp);
        this.updatedTime = timestamp;
    }

    public String _persistence_get_startTimecode() {
        this._persistence_checkFetched("startTimecode");
        return this.startTimecode;
    }

    public void _persistence_set_startTimecode(String string) {
        this._persistence_checkFetchedForSet("startTimecode");
        this._persistence_propertyChange("startTimecode", this.startTimecode, string);
        this.startTimecode = string;
    }

    public VideoArchiveSet _persistence_get_videoArchiveSet() {
        this._persistence_checkFetched("videoArchiveSet");
        return this.videoArchiveSet;
    }

    public void _persistence_set_videoArchiveSet(VideoArchiveSet videoArchiveSet) {
        this._persistence_checkFetchedForSet("videoArchiveSet");
        this._persistence_propertyChange("videoArchiveSet", this.videoArchiveSet, videoArchiveSet);
        this.videoArchiveSet = videoArchiveSet;
    }

    public List _persistence_get_videoFrames() {
        this._persistence_checkFetched("videoFrames");
        return this.videoFrames;
    }

    public void _persistence_set_videoFrames(List list) {
        this._persistence_checkFetchedForSet("videoFrames");
        this._persistence_propertyChange("videoFrames", this.videoFrames, list);
        this.videoFrames = list;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this._persistence_propertyChange("name", this.name, string);
        this.name = string;
    }

    public Long _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(Long l) {
        this._persistence_checkFetchedForSet("id");
        this._persistence_propertyChange("id", this.id, l);
        this.id = l;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this._persistence_listener;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._persistence_listener = propertyChangeListener;
    }

    public void _persistence_propertyChange(String string, Object object, Object object2) {
        if (this._persistence_listener != null && object != object2) {
            this._persistence_listener.propertyChange(new PropertyChangeEvent(this, string, object, object2));
        }
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }

    private class EmptyVideoFramePredicate
    implements Predicate<VideoFrame> {
        private EmptyVideoFramePredicate() {
        }

        public boolean apply(VideoFrame input) {
            return input.getObservations().size() == 0;
        }
    }
}

