/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.jpa;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import vars.VARSPersistenceException;
import vars.annotation.AnnotationFactory;
import vars.annotation.Association;
import vars.annotation.CameraDeployment;
import vars.annotation.FormatCodes;
import vars.annotation.Observation;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoArchiveSet;
import vars.annotation.VideoFrame;
import vars.annotation.jpa.VideoArchiveImpl;
import vars.jpa.DAO;
import vars.jpa.JPAEntity;
import vars.knowledgebase.Concept;

public class VideoArchiveDAOImpl
extends DAO
implements VideoArchiveDAO {
    private final AnnotationFactory annotationFactory;

    @Inject
    public VideoArchiveDAOImpl(EntityManager entityManager, AnnotationFactory annotationFactory) {
        super(entityManager);
        this.annotationFactory = annotationFactory;
    }

    public Set<String> findAllLinkValues(VideoArchive videoArchive, String linkName) {
        return this.findAllLinkValues(videoArchive, linkName, null);
    }

    public Set<String> findAllLinkValues(VideoArchive videoArchive, String linkName, Concept concept) {
        videoArchive = this.find(videoArchive);
        List videoFrames = videoArchive.getVideoArchiveSet().getVideoFrames();
        HashSet<String> linkValues = new HashSet<String>();
        for (VideoFrame videoFrame : videoFrames) {
            for (Observation observation : videoFrame.getObservations()) {
                if (concept != null && concept.getConceptName(observation.getConceptName()) == null) continue;
                for (Association association : observation.getAssociations()) {
                    if (!linkName.equals(association.getLinkName())) continue;
                    linkValues.add(association.getLinkValue());
                }
            }
        }
        return linkValues;
    }

    public VideoArchive findOrCreateByParameters(String platform, int sequenceNumber, String videoArchiveName) {
        VideoArchive videoArchive = this.findByName(videoArchiveName);
        if (videoArchive == null) {
            VideoArchiveSet videoArchiveSet = null;
            HashMap<String, Object> params2 = new HashMap<String, Object>();
            params2.put("platformName", platform);
            params2.put("sequenceNumber", sequenceNumber);
            List vas = this.findByNamedQuery("VideoArchiveSet.findByPlatformAndSequenceNumber", params2);
            if (vas.size() == 1) {
                videoArchiveSet = (VideoArchiveSet)vas.get(0);
            } else {
                if (vas.size() > 1) {
                    throw new VARSPersistenceException("There's a problem!! More than one VideoArchiveSet with platform = " + platform + " and sequenceNumber = " + sequenceNumber + " exists in the database");
                }
                videoArchiveSet = this.annotationFactory.newVideoArchiveSet();
                videoArchiveSet.setPlatformName(platform);
                videoArchiveSet.setFormatCode(FormatCodes.UNKNOWN.getCode());
                this.persist(videoArchiveSet);
                CameraDeployment cameraDeployment = this.annotationFactory.newCameraDeployment();
                cameraDeployment.setSequenceNumber(Integer.valueOf(sequenceNumber));
                videoArchiveSet.addCameraDeployment(cameraDeployment);
                this.persist(cameraDeployment);
            }
            videoArchive = this.annotationFactory.newVideoArchive();
            videoArchive.setName(videoArchiveName);
            videoArchiveSet.addVideoArchive(videoArchive);
            this.persist(videoArchive);
        }
        return videoArchive;
    }

    public VideoArchive findByName(final String name) {
        VideoArchive videoArchive = null;
        HashMap<String, Object> params = new HashMap<String, Object>(){
            {
                this.put("name", name);
            }
        };
        List videoArchives = this.findByNamedQuery("VideoArchive.findByName", (Map<String, Object>)params);
        if (videoArchives.size() == 1) {
            videoArchive = (VideoArchive)videoArchives.get(0);
        } else if (videoArchives.size() > 1) {
            throw new VARSPersistenceException("There's a problem!! More than one VideoArchive named " + name + " exists in the database");
        }
        return videoArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoArchive deleteEmptyVideoFrames(VideoArchive videoArchive) {
        Collection emptyFrames = videoArchive.getEmptyVideoFrames();
        int n = 0;
        boolean doFetch = emptyFrames.size() > 0;
        for (VideoFrame videoFrame : emptyFrames) {
            videoArchive.removeVideoFrame(videoFrame);
            ++n;
        }
        if (doFetch) {
            try {
                for (VideoFrame videoFrame : emptyFrames) {
                    this.remove(videoFrame);
                }
                this.log.debug("Deleted " + n + " empty VideoFrames from " + videoArchive);
            }
            finally {
                videoArchive = (VideoArchive)this.findByPrimaryKey(videoArchive.getClass(), ((JPAEntity)videoArchive).getId());
            }
        }
        return videoArchive;
    }

    public VideoArchive findByPrimaryKey(Object primaryKey) {
        return this.findByPrimaryKey(VideoArchiveImpl.class, primaryKey);
    }
}

