/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.jpa;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import vars.annotation.Observation;
import vars.annotation.ObservationDAO;
import vars.annotation.jpa.ObservationImpl;
import vars.jpa.DAO;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptName;

public class ObservationDAOImpl
extends DAO
implements ObservationDAO {
    @Inject
    public ObservationDAOImpl(EntityManager entityManager) {
        super(entityManager);
    }

    public List<Observation> findAllByConceptName(String conceptName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conceptName", conceptName);
        return this.findByNamedQuery("Observation.findByConceptName", map);
    }

    public List<Observation> findAllByConcept_(Concept concept, boolean cascade, ConceptDAO conceptDAO) {
        HashSet conceptNames = null;
        if (cascade) {
            conceptNames = conceptDAO.findDescendentNames(concept);
        } else {
            conceptNames = new HashSet();
            conceptNames.addAll(concept.getConceptNames());
        }
        StringBuilder sb = new StringBuilder("SELECT o FROM Observation o WHERE o.conceptName IN (");
        int n = 0;
        for (ConceptName cn : conceptNames) {
            sb.append("'").append(cn.getName()).append("'");
            if (n < conceptNames.size() - 1) {
                sb.append(", ");
            }
            ++n;
        }
        sb.append(")");
        Query query = this.getEntityManager().createQuery(sb.toString());
        List observations = query.getResultList();
        return observations;
    }

    public List<Observation> findAllByConcept(Concept concept, boolean cascade, ConceptDAO conceptDAO) {
        HashSet conceptNames = null;
        if (cascade) {
            conceptNames = conceptDAO.findDescendentNames(concept);
        } else {
            conceptNames = new HashSet();
            conceptNames.addAll(concept.getConceptNames());
        }
        StringBuilder sb = new StringBuilder("SELECT o FROM Observation o WHERE o.conceptName IN (");
        int n = 1;
        for (Object cn : conceptNames) {
            sb.append("?" + n);
            if (n <= conceptNames.size() - 1) {
                sb.append(", ");
            }
            ++n;
        }
        sb.append(")");
        Query query = this.getEntityManager().createQuery(sb.toString());
        n = 1;
        for (ConceptName cn : conceptNames) {
            query.setParameter(n, (Object)cn.getName());
            ++n;
        }
        List observations = query.getResultList();
        return observations;
    }

    public Observation updateFields(Observation observation) {
        Observation original = observation;
        if (observation != null && (original = this.find(observation)) != null) {
            original.setConceptName(observation.getConceptName());
            original.setNotes(observation.getNotes());
            original.setObservationDate(observation.getObservationDate());
            original.setObserver(observation.getObserver());
            original.setX(observation.getX());
            original.setY(observation.getY());
        }
        return original;
    }

    public List<String> findAllConceptNamesUsedInAnnotations() {
        EntityManager entityManager = this.getEntityManager();
        String sql = "SELECT DISTINCT conceptName FROM Observation";
        Query query = entityManager.createNativeQuery(sql);
        List conceptNames = query.getResultList();
        sql = "SELECT DISTINCT toConcept FROM Association";
        query = entityManager.createNativeQuery(sql);
        conceptNames.addAll(query.getResultList());
        return conceptNames;
    }

    public void validateName(Observation object, ConceptDAO conceptDAO) {
        Concept concept = conceptDAO.findByName(object.getConceptName());
        if (concept != null) {
            object.setConceptName(concept.getPrimaryConceptName().getName());
        } else {
            this.log.warn(object + " contains a 'conceptName', " + object.getConceptName() + " that was not found in the knowlegebase");
        }
    }

    public Observation findByPrimaryKey(Object primaryKey) {
        return this.findByPrimaryKey(ObservationImpl.class, primaryKey);
    }
}

