/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.jpa;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import vars.annotation.CameraData;
import vars.annotation.CameraDataDAO;
import vars.annotation.jpa.CameraDataImpl;
import vars.jpa.DAO;

public class CameraDataDAOImpl
extends DAO
implements CameraDataDAO {
    @Inject
    public CameraDataDAOImpl(EntityManager entityManager) {
        super(entityManager);
    }

    public CameraData findByImageReference(String imageReference) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("imageReference", imageReference);
        List data = this.findByNamedQuery("CameraData.findByImageReference", params);
        if (data.size() > 1) {
            this.log.warn("More than one CameraData object contains " + imageReference + ". Returning the first one");
        }
        return data.size() == 0 ? null : (CameraData)data.get(0);
    }

    public List<CameraData> findByImageReferenceContaining(String s) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("imageReference", "%" + s + "%");
        return this.findByNamedQuery("CameraData.findByImageReferenceLike", params);
    }

    public List<CameraData> findByImageReferencePostfix(String postfix) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("imageReference", "%" + postfix);
        return this.findByNamedQuery("CameraData.findByImageReferenceLike", params);
    }

    public List<CameraData> findByImageReferencePrefix(String prefix) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("imageReference", prefix + "%");
        return this.findByNamedQuery("CameraData.findByImageReferenceLike", params);
    }

    public CameraData findByPrimaryKey(Object primaryKey) {
        return this.findByPrimaryKey(CameraDataImpl.class, primaryKey);
    }
}

