/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation.jpa;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import vars.DAO;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.AnnotationFactory;
import vars.annotation.AssociationDAO;
import vars.annotation.CameraDataDAO;
import vars.annotation.CameraDeploymentDAO;
import vars.annotation.ObservationDAO;
import vars.annotation.PhysicalDataDAO;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoArchiveSetDAO;
import vars.annotation.VideoFrameDAO;
import vars.annotation.jpa.AssociationDAOImpl;
import vars.annotation.jpa.CameraDataDAOImpl;
import vars.annotation.jpa.CameraDeploymentDAOImpl;
import vars.annotation.jpa.ObservationDAOImpl;
import vars.annotation.jpa.PhysicalDataDAOImpl;
import vars.annotation.jpa.VideoArchiveDAOImpl;
import vars.annotation.jpa.VideoArchiveSetDAOImpl;
import vars.annotation.jpa.VideoFrameDAOImpl;
import vars.jpa.EntityManagerFactoryAspect;

public class AnnotationDAOFactoryImpl
implements AnnotationDAOFactory,
EntityManagerFactoryAspect {
    private final AnnotationFactory annotationFactory;
    private final EntityManagerFactory entityManagerFactory;

    @Inject
    public AnnotationDAOFactoryImpl(@Named(value="annotationPersistenceUnit") EntityManagerFactory entityManagerFactory, AnnotationFactory annotationFactory) {
        this.entityManagerFactory = entityManagerFactory;
        this.annotationFactory = annotationFactory;
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public AssociationDAO newAssociationDAO() {
        return new AssociationDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public AssociationDAO newAssociationDAO(EntityManager entityManager) {
        return new AssociationDAOImpl(entityManager);
    }

    public CameraDataDAO newCameraDataDAO() {
        return new CameraDataDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public CameraDataDAO newCameraDataDAO(EntityManager entityManager) {
        return new CameraDataDAOImpl(entityManager);
    }

    public CameraDeploymentDAO newCameraDeploymentDAO() {
        return new CameraDeploymentDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public CameraDeploymentDAO newCameraDeploymentDAO(EntityManager entityManager) {
        return new CameraDeploymentDAOImpl(entityManager);
    }

    public DAO newDAO() {
        return new vars.jpa.DAO(this.entityManagerFactory.createEntityManager());
    }

    public DAO newDAO(EntityManager entityManager) {
        return new vars.jpa.DAO(entityManager);
    }

    public ObservationDAO newObservationDAO() {
        return new ObservationDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public ObservationDAO newObservationDAO(EntityManager entityManager) {
        return new ObservationDAOImpl(entityManager);
    }

    public PhysicalDataDAO newPhysicalDataDAO() {
        return new PhysicalDataDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public PhysicalDataDAO newPhysicalDataDAO(EntityManager entityManager) {
        return new PhysicalDataDAOImpl(entityManager);
    }

    public VideoArchiveDAO newVideoArchiveDAO() {
        return new VideoArchiveDAOImpl(this.entityManagerFactory.createEntityManager(), this.annotationFactory);
    }

    public VideoArchiveDAO newVideoArchiveDAO(EntityManager entityManager) {
        return new VideoArchiveDAOImpl(entityManager, this.annotationFactory);
    }

    public VideoArchiveSetDAO newVideoArchiveSetDAO() {
        return new VideoArchiveSetDAOImpl(this.entityManagerFactory.createEntityManager(), this.annotationFactory);
    }

    public VideoArchiveSetDAO newVideoArchiveSetDAO(EntityManager entityManager) {
        return new VideoArchiveSetDAOImpl(entityManager, this.annotationFactory);
    }

    public VideoFrameDAO newVideoFrameDAO() {
        return new VideoFrameDAOImpl(this.entityManagerFactory.createEntityManager());
    }

    public VideoFrameDAO newVideoFrameDAO(EntityManager entityManager) {
        return new VideoFrameDAOImpl(entityManager);
    }
}

