/*
 * Decompiled with CFR 0.152.
 */
package vars.annotation;

import com.google.common.collect.Collections2;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.mbari.sql.QueryFunction;
import org.mbari.sql.QueryableImpl;
import org.mbari.text.IgnoreCaseToStringComparator;
import org.mbari.util.stream.StreamUtilities;
import vars.CacheClearedEvent;
import vars.CacheClearedListener;
import vars.DAO;
import vars.PersistenceCache;
import vars.VARSException;
import vars.annotation.AnnotationDAOFactory;
import vars.annotation.AnnotationPersistenceService;
import vars.annotation.Observation;
import vars.annotation.ObservationDAO;
import vars.annotation.VideoArchive;
import vars.annotation.VideoArchiveDAO;
import vars.annotation.VideoArchiveSet;
import vars.knowledgebase.Concept;
import vars.knowledgebase.ConceptDAO;
import vars.knowledgebase.ConceptName;
import vars.knowledgebase.LinkTemplate;
import vars.knowledgebase.jpa.ConceptDAOImpl;
import vars.knowledgebase.jpa.LinkTemplateDAOImpl;

public class AnnotationPersistenceServiceImpl
extends QueryableImpl
implements AnnotationPersistenceService {
    private static final String jdbcDriver;
    private static final String jdbcPassword;
    private static final String jdbcUrl;
    private static final String jdbcUsername;
    private final ThreadLocal<EntityManager> readOnlyEntityManagers = new ThreadLocal();
    private final EntityManagerFactory kbEntityManagerFactory;
    private final AnnotationDAOFactory annotationDAOFactory;
    private final PersistenceCache persistenceCache;
    private final Map<Concept, List<String>> descendantNameCache = Collections.synchronizedMap(new HashMap());

    @Inject
    public AnnotationPersistenceServiceImpl(AnnotationDAOFactory annotationDAOFactory, @Named(value="knowledgebasePersistenceUnit") EntityManagerFactory kbEntityManagerFactory, PersistenceCache persistenceCache) {
        super(jdbcUrl, jdbcUsername, jdbcPassword, jdbcDriver);
        this.annotationDAOFactory = annotationDAOFactory;
        this.kbEntityManagerFactory = kbEntityManagerFactory;
        this.persistenceCache = persistenceCache;
    }

    public List<String> findDescendantNamesFor(Concept concept) {
        List<String> desendantNames = this.descendantNameCache.get(concept);
        if (desendantNames == null && concept != null) {
            Collection names = this.getReadOnlyConceptDAO().findDescendentNames(concept);
            Collection namesAsStrings = Collections2.transform((Collection)names, from -> from.getName());
            desendantNames = new ArrayList<String>(namesAsStrings);
            Collections.sort(desendantNames, new IgnoreCaseToStringComparator());
            this.descendantNameCache.put(concept, desendantNames);
        }
        if (desendantNames == null) {
            desendantNames = new ArrayList<String>();
        }
        return desendantNames;
    }

    public Concept findConceptByName(String name) {
        Concept concept = this.getReadOnlyConceptDAO().findByName(name);
        for (Concept child : concept.getChildConcepts()) {
            child.getChildConcepts();
        }
        return concept;
    }

    public Concept findRootConcept() {
        Concept concept = this.getReadOnlyConceptDAO().findRoot();
        for (Concept child : concept.getChildConcepts()) {
            child.getChildConcepts();
        }
        return concept;
    }

    public ConceptDAO getReadOnlyConceptDAO() {
        EntityManager entityManager = this.getReadOnlyEntityManager();
        return new ConceptDAOImpl(entityManager);
    }

    private EntityManager getReadOnlyEntityManager() {
        EntityManager entityManager = this.readOnlyEntityManagers.get();
        if (entityManager == null || !entityManager.isOpen()) {
            entityManager = this.kbEntityManagerFactory.createEntityManager();
            vars.jpa.DAO dao = new vars.jpa.DAO(entityManager);
            dao.startTransaction();
            this.persistenceCache.addCacheClearedListener((CacheClearedListener)new MyCacheClearedListener(dao));
            this.readOnlyEntityManagers.set(entityManager);
        }
        return entityManager;
    }

    public Collection<LinkTemplate> findLinkTemplatesFor(Concept concept) {
        LinkTemplateDAOImpl dao = new LinkTemplateDAOImpl(this.getReadOnlyEntityManager());
        concept = (Concept)dao.find(concept);
        Collection linkTemplates = dao.findAllApplicableToConcept(concept);
        return linkTemplates;
    }

    public Collection<String> findAllReferenceNumbers(VideoArchiveSet videoArchiveSet, Concept concept) {
        VideoArchiveDAO dao = this.annotationDAOFactory.newVideoArchiveDAO();
        dao.startTransaction();
        TreeSet<String> referenceNumbers = new TreeSet<String>();
        for (VideoArchive videoArchive : new ArrayList(videoArchiveSet.getVideoArchives())) {
            Set values = dao.findAllLinkValues(videoArchive, "identity-reference", concept);
            for (String string : values) {
                referenceNumbers.add(string);
            }
        }
        dao.endTransaction();
        dao.close();
        return referenceNumbers;
    }

    public Collection<Observation> findAllObservationsByNameAndReferenceNumber(VideoArchive videoArchive, String conceptName, int referenceNumber) {
        String sql = "SELECT obs.id FROM VideoArchive AS va LEFT OUTER JOIN VideoFrame AS vf ON va.id = vf.VideoArchiveID_FK LEFT OUTER JOIN Observation as obs ON vf.id = obs.VideoFrameID_FK LEFT OUTER JOIN Association as ass ON obs.id = ass.ObservationID_FK WHERE va.videoArchiveName = '" + videoArchive.getName() + "' AND obs.ConceptName = '" + conceptName + "' AND ass.LinkName = 'identity-reference' AND ass.linkValue = '" + referenceNumber + "'";
        QueryFunction<Collection<Long>> queryFunction = new QueryFunction<Collection<Long>>(){

            public Collection<Long> apply(ResultSet resultSet) throws SQLException {
                ArrayList<Long> ids = new ArrayList<Long>();
                while (resultSet.next()) {
                    ids.add(resultSet.getLong(1));
                }
                return ids;
            }
        };
        Collection ids = (Collection)this.executeQueryFunction(sql, (QueryFunction)queryFunction);
        ArrayList<Observation> observations = new ArrayList<Observation>();
        ObservationDAO dao = this.annotationDAOFactory.newObservationDAO();
        dao.startTransaction();
        for (Long id : ids) {
            Observation obs = dao.findByPrimaryKey((Object)id);
            if (obs == null) continue;
            observations.add(obs);
        }
        dao.endTransaction();
        return observations;
    }

    public List<String> findAllVideoArchiveNames() {
        String sql = "SELECT VideoArchiveName FROM VideoArchive ORDER BY VideoArchiveName";
        QueryFunction<List<String>> queryFunction = new QueryFunction<List<String>>(){

            public List<String> apply(ResultSet resultSet) throws SQLException {
                ArrayList<String> names = new ArrayList<String>();
                while (resultSet.next()) {
                    names.add(resultSet.getString(1));
                }
                return names;
            }
        };
        return (List)this.executeQueryFunction(sql, (QueryFunction)queryFunction);
    }

    public List<String> findAllPlatformNames() {
        String sql = "SELECT DISTINCT PlatformName FROM VideoArchiveSet ORDER BY PlatformName";
        QueryFunction<List<String>> queryFunction = new QueryFunction<List<String>>(){

            public List<String> apply(ResultSet resultSet) throws SQLException {
                ArrayList<String> platformNames = new ArrayList<String>();
                while (resultSet.next()) {
                    platformNames.add(resultSet.getString(1));
                }
                return platformNames;
            }
        };
        return (List)this.executeQueryFunction(sql, (QueryFunction)queryFunction);
    }

    public void updateConceptNameUsedByAnnotations(Concept concept) {
        String primaryName = concept.getPrimaryConceptName().getName();
        ArrayList conceptNames = new ArrayList(concept.getConceptNames());
        conceptNames.remove(concept.getPrimaryConceptName());
        String sql1 = "UPDATE Observation SET ConceptName = ? WHERE ConceptName = ?";
        String sql2 = "UPDATE Association SET ToConcept = ? WHERE ToConcept = ?";
        try {
            Connection connection = this.getConnection();
            PreparedStatement preparedStatement1 = connection.prepareStatement(sql1);
            PreparedStatement preparedStatement2 = connection.prepareStatement(sql2);
            for (ConceptName conceptName : conceptNames) {
                preparedStatement1.setString(1, primaryName);
                preparedStatement1.setString(2, conceptName.getName());
                preparedStatement1.addBatch();
                preparedStatement2.setString(1, primaryName);
                preparedStatement2.setString(2, conceptName.getName());
                preparedStatement2.addBatch();
            }
            preparedStatement1.executeBatch();
            preparedStatement2.executeBatch();
            preparedStatement1.close();
            preparedStatement2.close();
        }
        catch (Exception e) {
            throw new VARSException("Failed to update concept-names used by annotations", (Throwable)e);
        }
    }

    public java.util.Date findEarliestAnnotationDate() {
        String sql = "SELECT min(RecordedDTG) FROM VideoFrame";
        QueryFunction<java.util.Date> queryFunction = new QueryFunction<java.util.Date>(){

            public java.util.Date apply(ResultSet resultSet) throws SQLException {
                Date earliestDate = null;
                if (resultSet.next()) {
                    earliestDate = resultSet.getDate(1);
                }
                return earliestDate;
            }
        };
        return (java.util.Date)this.executeQueryFunction(sql, (QueryFunction)queryFunction);
    }

    public java.util.Date findLatestAnnotationDate() {
        String sql = "SELECT max(RecordedDTG) FROM VideoFrame";
        QueryFunction<java.util.Date> queryFunction = new QueryFunction<java.util.Date>(){

            public java.util.Date apply(ResultSet resultSet) throws SQLException {
                Date earliestDate = null;
                if (resultSet.next()) {
                    earliestDate = resultSet.getDate(1);
                }
                return earliestDate;
            }
        };
        return (java.util.Date)this.executeQueryFunction(sql, (QueryFunction)queryFunction);
    }

    public Long findTimeCodeByVideoArchiveName(String timecode, String videoArchiveName) {
        String sql = "SELECT VideoFrame.id FROM VideoFrame RIGHT OUTER JOIN VideoArchive ON VideoFrame.VideoArchiveID_FK = VideoArchive.id WHERE VideoArchive.videoArchiveName = '" + videoArchiveName + "' AND VideoFrame.TapeTimeCode = '" + timecode + "'";
        QueryFunction queryFunction = resultSet -> {
            Long id = null;
            if (resultSet.next()) {
                id = resultSet.getLong(1);
            }
            return id;
        };
        return (Long)this.executeQueryFunction(sql, queryFunction);
    }

    public List<String> findAllCameraPlatforms() {
        ArrayList<String> cameraPlatforms = new ArrayList<String>();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("annotation-app", Locale.US);
            List cps = StreamUtilities.toStream(bundle.getKeys()).filter(s -> s.startsWith("cameraplatform")).map(bundle::getString).collect(Collectors.toList());
            cameraPlatforms.addAll(cps);
        }
        catch (Exception e) {
            this.log.debug("Failed to load camera platforms from annotation-app.properties", (Throwable)e);
        }
        String sql = "SELECT DISTINCT PlatformName FROM VideoArchiveSet";
        QueryFunction queryFunction = resultSet -> {
            ArrayList<String> cps = new ArrayList<String>();
            while (resultSet.next()) {
                cps.add(resultSet.getString(1));
            }
            return cps;
        };
        try {
            cameraPlatforms.addAll((Collection)this.executeQueryFunction(sql, queryFunction));
        }
        catch (Exception e) {
            this.log.debug("Failed to fetch cameraplatforms from database", (Throwable)e);
        }
        cameraPlatforms = new ArrayList(new HashSet(cameraPlatforms));
        Collections.sort(cameraPlatforms);
        return cameraPlatforms;
    }

    static {
        ResourceBundle bundle = ResourceBundle.getBundle("annotation-jdbc", Locale.US);
        jdbcUrl = bundle.getString("jdbc.url");
        jdbcUsername = bundle.getString("jdbc.username");
        jdbcPassword = bundle.getString("jdbc.password");
        jdbcDriver = bundle.getString("jdbc.driver");
    }

    private class MyCacheClearedListener
    implements CacheClearedListener {
        private final DAO dao;

        public MyCacheClearedListener(DAO dao) {
            this.dao = dao;
        }

        public void afterClear(CacheClearedEvent evt) {
            this.dao.startTransaction();
        }

        public void beforeClear(CacheClearedEvent evt) {
            this.dao.endTransaction();
            this.dao.close();
            AnnotationPersistenceServiceImpl.this.descendantNameCache.clear();
        }
    }
}

