/*
 * Decompiled with CFR 0.152.
 */
package vars;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.mbari.math.Matlib;
import org.mbari.movie.Timecode;
import org.mbari.sql.QueryFunction;
import org.mbari.sql.QueryableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vars.ExternalDataPersistenceService;
import vars.VARSException;
import vars.VideoMoment;
import vars.VideoMomentBean;
import vars.VideoMomentByDateComparator;

public class EXPDPersistenceService
extends QueryableImpl
implements ExternalDataPersistenceService {
    public static final int SAMPLERATE_MILLSEC = 15000;
    private static final Calendar CALENDAR = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final DateFormat dateFormatUTC = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"){
        {
            this.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    };
    private final Predicate<VideoMoment> nonNullTimecodePredicate = new Predicate<VideoMoment>(){

        public boolean apply(VideoMoment arg0) {
            return arg0.getTimecode() != null;
        }
    };
    private final Predicate<VideoMoment> nonNullAlternateTimecodePredicate = new Predicate<VideoMoment>(){

        public boolean apply(VideoMoment arg0) {
            return arg0.getAlternateTimecode() != null;
        }
    };
    private final ThreadLocal<Connection> connections = new ThreadLocal();
    private static final ResourceBundle bundle = ResourceBundle.getBundle("annotation-jdbc", Locale.US);

    public EXPDPersistenceService() {
        super(bundle.getString("jdbc.url"), bundle.getString("jdbc.username"), bundle.getString("jdbc.password"), bundle.getString("jdbc.driver"));
        try {
            Class.forName(bundle.getString("jdbc.driver"));
        }
        catch (ClassNotFoundException ex) {
            throw new VARSException("Failed to initialize driver class:" + bundle.getString("jdbc.driver"), (Throwable)ex);
        }
    }

    public VideoMoment findTimecodeNearDate(String platform, Date date, int millisecTolerance) {
        List<VideoMoment> tapeTimes = this.findTimecodesNearDate(platform, date, millisecTolerance);
        VideoMoment nearestDateTimecode = null;
        long dtMin = Long.MAX_VALUE;
        for (VideoMoment tapeTime : tapeTimes) {
            Date d = tapeTime.getRecordedDate();
            long dt = Math.abs(d.getTime() - date.getTime());
            if (dt >= dtMin) continue;
            dtMin = dt;
            nearestDateTimecode = tapeTime;
        }
        return nearestDateTimecode;
    }

    public List<VideoMoment> findTimecodesNearDate(String platform, Date date, int millisecTolerance) {
        QueryFunction<List<VideoMoment>> queryFunction = new QueryFunction<List<VideoMoment>>(){

            public List<VideoMoment> apply(ResultSet resultSet) throws SQLException {
                ArrayList<VideoMoment> dateTimecodes = new ArrayList<VideoMoment>();
                while (resultSet.next()) {
                    Timestamp rovDate = resultSet.getTimestamp(1, CALENDAR);
                    String timecode = resultSet.getString(2);
                    String alternateTimecode = resultSet.getString(3);
                    if (EXPDPersistenceService.this.log.isDebugEnabled()) {
                        EXPDPersistenceService.this.log.debug("Found record: \n\tUTC Date:           " + EXPDPersistenceService.this.dateFormatUTC.format(rovDate) + "\n\tTimecode:           " + timecode + "\n\tAlternate Timecode: " + alternateTimecode);
                    }
                    dateTimecodes.add((VideoMoment)new VideoMomentBean((Date)rovDate, timecode, alternateTimecode));
                }
                return dateTimecodes;
            }
        };
        String table = platform + "CamlogData";
        Date startDate = new Date(date.getTime() - (long)millisecTolerance);
        Date endDate = new Date(date.getTime() + (long)millisecTolerance);
        String sql = "SELECT DateTimeGMT, betaTimecode, hdTimecode  FROM " + table + " WHERE DateTimeGMT BETWEEN '" + this.dateFormatUTC.format(startDate) + "' AND '" + this.dateFormatUTC.format(endDate) + "' ORDER BY DateTimeGMT";
        return (List)this.executeQueryFunction(sql, (QueryFunction)queryFunction);
    }

    public VideoMoment interpolateTimecodeByDate(String cameraIdentifier, Date date, int millisecTolerance, double frameRate) {
        List<VideoMoment> videoTimes = this.findTimecodesNearDate(cameraIdentifier, date, millisecTolerance);
        VideoMomentBean returnTapeTime = null;
        if (videoTimes.size() > 1) {
            Timecode timecode = null;
            ArrayList nonNullTimecodes = new ArrayList(Collections2.filter(videoTimes, this.nonNullTimecodePredicate));
            Collections.sort(nonNullTimecodes, new VideoMomentByDateComparator());
            BigDecimal[] dates = new BigDecimal[nonNullTimecodes.size()];
            BigDecimal[] frames = new BigDecimal[nonNullTimecodes.size()];
            for (int i = 0; i < nonNullTimecodes.size(); ++i) {
                VideoMoment tapeTime = (VideoMoment)nonNullTimecodes.get(i);
                dates[i] = new BigDecimal(tapeTime.getRecordedDate().getTime());
                Timecode tc = new Timecode(tapeTime.getTimecode(), frameRate);
                frames[i] = new BigDecimal(tc.getFrames());
            }
            BigDecimal[] iFrame = Matlib.interpolate((BigDecimal[])dates, (BigDecimal[])frames, (BigDecimal[])new BigDecimal[]{new BigDecimal(date.getTime())});
            if (iFrame != null && iFrame.length > 0 && iFrame[0] != null) {
                timecode = new Timecode(iFrame[0].doubleValue(), frameRate);
            }
            Timecode alternateTimecode = null;
            ArrayList nonNullAltTimecodes = new ArrayList(Collections2.filter(videoTimes, this.nonNullAlternateTimecodePredicate));
            Collections.sort(nonNullAltTimecodes, new VideoMomentByDateComparator());
            dates = new BigDecimal[nonNullAltTimecodes.size()];
            frames = new BigDecimal[nonNullAltTimecodes.size()];
            for (int i = 0; i < nonNullAltTimecodes.size(); ++i) {
                VideoMoment tapeTime = (VideoMoment)nonNullAltTimecodes.get(i);
                dates[i] = new BigDecimal(tapeTime.getRecordedDate().getTime());
                Timecode tc = new Timecode(tapeTime.getTimecode(), frameRate);
                frames[i] = new BigDecimal(tc.getFrames());
            }
            iFrame = Matlib.interpolate((BigDecimal[])dates, (BigDecimal[])frames, (BigDecimal[])new BigDecimal[]{new BigDecimal(date.getTime())});
            if (iFrame != null && iFrame.length > 0 && iFrame[0] != null) {
                alternateTimecode = new Timecode(iFrame[0].doubleValue(), frameRate);
            }
            String tc = timecode == null ? "--:--:--:--" : timecode.toString();
            String altTc = alternateTimecode == null ? "--:--:--:--" : alternateTimecode.toString();
            returnTapeTime = new VideoMomentBean(date, tc, altTc);
        }
        return returnTapeTime;
    }
}

