/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.vcr4j.adapter.noop;

import java.util.Optional;
import org.mbari.vcr4j.VideoCommand;
import org.mbari.vcr4j.VideoIO;
import org.mbari.vcr4j.VideoIndex;
import org.mbari.vcr4j.adapter.noop.NoopVideoError;
import org.mbari.vcr4j.adapter.noop.NoopVideoState;
import org.mbari.vcr4j.commands.VideoCommands;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class NoopVideoIO
implements VideoIO<NoopVideoState, NoopVideoError> {
    private final Subject<VideoCommand, VideoCommand> commandSubject = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<VideoIndex, VideoIndex> indexObservable = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<NoopVideoState, NoopVideoState> stateObservable = new SerializedSubject((Subject)PublishSubject.create());
    private final Subject<NoopVideoError, NoopVideoError> errorObservable = new SerializedSubject((Subject)PublishSubject.create());
    public static final NoopVideoState STATE = new NoopVideoState();
    public static final NoopVideoError ERROR = new NoopVideoError();
    public static final VideoIndex INDEX = new VideoIndex(Optional.empty(), Optional.empty(), Optional.empty());

    public NoopVideoIO() {
        this.commandSubject.filter(vc -> vc.equals(VideoCommands.REQUEST_STATUS)).forEach(vc -> this.stateObservable.onNext((Object)STATE));
        this.commandSubject.filter(vc -> vc.equals(VideoCommands.REQUEST_INDEX) || vc.equals(VideoCommands.REQUEST_ELAPSED_TIME) || vc.equals(VideoCommands.REQUEST_TIMECODE) || vc.equals(VideoCommands.REQUEST_TIMESTAMP)).forEach(vc -> this.indexObservable.onNext((Object)INDEX));
    }

    public void close() {
        this.commandSubject.onCompleted();
        this.indexObservable.onCompleted();
        this.stateObservable.onCompleted();
        this.errorObservable.onCompleted();
    }

    public <A extends VideoCommand> void send(A videoCommand) {
        this.commandSubject.onNext(videoCommand);
    }

    public Subject<VideoCommand, VideoCommand> getCommandSubject() {
        return this.commandSubject;
    }

    public String getConnectionID() {
        return "not connected";
    }

    public Observable<NoopVideoError> getErrorObservable() {
        return this.errorObservable;
    }

    public Observable<NoopVideoState> getStateObservable() {
        return this.stateObservable;
    }

    public Observable<VideoIndex> getIndexObservable() {
        return this.indexObservable;
    }
}

